/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.internal.languages.javascript;

import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.eclipse.e4.internal.languages.javascript.JSBundleContext;
import org.eclipse.e4.internal.languages.javascript.JSBundleData;
import org.eclipse.e4.internal.languages.javascript.JSExportPackage;
import org.eclipse.e4.internal.languages.javascript.JSFrameworkImpl;
import org.eclipse.e4.internal.languages.javascript.JSImportPackage;
import org.eclipse.e4.internal.languages.javascript.JSRequireBundle;
import org.eclipse.e4.languages.javascript.JSBundle;
import org.mozilla.javascript.Callable;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.ContextAction;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.Scriptable;
import org.osgi.framework.Version;

public class JSBundleImpl
implements JSBundle {
    private static final String ACTIVATOR_STOP_METHOD = "stop";
    private static final String ACTIVATOR_START_METHOD = "start";
    private String symbolicName;
    private Version version;
    private List imports;
    private List requires;
    private List exports;
    private boolean singleton = false;
    private boolean markedStarted = false;
    private int state;
    Scriptable scope;
    private JSFrameworkImpl framework;
    private JSBundleData bundleData;
    JSBundleContext bundleContext;
    Scriptable activator;

    public JSBundleImpl(JSFrameworkImpl framework, JSBundleData bundleData) {
        this.framework = framework;
        this.bundleData = bundleData;
        this.state = 2;
        Map headers = bundleData.getHeaders();
        this.parseSymbolicName((String)headers.get("Bundle-SymbolicName"));
        this.parseVersion((String)headers.get("Bundle-Version"));
        this.parseImports((String)headers.get("Import-Package"));
        this.parseExports((String)headers.get("Export-Package"));
        this.parseRequires((String)headers.get("Require-Bundle"));
    }

    public String getSymbolicName() {
        return this.symbolicName;
    }

    public Version getVersion() {
        return this.version;
    }

    public List getImports() {
        return this.imports;
    }

    public List getRequires() {
        return this.requires;
    }

    public List getExports() {
        return this.exports;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.symbolicName == null ? 0 : this.symbolicName.hashCode());
        result = 31 * result + (this.version == null ? 0 : this.version.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        JSBundleImpl other = (JSBundleImpl)obj;
        if (this.symbolicName == null ? other.symbolicName != null : !this.symbolicName.equals(other.symbolicName)) {
            return false;
        }
        return !(this.version == null ? other.version != null : !this.version.equals((Object)other.version));
    }

    /*
     * Unable to fully structure code
     */
    private void parseSymbolicName(String symbolicNameHeader) {
        if (symbolicNameHeader == null) {
            throw new IllegalArgumentException("Bundle-SymbolicName cannot be null");
        }
        tokenizer = new StringTokenizer(symbolicNameHeader, ";");
        this.symbolicName = tokenizer.nextToken().trim();
        if (this.symbolicName.length() != 0) ** GOTO lbl17
        throw new IllegalArgumentException("Illegal Bundle-SymbolicName");
lbl-1000:
        // 1 sources

        {
            token = tokenizer.nextToken();
            if (token.indexOf(":=") != -1) {
                index = token.indexOf(":=");
                directiveName = token.substring(0, index).trim();
                if (directiveName.length() == 0) {
                    throw new IllegalArgumentException("bad syntax: " + token + " in " + symbolicNameHeader);
                }
                if (!directiveName.equals("singleton") || !(value = token.substring(index + ":=".length()).trim()).equalsIgnoreCase(Boolean.TRUE.toString())) continue;
                this.singleton = true;
                continue;
            }
            throw new IllegalArgumentException("bad syntax: " + token + " in " + symbolicNameHeader);
lbl17:
            // 3 sources

            ** while (tokenizer.hasMoreTokens())
        }
lbl18:
        // 1 sources

    }

    private void parseVersion(String header) {
        this.version = Version.parseVersion((String)header);
    }

    private void parseRequires(String header) {
        if (header == null) {
            this.requires = Collections.EMPTY_LIST;
            return;
        }
        this.requires = new ArrayList();
        StringTokenizer tokenizer = new StringTokenizer(header, ",");
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            JSRequireBundle jsRequire = new JSRequireBundle(token);
            if (jsRequire == null) continue;
            this.requires.add(jsRequire);
        }
    }

    private void parseExports(String header) {
        if (header == null) {
            this.exports = Collections.EMPTY_LIST;
            return;
        }
        this.exports = new ArrayList();
        StringTokenizer tokenizer = new StringTokenizer(header, ",");
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            JSExportPackage jsExport = new JSExportPackage(token, this);
            if (jsExport == null) continue;
            this.exports.add(jsExport);
        }
    }

    private void parseImports(String header) {
        if (header == null) {
            this.imports = Collections.EMPTY_LIST;
            return;
        }
        this.imports = new ArrayList();
        StringTokenizer tokenizer = new StringTokenizer(header, ",");
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            JSImportPackage jsImport = new JSImportPackage(token);
            if (jsImport == null) continue;
            this.imports.add(jsImport);
        }
    }

    public int getBundleId() {
        return this.bundleData.getBundleId();
    }

    public String getLocation() {
        return this.bundleData.getLocation();
    }

    public Map getHeaders() {
        return this.bundleData.getHeaders();
    }

    public int getState() {
        return this.state;
    }

    public void uninstall() {
        this.stop();
        this.state = 1;
    }

    protected void resolve() {
        if (this.state != 2) {
            return;
        }
        HashMap<String, JSExportPackage> namedExports = new HashMap<String, JSExportPackage>();
        Iterator iterator = this.imports.iterator();
        while (iterator.hasNext()) {
            JSImportPackage jsImport = (JSImportPackage)iterator.next();
            JSExportPackage jsExport = jsImport.getWiredExport();
            if (namedExports.containsKey(jsExport.getName())) continue;
            namedExports.put(jsExport.getName(), jsExport);
        }
        iterator = this.requires.iterator();
        while (iterator.hasNext()) {
            JSRequireBundle jsRequire = (JSRequireBundle)iterator.next();
            JSBundleImpl wiredBundle = jsRequire.getWiredBundle();
            List wiredBundleExports = wiredBundle.getExports();
            Iterator exportIterator = wiredBundleExports.iterator();
            while (exportIterator.hasNext()) {
                JSExportPackage jsExport = (JSExportPackage)exportIterator.next();
                if (namedExports.containsKey(jsExport.getName())) continue;
                namedExports.put(jsExport.getName(), jsExport);
            }
        }
        ArrayList names = new ArrayList(namedExports.keySet());
        Collections.sort(names);
        Scriptable newScope = this.framework.createScope(this.bundleData.getContextClassLoader());
        Iterator iterator2 = names.iterator();
        while (iterator2.hasNext()) {
            String exportName = (String)iterator2.next();
            JSExportPackage jsExport = (JSExportPackage)namedExports.get(exportName);
            jsExport.addToScope(newScope);
        }
        this.evalScript(newScope);
        this.scope = newScope;
        this.state = 4;
    }

    private void evalScript(Scriptable scriptScope) {
        Context context = Context.getCurrentContext();
        String scriptPath = (String)this.bundleData.getHeaders().get("Bundle-ScriptPath");
        if (scriptPath == null) {
            scriptPath = ".";
        }
        StringTokenizer tokenizer = new StringTokenizer(scriptPath, ",");
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken().trim();
            if (token.equals(".")) {
                String script = (String)this.bundleData.getHeaders().get("Bundle-Script");
                if (script == null) continue;
                context.evaluateString(scriptScope, script, "script.js", 0, null);
                continue;
            }
            Reader reader = null;
            try {
                try {
                    URL scriptURL = this.bundleData.getEntry(token);
                    reader = new InputStreamReader(scriptURL.openStream());
                    context.evaluateReader(scriptScope, reader, token, 0, null);
                }
                catch (IOException e) {
                    throw new IllegalStateException("Error reading script for " + this.toString() + ": " + e.getMessage());
                }
            }
            catch (Throwable throwable) {
                try {
                    if (reader != null) {
                        reader.close();
                    }
                }
                catch (IOException iOException) {}
                throw throwable;
            }
            try {
                if (reader == null) continue;
                reader.close();
            }
            catch (IOException iOException) {}
        }
    }

    protected void unresolve() {
        if (this.state == 32) {
            this.stop();
            this.markedStarted = true;
        }
        this.scope = null;
        if (this.state == 4) {
            this.state = 2;
        }
    }

    public String toString() {
        return "JavaScriptBundle{symbolic-name=" + this.symbolicName + ", version=" + this.version.toString() + "}";
    }

    public Scriptable getScope() {
        return this.scope;
    }

    public void start() {
        this.markedStarted = true;
        if (this.state != 4) {
            return;
        }
        this.state = 8;
        this.bundleContext = this.framework.getBundleContext(this);
        this.activator = this.createActivatorInstance();
        if (this.activator != null) {
            final Callable startMethod = (Callable)this.activator.get(ACTIVATOR_START_METHOD, this.activator);
            this.framework.getContextFactory().call(new ContextAction(){

                public Object run(Context cx) {
                    startMethod.call(cx, JSBundleImpl.this.activator, JSBundleImpl.this.activator, new Object[]{JSBundleImpl.this.bundleContext});
                    return null;
                }
            });
        }
        this.state = 32;
    }

    private Scriptable createActivatorInstance() {
        String activatorName = (String)this.getHeaders().get("Bundle-Activator");
        if (activatorName == null) {
            return null;
        }
        Object value = this.lookup(activatorName);
        if (!(value instanceof Function)) {
            throw new IllegalStateException(String.valueOf(activatorName) + " is not a function.");
        }
        final Function constructorFunction = (Function)value;
        return (Scriptable)this.framework.getContextFactory().call(new ContextAction(){

            public Object run(Context cx) {
                return constructorFunction.construct(cx, JSBundleImpl.this.scope, null);
            }
        });
    }

    public void stop() {
        this.markedStarted = false;
        if (this.state != 32) {
            return;
        }
        this.state = 16;
        if (this.activator != null) {
            final Callable stopMethod = (Callable)this.activator.get(ACTIVATOR_STOP_METHOD, this.activator);
            this.framework.getContextFactory().call(new ContextAction(){

                public Object run(Context cx) {
                    stopMethod.call(Context.getCurrentContext(), JSBundleImpl.this.activator, JSBundleImpl.this.activator, new Object[]{JSBundleImpl.this.bundleContext});
                    return null;
                }
            });
        }
        this.state = 4;
    }

    public boolean isSingleton() {
        return this.singleton;
    }

    public boolean isMarkedStarted() {
        return this.markedStarted;
    }

    public Object call(final ContextAction action) {
        final ClassLoader bundleClassLoader = this.bundleData.getContextClassLoader();
        if (bundleClassLoader == null) {
            return this.framework.getContextFactory().call(action);
        }
        return this.framework.getContextFactory().call(new ContextAction(){

            public Object run(Context context) {
                ClassLoader current = context.getApplicationClassLoader();
                context.setApplicationClassLoader(bundleClassLoader);
                try {
                    Object object = action.run(context);
                    return object;
                }
                finally {
                    context.setApplicationClassLoader(current);
                }
            }
        });
    }

    public Object lookup(String name) {
        Scriptable currentScope = this.scope;
        StringTokenizer tokenizer = new StringTokenizer(name, ".");
        while (true) {
            String token = tokenizer.nextToken();
            Object value = currentScope.get(token, currentScope);
            if (!tokenizer.hasMoreTokens()) {
                return value;
            }
            if (!(value instanceof Scriptable)) break;
            currentScope = (Scriptable)value;
        }
        throw new RuntimeException("Not Found: " + name + " in " + this.toString());
    }
}

