/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.ui.dialogs;

import org.eclipse.equinox.internal.p2.ui.model.ElementUtils;
import org.eclipse.equinox.internal.provisional.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.internal.provisional.p2.ui.ProvUI;
import org.eclipse.equinox.internal.provisional.p2.ui.policy.Policy;
import org.eclipse.equinox.internal.provisional.p2.ui.policy.QueryProvider;
import org.eclipse.equinox.internal.provisional.p2.ui.viewers.IUColumnConfig;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public abstract class StructuredIUGroup {
    private FontMetrics fm;
    protected StructuredViewer viewer;
    private Composite composite;
    private Policy policy;
    private IUColumnConfig[] columnConfig;

    protected StructuredIUGroup(Policy policy, Composite parent, Font font, IUColumnConfig[] columnConfig) {
        this.policy = policy;
        this.columnConfig = columnConfig == null ? ProvUI.getIUColumnConfig() : columnConfig;
        GC gc = new GC((Drawable)parent);
        gc.setFont(font);
        this.fm = gc.getFontMetrics();
        gc.dispose();
    }

    protected void createGroupComposite(Composite parent) {
        this.composite = new Composite(parent, 0);
        GridData gd = new GridData(4, 4, true, true);
        this.composite.setLayoutData((Object)gd);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        this.composite.setLayout((Layout)layout);
        this.viewer = this.createViewer(this.composite);
        this.viewer.getControl().setLayoutData((Object)this.getViewerGridData());
    }

    protected GridData getViewerGridData() {
        GridData data = new GridData(1808);
        data.grabExcessHorizontalSpace = true;
        data.grabExcessVerticalSpace = true;
        return data;
    }

    protected abstract StructuredViewer createViewer(Composite var1);

    protected Composite getComposite() {
        return this.composite;
    }

    protected Shell getShell() {
        return this.composite.getShell();
    }

    protected StructuredViewer getStructuredViewer() {
        return this.viewer;
    }

    protected IUColumnConfig[] getColumnConfig() {
        return this.columnConfig;
    }

    public IInstallableUnit[] getSelectedIUs() {
        return ElementUtils.elementsToIUs(this.getSelectedIUElements());
    }

    public Object[] getSelectedIUElements() {
        return ((IStructuredSelection)this.viewer.getSelection()).toArray();
    }

    protected int convertHorizontalDLUsToPixels(int dlus) {
        return Dialog.convertHorizontalDLUsToPixels((FontMetrics)this.fm, (int)dlus);
    }

    protected int convertWidthInCharsToPixels(int dlus) {
        return Dialog.convertWidthInCharsToPixels((FontMetrics)this.fm, (int)dlus);
    }

    protected int convertVerticalDLUsToPixels(int dlus) {
        return Dialog.convertVerticalDLUsToPixels((FontMetrics)this.fm, (int)dlus);
    }

    protected int convertHeightInCharsToPixels(int dlus) {
        return Dialog.convertHeightInCharsToPixels((FontMetrics)this.fm, (int)dlus);
    }

    protected QueryProvider getQueryProvider() {
        return this.policy.getQueryProvider();
    }

    protected Policy getPolicy() {
        return this.policy;
    }

    protected Control getDefaultFocusControl() {
        if (this.viewer != null) {
            return this.viewer.getControl();
        }
        return null;
    }
}

