/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.provisional.p2.ui;

import java.util.HashMap;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.equinox.internal.p2.ui.ProvUIMessages;
import org.eclipse.equinox.internal.provisional.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.internal.provisional.p2.ui.IUPropertyUtils;

public class ResolutionResult {
    private static final String NESTING_INDENT = "  ";
    private HashMap iuToStatusMap = new HashMap();
    private MultiStatus summaryStatus;

    public IStatus getSummaryStatus() {
        if (this.summaryStatus != null) {
            return this.summaryStatus;
        }
        return Status.OK_STATUS;
    }

    public void addSummaryStatus(IStatus status) {
        if (this.summaryStatus == null) {
            this.summaryStatus = new MultiStatus("org.eclipse.equinox.p2.ui", 0, ProvUIMessages.ResolutionReport_SummaryStatus, null);
        }
        this.summaryStatus.add(status);
    }

    public IStatus statusOf(IInstallableUnit iu) {
        return (IStatus)this.iuToStatusMap.get(iu);
    }

    public void addStatus(IInstallableUnit iu, IStatus status) {
        MultiStatus iuSummaryStatus = (MultiStatus)this.iuToStatusMap.get(iu);
        if (iuSummaryStatus == null) {
            iuSummaryStatus = new MultiStatus("org.eclipse.equinox.p2.ui", 10002, new IStatus[]{status}, this.getIUString(iu), null);
        } else {
            iuSummaryStatus.add(status);
        }
    }

    private String getIUString(IInstallableUnit iu) {
        if (iu == null) {
            return ProvUIMessages.PlanStatusHelper_Items;
        }
        String name = IUPropertyUtils.getIUProperty(iu, "org.eclipse.equinox.p2.name");
        if (name != null) {
            return name;
        }
        return iu.getId();
    }

    public String getSummaryReport() {
        if (this.summaryStatus != null) {
            StringBuffer buffer = new StringBuffer();
            this.appendDetailText((IStatus)this.summaryStatus, buffer, -1, false);
            return buffer.toString();
        }
        return "";
    }

    public String getDetailedReport(IInstallableUnit[] ius) {
        StringBuffer buffer = new StringBuffer();
        int i = 0;
        while (i < ius.length) {
            MultiStatus iuStatus = (MultiStatus)this.iuToStatusMap.get(ius[i]);
            if (iuStatus != null) {
                this.appendDetailText((IStatus)iuStatus, buffer, 0, true);
            }
            ++i;
        }
        String report = buffer.toString();
        if (report.length() == 0) {
            return null;
        }
        return report;
    }

    void appendDetailText(IStatus status, StringBuffer buffer, int indent, boolean includeTopLevelMessage) {
        Throwable t;
        if (includeTopLevelMessage) {
            int i = 0;
            while (i < indent) {
                buffer.append(NESTING_INDENT);
                ++i;
            }
            if (status.getMessage() != null) {
                buffer.append(status.getMessage());
            }
        }
        if ((t = status.getException()) != null) {
            buffer.append('\n');
            int i = 0;
            while (i <= indent) {
                buffer.append(NESTING_INDENT);
                ++i;
            }
            if (t instanceof CoreException) {
                IStatus exceptionStatus = ((CoreException)t).getStatus();
                if (exceptionStatus != null && exceptionStatus.getMessage() != null) {
                    buffer.append(exceptionStatus.getMessage());
                } else {
                    String details = t.getLocalizedMessage();
                    if (details != null) {
                        buffer.append(details);
                    }
                }
            } else {
                String details = t.getLocalizedMessage();
                if (details != null) {
                    buffer.append(details);
                }
            }
        }
        IStatus[] children = status.getChildren();
        int i = 0;
        while (i < children.length) {
            if (buffer.length() > 0) {
                buffer.append('\n');
            }
            this.appendDetailText(children[i], buffer, indent + 1, true);
            ++i;
        }
    }
}

