/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.resources;

import org.eclipse.core.internal.resources.projectVariables.ProjectLocationProjectVariable;
import org.eclipse.core.internal.resources.projectVariables.WorkspaceLocationProjectVariable;
import org.eclipse.core.resources.IPathVariableManager;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;

public class PathVariableUtil {
    public static String getUniqueVariableName(String variable, IPathVariableManager pathVariableManager) {
        int index = 1;
        String destVariable = variable = PathVariableUtil.getValidVariableName(variable);
        while (pathVariableManager.isDefined(destVariable)) {
            destVariable = String.valueOf(variable) + index;
            ++index;
        }
        return destVariable;
    }

    public static String getValidVariableName(String variable) {
        char first;
        int argumentIndex = variable.indexOf(45);
        if (argumentIndex != -1) {
            variable = variable.substring(0, argumentIndex);
        }
        if (!Character.isLetter(first = (variable = variable.trim()).charAt(0)) && first != '_') {
            variable = String.valueOf('A') + variable;
        }
        StringBuffer builder = new StringBuffer();
        int i = 0;
        while (i < variable.length()) {
            char c = variable.charAt(i);
            if ((Character.isLetter(c) || Character.isDigit(c) || c == '_') && !Character.isWhitespace(c)) {
                builder.append(c);
            }
            ++i;
        }
        variable = builder.toString();
        return variable;
    }

    public static IPath convertToPathRelativeMacro(IPathVariableManager pathVariableManager, IPath originalPath, boolean force, String variableHint) throws CoreException {
        return PathVariableUtil.convertToRelative(pathVariableManager, originalPath, force, variableHint, true, true);
    }

    public static IPath convertToRelative(IPathVariableManager pathVariableManager, IPath originalPath, boolean force, String variableHint) throws CoreException {
        return PathVariableUtil.convertToRelative(pathVariableManager, originalPath, force, variableHint, true, false);
    }

    private static IPath convertToRelative(IPathVariableManager pathVariableManager, IPath originalPath, boolean force, String variableHint, boolean skipWorkspace, boolean generateMacro) throws CoreException {
        IPath value;
        if (variableHint != null && pathVariableManager.isDefined(variableHint)) {
            return PathVariableUtil.wrapInProperFormat(PathVariableUtil.makeRelativeToVariable(pathVariableManager, originalPath, force, variableHint, generateMacro), generateMacro);
        }
        IPath path = PathVariableUtil.convertToProperCase(originalPath);
        IPath newPath = null;
        int maxMatchLength = -1;
        String[] existingVariables = pathVariableManager.getPathVariableNames();
        int i = 0;
        while (i < existingVariables.length) {
            String variable = existingVariables[i];
            if (!(skipWorkspace && variable.equals(WorkspaceLocationProjectVariable.NAME) || variable.equals("PARENT"))) {
                int matchLength;
                value = pathVariableManager.getValue(variable);
                if ((value = PathVariableUtil.convertToProperCase(pathVariableManager.resolvePath(value))).isPrefixOf(path) && (matchLength = value.segmentCount()) > maxMatchLength) {
                    maxMatchLength = matchLength;
                    newPath = PathVariableUtil.makeRelativeToVariable(pathVariableManager, originalPath, force, variable, generateMacro);
                }
            }
            ++i;
        }
        if (newPath != null) {
            return PathVariableUtil.wrapInProperFormat(newPath, generateMacro);
        }
        if (force) {
            int originalSegmentCount = originalPath.segmentCount();
            int j = 0;
            while (j <= originalSegmentCount) {
                IPath matchingPath = path.removeLastSegments(j);
                int minDifference = Integer.MAX_VALUE;
                int k = 0;
                while (k < existingVariables.length) {
                    String variable = existingVariables[k];
                    if (!(skipWorkspace && variable.equals(WorkspaceLocationProjectVariable.NAME) || variable.equals("PARENT"))) {
                        int difference;
                        IPath value2 = pathVariableManager.getValue(variable);
                        if (matchingPath.isPrefixOf(value2 = PathVariableUtil.convertToProperCase(pathVariableManager.resolvePath(value2))) && (difference = value2.segmentCount() - originalSegmentCount) < minDifference) {
                            minDifference = difference;
                            newPath = PathVariableUtil.makeRelativeToVariable(pathVariableManager, originalPath, force, variable, generateMacro);
                        }
                    }
                    ++k;
                }
                if (newPath != null) {
                    return PathVariableUtil.wrapInProperFormat(newPath, generateMacro);
                }
                ++j;
            }
            if (originalSegmentCount == 0) {
                String variable = ProjectLocationProjectVariable.NAME;
                value = pathVariableManager.getValue(variable);
                if (originalPath.isPrefixOf(value = PathVariableUtil.convertToProperCase(pathVariableManager.resolvePath(value)))) {
                    newPath = PathVariableUtil.makeRelativeToVariable(pathVariableManager, originalPath, force, variable, generateMacro);
                }
                if (newPath != null) {
                    return PathVariableUtil.wrapInProperFormat(newPath, generateMacro);
                }
            }
        }
        if (skipWorkspace) {
            return PathVariableUtil.convertToRelative(pathVariableManager, originalPath, force, variableHint, false, generateMacro);
        }
        return originalPath;
    }

    private static IPath wrapInProperFormat(IPath newPath, boolean generateMacro) {
        if (generateMacro) {
            newPath = PathVariableUtil.buildVariableMacro(newPath);
        }
        return newPath;
    }

    private static IPath makeRelativeToVariable(IPathVariableManager pathVariableManager, IPath originalPath, boolean force, String variableHint, boolean generateMacro) throws CoreException {
        int matchingFirstSegments;
        IPath path = PathVariableUtil.convertToProperCase(originalPath);
        IPath value = pathVariableManager.getValue(variableHint);
        value = PathVariableUtil.convertToProperCase(pathVariableManager.resolvePath(value));
        int valueSegmentCount = value.segmentCount();
        if (value.isPrefixOf(path)) {
            IPath tmp = Path.fromOSString((String)variableHint);
            int j = valueSegmentCount;
            while (j < originalPath.segmentCount()) {
                tmp = tmp.append(originalPath.segment(j));
                ++j;
            }
            return tmp;
        }
        if (force && (matchingFirstSegments = path.matchingFirstSegments(value)) >= 0) {
            String originalName;
            String newValue = PathVariableUtil.buildParentPathVariable(variableHint, valueSegmentCount - matchingFirstSegments, generateMacro);
            if (generateMacro) {
                originalName = newValue;
            } else {
                originalName = PathVariableUtil.getExistingVariable(newValue, pathVariableManager);
                if (originalName == null) {
                    String name = matchingFirstSegments > 0 ? originalPath.segment(matchingFirstSegments - 1) : originalPath.getDevice();
                    if (name == null) {
                        name = "ROOT";
                    }
                    originalName = PathVariableUtil.getUniqueVariableName(name, pathVariableManager);
                    pathVariableManager.setValue(originalName, Path.fromOSString((String)newValue));
                }
            }
            IPath tmp = Path.fromOSString((String)originalName);
            int j = matchingFirstSegments;
            while (j < originalPath.segmentCount()) {
                tmp = tmp.append(originalPath.segment(j));
                ++j;
            }
            return tmp;
        }
        return originalPath;
    }

    private static String getExistingVariable(String newValue, IPathVariableManager pathVariableManager) {
        String[] existingVariables = pathVariableManager.getPathVariableNames();
        int i = 0;
        while (i < existingVariables.length) {
            String variable = existingVariables[i];
            IPath value = pathVariableManager.getValue(variable);
            if (value.toOSString().equals(newValue)) {
                return variable;
            }
            ++i;
        }
        return null;
    }

    private static IPath convertToProperCase(IPath path) {
        if (Platform.getOS().equals("win32")) {
            return Path.fromPortableString((String)path.toPortableString().toLowerCase());
        }
        return path;
    }

    public static boolean isParentVariable(String variableString) {
        return variableString.startsWith("PARENT-");
    }

    public static int getParentVariableCount(String variableString) {
        String[] items = variableString.split("-");
        if (items.length == 3) {
            try {
                Integer count = Integer.valueOf(items[1]);
                return count;
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return -1;
    }

    public static String getParentVariableArgument(String variableString) {
        String[] items = variableString.split("-");
        if (items.length == 3) {
            return items[2];
        }
        return null;
    }

    public static String buildParentPathVariable(String variable, int difference, boolean generateMacro) {
        String newString = "PARENT-" + difference + "-" + variable;
        if (!generateMacro) {
            newString = "${" + newString + "}";
        }
        return newString;
    }

    public static IPath buildVariableMacro(IPath relativeSrcValue) {
        String variable = relativeSrcValue.segment(0);
        variable = "${" + variable + "}";
        return Path.fromOSString((String)variable).append(relativeSrcValue.removeFirstSegments(1));
    }
}

