/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.resources;

import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import org.eclipse.core.filesystem.URIUtil;
import org.eclipse.core.internal.events.PathVariableChangeEvent;
import org.eclipse.core.internal.resources.IManager;
import org.eclipse.core.internal.resources.PathVariableManager;
import org.eclipse.core.internal.resources.PathVariableUtil;
import org.eclipse.core.internal.resources.Project;
import org.eclipse.core.internal.resources.ProjectDescription;
import org.eclipse.core.internal.resources.ResourceStatus;
import org.eclipse.core.internal.resources.VariableDescription;
import org.eclipse.core.internal.resources.projectVariables.ProjectLocationProjectVariable;
import org.eclipse.core.internal.utils.Messages;
import org.eclipse.core.internal.utils.Policy;
import org.eclipse.core.resources.IPathVariableChangeListener;
import org.eclipse.core.resources.IPathVariableManager;
import org.eclipse.core.resources.ProjectVariableProviderManager;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;

public class ProjectPathVariableManager
implements IPathVariableManager,
IManager {
    private Set listeners = Collections.synchronizedSet(new HashSet());
    private Project project;
    private ProjectVariableProviderManager.Descriptor[] variableProviders = null;

    public ProjectPathVariableManager(Project project) {
        this.project = project;
        this.variableProviders = ProjectVariableProviderManager.getDefault().getDescriptors();
    }

    public void addChangeListener(IPathVariableChangeListener listener) {
        this.listeners.add(listener);
    }

    PathVariableManager getWorkspaceManager() {
        return (PathVariableManager)this.project.getWorkspace().getPathVariableManager();
    }

    private void checkIsValidName(String name) throws CoreException {
        IStatus status = this.validateName(name);
        if (!status.isOK()) {
            throw new CoreException(status);
        }
    }

    private void checkIsValidValue(IPath newValue) throws CoreException {
        IStatus status = this.validateValue(newValue);
        if (!status.isOK()) {
            throw new CoreException(status);
        }
    }

    private void fireVariableChangeEvent(String name, IPath value, int type) {
        if (this.listeners.size() == 0) {
            return;
        }
        Object[] listenerArray = this.listeners.toArray();
        final PathVariableChangeEvent pve = new PathVariableChangeEvent(this, name, value, type);
        int i = 0;
        while (i < listenerArray.length) {
            final IPathVariableChangeListener l = (IPathVariableChangeListener)listenerArray[i];
            ISafeRunnable job = new ISafeRunnable(){

                public void handleException(Throwable exception) {
                }

                public void run() throws Exception {
                    l.pathVariableChanged(pve);
                }
            };
            SafeRunner.run((ISafeRunnable)job);
            ++i;
        }
    }

    public String[] getPathVariableNames() {
        HashMap map;
        LinkedList<String> result = new LinkedList<String>();
        try {
            map = ((ProjectDescription)this.project.getDescription()).getVariables();
        }
        catch (CoreException coreException) {
            return new String[0];
        }
        int i = 0;
        while (i < this.variableProviders.length) {
            result.add(this.variableProviders[i].getName());
            ++i;
        }
        if (map != null) {
            result.addAll(map.keySet());
        }
        result.addAll(Arrays.asList(this.getWorkspaceManager().getPathVariableNames()));
        return result.toArray(new String[0]);
    }

    public IPath getValue(String varName) {
        String value = this.internalGetValue(varName);
        if (value != null) {
            IPath resolved;
            int index;
            if (value.indexOf("..") != -1 && (index = value.indexOf(47)) > 0 && (resolved = this.resolveVariable(value)) != null) {
                return resolved;
            }
            return Path.fromPortableString((String)value);
        }
        return this.getWorkspaceManager().getValue(varName);
    }

    public String internalGetValue(String varName) {
        HashMap map;
        try {
            map = ((ProjectDescription)this.project.getDescription()).getVariables();
        }
        catch (CoreException coreException) {
            return null;
        }
        if (map != null && map.containsKey(varName)) {
            return ((VariableDescription)map.get(varName)).getValue();
        }
        int index = varName.indexOf(45);
        String name = index != -1 ? varName.substring(0, index) : varName;
        int i = 0;
        while (i < this.variableProviders.length) {
            if (this.variableProviders[i].getName().equals(name)) {
                return this.variableProviders[i].getValue(varName, this.project);
            }
            ++i;
        }
        return null;
    }

    public boolean isDefined(String varName) {
        return this.getValue(varName) != null;
    }

    public void removeChangeListener(IPathVariableChangeListener listener) {
        this.listeners.remove(listener);
    }

    public IPath resolvePath(IPath path) {
        if (path == null || path.segmentCount() == 0 || path.isAbsolute() || path.getDevice() != null) {
            return path;
        }
        IPath value = this.resolveVariable(path.segment(0));
        return value == null ? path : value.append(path.removeFirstSegments(1));
    }

    public IPath resolveVariable(String variable) {
        LinkedList variableStack = new LinkedList();
        String value = this.resolveVariable(variable, variableStack);
        if (value != null) {
            return Path.fromPortableString((String)value);
        }
        return null;
    }

    public static String[] splitVariablesAndContent(String value) {
        int index;
        LinkedList<String> result = new LinkedList<String>();
        while ((index = value.indexOf("${")) != -1) {
            int endIndex = ProjectPathVariableManager.getMatchingBrace(value, index);
            if (index > 0) {
                result.add(value.substring(0, index));
            }
            result.add(value.substring(index, endIndex + 1));
            value = value.substring(endIndex + 1);
        }
        if (value.length() > 0) {
            result.add(value);
        }
        return result.toArray(new String[0]);
    }

    public static String[] splitVariableNames(String value) {
        int index;
        LinkedList<String> result = new LinkedList<String>();
        while ((index = value.indexOf("${")) != -1) {
            int endIndex = ProjectPathVariableManager.getMatchingBrace(value, index);
            result.add(value.substring(index + 2, endIndex));
            value = value.substring(endIndex + 1);
        }
        return result.toArray(new String[0]);
    }

    public static String extractVariable(String segment) {
        int index = segment.indexOf("${");
        if (index != -1) {
            int endIndex = ProjectPathVariableManager.getMatchingBrace(segment, index);
            return segment.substring(index + 2, endIndex);
        }
        return "";
    }

    public String resolveVariable(String value, LinkedList variableStack) {
        int index;
        String tmp;
        if (variableStack == null) {
            variableStack = new LinkedList<String>();
        }
        if ((tmp = this.internalGetValue(value)) == null) {
            IPath result = this.getWorkspaceManager().getValue(value);
            if (result != null) {
                return result.toPortableString();
            }
        } else {
            value = tmp;
        }
        while ((index = value.indexOf("${")) != -1) {
            int endIndex = ProjectPathVariableManager.getMatchingBrace(value, index);
            String macro = value.substring(index + 2, endIndex);
            String resolvedMacro = "";
            if (!variableStack.contains(macro)) {
                variableStack.add(macro);
                resolvedMacro = this.resolveVariable(macro, variableStack);
                if (resolvedMacro == null) {
                    resolvedMacro = "";
                }
            }
            if (value.length() > endIndex) {
                value = String.valueOf(value.substring(0, index)) + resolvedMacro + value.substring(endIndex + 1);
                continue;
            }
            value = resolvedMacro;
        }
        return value;
    }

    static int getMatchingBrace(String value, int index) {
        int scope = 0;
        int i = index + 1;
        while (i < value.length()) {
            char c = value.charAt(i);
            if (c == '}') {
                if (scope == 0) {
                    return i;
                }
                --scope;
            }
            if (c == '$' && i + 1 < value.length() && value.charAt(i + 1) == '{') {
                ++scope;
            }
            ++i;
        }
        return value.length();
    }

    public URI resolveURI(URI uri) {
        IPath resolved;
        if (uri == null || uri.isAbsolute() || uri.getSchemeSpecificPart() == null) {
            return uri;
        }
        Path raw = new Path(uri.getSchemeSpecificPart());
        return raw == (resolved = this.resolvePath((IPath)raw)) ? uri : URIUtil.toURI((IPath)resolved);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setValue(String varName, IPath newValue) throws CoreException {
        this.checkIsValidName(varName);
        if (newValue != null && newValue.isAbsolute() && newValue.getDevice() == null) {
            newValue = new Path(newValue.toFile().getAbsolutePath());
        }
        this.checkIsValidValue(newValue);
        int eventType = 0;
        boolean changeWorkspaceValue = false;
        ProjectPathVariableManager projectPathVariableManager = this;
        synchronized (projectPathVariableManager) {
            boolean variableExists;
            String value = this.internalGetValue(varName);
            IPath currentValue = null;
            currentValue = value == null ? this.getWorkspaceManager().getValue(varName) : Path.fromPortableString((String)value);
            boolean bl = variableExists = currentValue != null;
            if (!variableExists && newValue == null) {
                return;
            }
            if (variableExists && currentValue.equals((Object)newValue)) {
                return;
            }
            int i = 0;
            while (i < this.variableProviders.length) {
                if (this.variableProviders[i].getName().equals(varName)) {
                    return;
                }
                ++i;
            }
            if (value == null && variableExists) {
                changeWorkspaceValue = true;
            } else {
                NullProgressMonitor monitor = new NullProgressMonitor();
                Project rule = this.project;
                try {
                    this.project.workspace.prepareOperation(rule, (IProgressMonitor)monitor);
                    this.project.workspace.beginOperation(true);
                    ProjectDescription description = this.project.internalGetDescription();
                    if (newValue == null) {
                        description.setVariableDescription(varName, null);
                        eventType = 3;
                    } else {
                        description.setVariableDescription(varName, new VariableDescription(varName, newValue.toPortableString()));
                        eventType = variableExists ? 1 : 2;
                    }
                    this.project.writeDescription(0);
                }
                finally {
                    this.project.workspace.endOperation(rule, true, Policy.subMonitorFor((IProgressMonitor)monitor, Policy.endOpWork));
                }
            }
        }
        if (!changeWorkspaceValue) {
            this.fireVariableChangeEvent(varName, newValue, eventType);
        } else {
            this.getWorkspaceManager().setValue(varName, newValue);
        }
    }

    public void shutdown(IProgressMonitor monitor) {
    }

    public void startup(IProgressMonitor monitor) {
    }

    public IStatus validateName(String name) {
        String message = null;
        if (name.length() == 0) {
            message = Messages.pathvar_length;
            return new ResourceStatus(77, null, message);
        }
        char first = name.charAt(0);
        if (!Character.isLetter(first) && first != '_') {
            message = NLS.bind((String)Messages.pathvar_beginLetter, (Object)String.valueOf(first));
            return new ResourceStatus(77, null, message);
        }
        int i = 1;
        while (i < name.length()) {
            char following = name.charAt(i);
            if (Character.isWhitespace(following)) {
                return new ResourceStatus(77, null, Messages.pathvar_whitespace);
            }
            if (!Character.isLetter(following) && !Character.isDigit(following) && following != '_') {
                message = NLS.bind((String)Messages.pathvar_invalidChar, (Object)String.valueOf(following));
                return new ResourceStatus(77, null, message);
            }
            ++i;
        }
        return Status.OK_STATUS;
    }

    public IStatus validateValue(IPath value) {
        return Status.OK_STATUS;
    }

    public IPath convertToRelative(IPath path, boolean force, String variableHint) throws CoreException {
        return PathVariableUtil.convertToRelative(this, path, force, variableHint);
    }

    public static String convertToUserEditableFormat(String value) {
        StringBuffer buffer = new StringBuffer();
        String[] components = ProjectPathVariableManager.splitVariablesAndContent(value);
        int i = 0;
        while (i < components.length) {
            String variable = ProjectPathVariableManager.extractVariable(components[i]);
            if (PathVariableUtil.isParentVariable(variable)) {
                String argument = PathVariableUtil.getParentVariableArgument(variable);
                int count = PathVariableUtil.getParentVariableCount(variable);
                if (argument != null && count != -1) {
                    buffer.append(PathVariableUtil.buildVariableMacro(Path.fromOSString((String)argument)));
                    int j = 0;
                    while (j < count) {
                        buffer.append("/..");
                        ++j;
                    }
                } else {
                    buffer.append(components[i]);
                }
            } else {
                buffer.append(components[i]);
            }
            ++i;
        }
        return buffer.toString();
    }

    public String convertFromUserEditableFormat(String userFormat) {
        boolean isAbsolute = userFormat.length() > 0 && (userFormat.charAt(0) == '/' || userFormat.charAt(0) == '\\');
        String[] components = ProjectPathVariableManager.splitPathComponents(userFormat);
        int i = 0;
        while (i < components.length) {
            if (components[i] != null && ProjectPathVariableManager.isDotDot(components[i])) {
                int parentCount = 1;
                components[i] = null;
                int j = i + 1;
                while (j < components.length) {
                    if (components[j] != null) {
                        if (!ProjectPathVariableManager.isDotDot(components[j])) break;
                        ++parentCount;
                        components[j] = null;
                    }
                    ++j;
                }
                if (i == 0) {
                    components[0] = PathVariableUtil.buildParentPathVariable(ProjectLocationProjectVariable.NAME, parentCount, false);
                } else {
                    j = i - 1;
                    while (j >= 0) {
                        if (parentCount == 0) break;
                        if (components[j] != null) {
                            String variable = ProjectPathVariableManager.extractVariable(components[j]);
                            try {
                                if (variable.length() > 0) {
                                    int indexOfVariable = components[j].indexOf(variable) - "${".length();
                                    String prefix = components[j].substring(0, indexOfVariable);
                                    String suffix = components[j].substring(indexOfVariable + "${".length() + variable.length() + "}".length());
                                    if (suffix.length() != 0) {
                                        String intermediateVariable = PathVariableUtil.getValidVariableName(String.valueOf(variable) + suffix);
                                        IPath intermediateValue = Path.fromPortableString((String)components[j]);
                                        int intermediateVariableIndex = 1;
                                        String originalIntermediateVariableName = intermediateVariable;
                                        while (this.isDefined(intermediateVariable)) {
                                            IPath tmpValue = this.getValue(intermediateVariable);
                                            if (tmpValue.equals((Object)intermediateValue)) break;
                                            intermediateVariable = String.valueOf(originalIntermediateVariableName) + intermediateVariableIndex;
                                        }
                                        if (!this.isDefined(intermediateVariable)) {
                                            this.setValue(intermediateVariable, intermediateValue);
                                        }
                                        variable = intermediateVariable;
                                        prefix = new String();
                                    }
                                    String newVariable = variable;
                                    if (PathVariableUtil.isParentVariable(variable)) {
                                        String argument = PathVariableUtil.getParentVariableArgument(variable);
                                        int count = PathVariableUtil.getParentVariableCount(variable);
                                        newVariable = argument != null && count != -1 ? PathVariableUtil.buildParentPathVariable(argument, count + parentCount, false) : PathVariableUtil.buildParentPathVariable(variable, parentCount, false);
                                    } else {
                                        newVariable = PathVariableUtil.buildParentPathVariable(variable, parentCount, false);
                                    }
                                    components[j] = String.valueOf(prefix) + newVariable;
                                    break;
                                }
                                components[j] = null;
                                --parentCount;
                            }
                            catch (CoreException coreException) {
                                components[j] = null;
                                --parentCount;
                            }
                        }
                        --j;
                    }
                }
            }
            ++i;
        }
        StringBuffer buffer = new StringBuffer();
        if (isAbsolute) {
            buffer.append('/');
        }
        int i2 = 0;
        while (i2 < components.length) {
            if (components[i2] != null) {
                if (i2 > 0) {
                    buffer.append('/');
                }
                buffer.append(components[i2]);
            }
            ++i2;
        }
        return buffer.toString();
    }

    private static boolean isDotDot(String component) {
        return component.equals("..");
    }

    private static String[] splitPathComponents(String userFormat) {
        ArrayList<String> list = new ArrayList<String>();
        StringBuffer buffer = new StringBuffer();
        int i = 0;
        while (i < userFormat.length()) {
            char c = userFormat.charAt(i);
            if (c == '/' || c == '\\') {
                if (buffer.length() > 0) {
                    list.add(buffer.toString());
                }
                buffer = new StringBuffer();
            } else {
                buffer.append(c);
            }
            ++i;
        }
        if (buffer.length() > 0) {
            list.add(buffer.toString());
        }
        return list.toArray(new String[0]);
    }
}

