/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.resources;

import java.util.HashMap;
import org.eclipse.core.resources.IFilterType;
import org.eclipse.core.resources.IFilterTypeFactory;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IRegistryEventListener;
import org.eclipse.core.runtime.Platform;

public class FilterTypeManager {
    private static final String FILTER_PROVIDER = "filterProvider";
    public static final String ARGUMENT_TYPE_NONE = "none";
    public static final String ARGUMENT_TYPE_STRING = "string";
    public static final String ARGUMENT_TYPE_FILTERS = "filters";
    public static final String ARGUMENT_TYPE_FILTER = "filter";
    private HashMap factories = new HashMap();
    private static FilterTypeManager instance = null;

    public static FilterTypeManager getDefault() {
        if (instance == null) {
            instance = new FilterTypeManager();
        }
        return instance;
    }

    protected FilterTypeManager() {
        IExtensionPoint point = Platform.getExtensionRegistry().getExtensionPoint("org.eclipse.core.resources", "filterProviders");
        if (point != null) {
            IExtension[] ext = point.getExtensions();
            int i = 0;
            while (i < ext.length) {
                IExtension extension = ext[i];
                this.processExtension(extension);
                ++i;
            }
            Platform.getExtensionRegistry().addListener(new IRegistryEventListener(){

                public void added(IExtension[] extensions) {
                    int i = 0;
                    while (i < extensions.length) {
                        FilterTypeManager.this.processExtension(extensions[i]);
                        ++i;
                    }
                }

                public void added(IExtensionPoint[] extensionPoints) {
                }

                public void removed(IExtension[] extensions) {
                    int i = 0;
                    while (i < extensions.length) {
                        FilterTypeManager.this.processRemovedExtension(extensions[i]);
                        ++i;
                    }
                }

                public void removed(IExtensionPoint[] extensionPoints) {
                }
            });
        }
    }

    protected void processExtension(IExtension extension) {
        IConfigurationElement[] elements = extension.getConfigurationElements();
        int i = 0;
        while (i < elements.length) {
            IConfigurationElement element = elements[i];
            if (element.getName().equalsIgnoreCase(FILTER_PROVIDER)) {
                try {
                    Descriptor desc = new Descriptor(element);
                    this.factories.put(desc.getId(), desc);
                }
                catch (CoreException e) {
                    e.printStackTrace();
                }
            }
            ++i;
        }
    }

    protected void processRemovedExtension(IExtension extension) {
        IConfigurationElement[] elements = extension.getConfigurationElements();
        int i = 0;
        while (i < elements.length) {
            IConfigurationElement element = elements[i];
            if (element.getName().equalsIgnoreCase(FILTER_PROVIDER)) {
                try {
                    Descriptor desc = new Descriptor(element, false);
                    this.factories.remove(desc.getId());
                }
                catch (CoreException e) {
                    e.printStackTrace();
                }
            }
            ++i;
        }
    }

    public Descriptor[] getDescriptors() {
        return this.factories.values().toArray(new Descriptor[0]);
    }

    public IFilterType instantiate(String id, IProject project, String arguments) {
        Object obj = this.factories.get(id);
        if (obj != null) {
            return ((Descriptor)obj).getFactory().instantiate(project, arguments);
        }
        return null;
    }

    public Descriptor findDescriptor(String id) {
        return (Descriptor)this.factories.get(id);
    }

    public class Descriptor {
        private String id;
        private String name;
        private String description;
        private String argumentType;
        private IFilterTypeFactory factory;
        private boolean isFirst = false;

        public Descriptor(IConfigurationElement element) throws CoreException {
            this(element, true);
        }

        public Descriptor(IConfigurationElement element, boolean instantiateFactory) throws CoreException {
            String ordering;
            this.id = element.getAttribute("id");
            this.name = element.getAttribute("name");
            this.description = element.getAttribute("description");
            this.argumentType = element.getAttribute("argumentType");
            if (this.argumentType == null) {
                this.argumentType = FilterTypeManager.ARGUMENT_TYPE_NONE;
            }
            if (instantiateFactory) {
                this.factory = (IFilterTypeFactory)element.createExecutableExtension("class");
            }
            if ((ordering = element.getAttribute("ordering")) != null) {
                this.isFirst = ordering.equals("first");
            }
        }

        public String getId() {
            return this.id;
        }

        public String getName() {
            return this.name;
        }

        public String getDescription() {
            return this.description;
        }

        public String getArgumentType() {
            return this.argumentType;
        }

        public IFilterTypeFactory getFactory() {
            return this.factory;
        }

        public boolean isFirstOrdering() {
            return this.isFirst;
        }
    }
}

