/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.core.services.internal.context;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.e4.core.services.context.ContextChangeEvent;
import org.eclipse.e4.core.services.context.IEclipseContext;
import org.eclipse.e4.core.services.internal.context.EclipseContext;

abstract class Computation {
    Map dependencies = new HashMap();

    Computation() {
    }

    void addDependency(IEclipseContext context, String name) {
        HashSet<String> properties = (HashSet<String>)this.dependencies.get(context);
        if (properties == null) {
            properties = new HashSet<String>(4);
            this.dependencies.put(context, properties);
        }
        properties.add(name);
    }

    final void clear(IEclipseContext context, String name) {
        this.doClear();
        this.stopListening(context, name);
    }

    protected void doClear() {
    }

    protected void doHandleInvalid(ContextChangeEvent event) {
    }

    public abstract boolean equals(Object var1);

    final void handleInvalid(ContextChangeEvent event) {
        IEclipseContext context = event.getContext();
        String name = event.getName();
        Set names = (Set)this.dependencies.get(context);
        if (name == null && event.getEventType() == 3) {
            this.clear(context, null);
            this.doHandleInvalid(event);
        } else if (names != null && names.contains(name)) {
            this.clear(context, name);
            this.doHandleInvalid(event);
        }
    }

    public abstract int hashCode();

    private String mapToString(Map map) {
        StringBuffer result = new StringBuffer(123);
        Iterator it = map.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            result.append(entry.getKey());
            result.append("->(");
            Set set = (Set)entry.getValue();
            Iterator it2 = set.iterator();
            while (it2.hasNext()) {
                String name = (String)it2.next();
                result.append(name);
                if (!it2.hasNext()) continue;
                result.append(",");
            }
            result.append(")");
            if (!it.hasNext()) continue;
            result.append(",");
        }
        return result.toString();
    }

    void startListening() {
        if (EclipseContext.DEBUG) {
            System.out.println(String.valueOf(this.toString()) + " now listening to: " + this.mapToString(this.dependencies));
        }
        Iterator it = this.dependencies.keySet().iterator();
        while (it.hasNext()) {
            EclipseContext c = (EclipseContext)it.next();
            c.listeners.add(this);
        }
    }

    private void stopListening(IEclipseContext context, String name) {
        if (name == null) {
            if (EclipseContext.DEBUG) {
                System.out.println(String.valueOf(this.toString()) + " no longer listening to " + context);
            }
            this.dependencies.remove(context);
            return;
        }
        Set properties = (Set)this.dependencies.get(context);
        if (properties != null) {
            if (EclipseContext.DEBUG) {
                System.out.println(String.valueOf(this.toString()) + " no longer listening to " + context + "," + name);
            }
            ((EclipseContext)context).listeners.remove(this);
            properties.remove(name);
            if (properties.isEmpty()) {
                this.dependencies.remove(context);
            }
        }
    }
}

