/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.workbench.ui.renderers.swt;

import org.eclipse.e4.ui.model.application.MPart;
import org.eclipse.e4.workbench.ui.renderers.swt.SWTPartRenderer;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.Widget;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompositePartRenderer
extends SWTPartRenderer {
    public Object createWidget(MPart part, Object parent) {
        if (!(part instanceof MPart) || !(parent instanceof Composite)) {
            return null;
        }
        Widget parentWidget = (Widget)parent;
        MPart compositeModel = part;
        String policy = compositeModel.getPolicy();
        if (policy != null && (policy.equals("HorizontalComposite") || policy.equals("VerticalComposite"))) {
            return new Composite((Composite)parentWidget, 0);
        }
        return null;
    }

    public void postProcess(MPart<?> part) {
        super.postProcess(part);
        if (part.getPolicy() != null && part.getPolicy().endsWith("Composite")) {
            Composite composite = (Composite)part.getWidget();
            Control[] children = composite.getChildren();
            GridLayout gl = new GridLayout(part.getPolicy().startsWith("Horizontal") ? children.length : 1, false);
            gl.horizontalSpacing = 0;
            gl.verticalSpacing = 0;
            gl.marginHeight = 0;
            gl.marginWidth = 0;
            composite.setLayout((Layout)gl);
            int i = 0;
            while (i < children.length) {
                Control child = children[i];
                boolean grabV = !(child instanceof ToolBar);
                boolean grabH = !(child instanceof ToolBar);
                child.setLayoutData((Object)new GridData(4, 4, grabH, grabV));
                ++i;
            }
        }
    }
}

