/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.workbench.ui.renderers.swt;

import org.eclipse.e4.ui.model.application.ApplicationPackage;
import org.eclipse.e4.ui.model.application.MItemPart;
import org.eclipse.e4.ui.model.application.MPart;
import org.eclipse.e4.ui.model.application.MStack;
import org.eclipse.e4.ui.widgets.CTabFolder;
import org.eclipse.e4.workbench.ui.renderers.swt.SWTPartRenderer;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.common.util.EList;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Widget;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class LazyStackRenderer
extends SWTPartRenderer {
    public void postProcess(MPart<?> part) {
        if (!(part instanceof MStack)) {
            return;
        }
        MStack stack = (MStack)part;
        MPart selPart = stack.getActiveChild();
        if (selPart == null && stack.getChildren().size() > 0) {
            stack.setActiveChild((MPart)((MItemPart)part.getChildren().get(0)));
        } else if (selPart != null && selPart.getWidget() == null) {
            this.renderer.createGui(selPart);
        }
    }

    @Override
    public <P extends MPart<?>> void processContents(MPart<P> me) {
        Widget parentWidget = this.getParentWidget(me);
        if (parentWidget == null) {
            return;
        }
        EList parts = me.getChildren();
        if (parts != null) {
            for (MPart childME : parts) {
                if (!childME.isVisible()) continue;
                this.internalChildAdded(me, childME);
            }
        }
    }

    protected void internalChildAdded(MPart parentME, MPart childME) {
    }

    @Override
    public void hookControllerLogic(MPart<?> me) {
        super.hookControllerLogic(me);
        if (!(me instanceof MStack)) {
            return;
        }
        MStack sm = (MStack)me;
        if (sm.getWidget() instanceof Control) {
            Control ctrl = (Control)sm.getWidget();
            ctrl.addListener(26, new Listener(){

                public void handleEvent(Event event) {
                    CTabFolder ctf = (CTabFolder)event.widget;
                    MStack stack = (MStack)ctf.getData("modelElement");
                    MItemPart selPart = (MItemPart)stack.getActiveChild();
                    if (selPart != null) {
                        LazyStackRenderer.this.activate((MPart)selPart);
                    }
                }
            });
        }
        me.eAdapters().add((Object)new AdapterImpl(){

            public void notifyChanged(Notification msg) {
                MStack stack;
                MPart selPart;
                if (ApplicationPackage.Literals.MPART__ACTIVE_CHILD.equals(msg.getFeature()) && (selPart = (stack = (MStack)msg.getNotifier()).getActiveChild()) != null && selPart.getWidget() == null) {
                    LazyStackRenderer.this.renderer.createGui(selPart);
                }
            }
        });
    }
}

