/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.workbench.ui.renderers.swt;

import org.eclipse.e4.core.services.context.IEclipseContext;
import org.eclipse.e4.ui.model.application.MApplicationElement;
import org.eclipse.e4.ui.model.application.MHandledItem;
import org.eclipse.e4.ui.model.application.MItem;
import org.eclipse.e4.ui.model.application.MItemPart;
import org.eclipse.e4.ui.model.application.MMenu;
import org.eclipse.e4.ui.model.application.MMenuItem;
import org.eclipse.e4.ui.model.application.MPart;
import org.eclipse.e4.ui.model.application.MToolBar;
import org.eclipse.e4.ui.model.application.MToolBarItem;
import org.eclipse.e4.ui.model.workbench.MMenuItemRenderer;
import org.eclipse.e4.ui.model.workbench.MToolItemRenderer;
import org.eclipse.e4.ui.services.IStylingEngine;
import org.eclipse.e4.ui.workbench.swt.util.ISWTResourceUtiltities;
import org.eclipse.e4.workbench.ui.IResourceUtiltities;
import org.eclipse.e4.workbench.ui.renderers.AbstractPartRenderer;
import org.eclipse.e4.workbench.ui.renderers.swt.HandledContributionItem;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.Widget;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SWTPartRenderer
extends AbstractPartRenderer {
    private static Shell limbo = null;

    public Object createMenu(MPart<?> part, Object widgetObject, MMenu menu) {
        Menu swtMenu;
        Widget widget = (Widget)widgetObject;
        MenuManager manager = new MenuManager();
        if (widget instanceof ToolItem) {
            swtMenu = manager.createContextMenu((Control)((ToolItem)widget).getParent().getShell());
        } else if (widget instanceof Decorations) {
            swtMenu = manager.createMenuBar((Decorations)widgetObject);
            swtMenu.setData((Object)manager);
            ((Decorations)widget).setMenuBar(swtMenu);
        } else if (widget instanceof Control) {
            swtMenu = manager.createContextMenu((Control)widget);
        } else {
            throw new IllegalArgumentException("The widget must be MenuItem, Decorations, or Control but is: " + widgetObject);
        }
        swtMenu.setData("modelElement", (Object)menu);
        for (MMenuItem menuItem : menu.getItems()) {
            this.createMenuItem(part, manager, (MHandledItem)menuItem);
        }
        manager.update(true);
        return swtMenu;
    }

    public Object createToolBar(MPart<?> part, Object widgetObject, MToolBar toolbar) {
        int orientation = 256;
        Composite composite = null;
        while (!(widgetObject instanceof Composite) && widgetObject instanceof Control) {
            widgetObject = ((Control)widgetObject).getParent();
        }
        if (!(widgetObject instanceof Composite)) {
            return null;
        }
        composite = (Composite)widgetObject;
        if (composite.getLayout() instanceof RowLayout) {
            RowLayout rl = (RowLayout)composite.getLayout();
            orientation = rl.type;
        }
        ToolBarManager manager = new ToolBarManager(0x800000 | orientation);
        ToolBar swtToolBar = manager.createControl(composite);
        swtToolBar.setData("modelElement", (Object)toolbar);
        EList items = toolbar.getItems();
        if (items != null && items.size() > 0) {
            for (MToolBarItem toolBarItem : toolbar.getItems()) {
                this.createToolBarItem(part, manager, toolBarItem);
            }
        }
        manager.update(true);
        return swtToolBar;
    }

    private void createToolBarItem(MPart<?> part, ToolBarManager manager, MToolBarItem toolBarItem) {
        if (toolBarItem instanceof MToolItemRenderer) {
            IContributionItem renderer = (IContributionItem)((MToolItemRenderer)toolBarItem).getRenderer();
            manager.add(renderer);
            return;
        }
        manager.add((IContributionItem)new HandledContributionItem((MHandledItem)toolBarItem, part.getContext()));
    }

    private void createMenuItem(MPart<?> part, MenuManager manager, MHandledItem handledItem) {
        if (handledItem instanceof MMenuItemRenderer) {
            IContributionItem renderer = (IContributionItem)((MMenuItemRenderer)handledItem).getRenderer();
            manager.add(renderer);
            return;
        }
        if (handledItem instanceof MMenuItem) {
            MMenuItem mItem = (MMenuItem)handledItem;
            String id = mItem.getId();
            if (mItem.isSeparator()) {
                if (!mItem.isVisible()) {
                    if (id != null) {
                        manager.add((IContributionItem)new GroupMarker(id));
                    }
                } else if (id == null) {
                    manager.add((IContributionItem)new Separator());
                } else {
                    manager.add((IContributionItem)new Separator(id));
                }
                return;
            }
            if (mItem.getMenu() != null) {
                MenuManager item = new MenuManager(mItem.getName(), id);
                manager.add((IContributionItem)item);
                for (MMenuItem menuItem : mItem.getMenu().getItems()) {
                    this.createMenuItem(part, item, (MHandledItem)menuItem);
                }
                return;
            }
        }
        manager.add((IContributionItem)new HandledContributionItem(handledItem, part.getContext()));
    }

    public <P extends MPart<?>> void processContents(MPart<P> me) {
        Widget parentWidget = (Widget)me.getWidget();
        if (parentWidget == null) {
            return;
        }
        EList parts = me.getChildren();
        if (parts != null) {
            for (MPart childME : parts) {
                this.renderer.createGui(childME);
            }
        }
    }

    public void bindWidget(MPart<?> me, Object widget) {
        me.setWidget(widget);
        ((Widget)widget).setData("modelElement", me);
        IStylingEngine engine = (IStylingEngine)me.getContext().get(IStylingEngine.SERVICE_NAME);
        engine.setId(widget, me.getId());
    }

    public Object unbindWidget(MPart<?> me) {
        Widget widget = (Widget)me.getWidget();
        if (widget != null) {
            me.setWidget(null);
            widget.setData("modelElement", null);
        }
        me.setOwner(null);
        return widget;
    }

    protected Widget getParentWidget(MPart<?> element) {
        return element.getParent() instanceof MPart ? (Widget)element.getParent().getWidget() : null;
    }

    public void disposeWidget(MPart<?> part) {
        Widget curWidget = (Widget)part.getWidget();
        if (curWidget instanceof Control) {
            curWidget = this.getOutermost((Control)curWidget);
        }
        if (curWidget != null && !curWidget.isDisposed()) {
            this.unbindWidget(part);
            curWidget.dispose();
        }
        part.setWidget(null);
    }

    public void hookControllerLogic(final MPart<?> me) {
        Widget widget = (Widget)me.getWidget();
        widget.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                MPart model = (MPart)e.widget.getData("modelElement");
                if (model != null) {
                    model.setWidget(null);
                }
            }
        });
        if (widget instanceof Control && me instanceof MItemPart) {
            ((Control)widget).getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

                public void getName(AccessibleEvent e) {
                    e.result = ((MItemPart)me).getName();
                }
            });
        }
    }

    protected Image getImage(MApplicationElement element) {
        if (element instanceof MItem) {
            ISWTResourceUtiltities resUtils;
            ImageDescriptor desc;
            String iconURI;
            IEclipseContext localContext = this.context;
            if (element instanceof MPart) {
                localContext = this.getContext((MPart)element);
            }
            if ((iconURI = ((MItem)element).getIconURI()) != null && !iconURI.equals("null") && (desc = (ImageDescriptor)(resUtils = (ISWTResourceUtiltities)localContext.get(IResourceUtiltities.class.getName())).imageDescriptorFromURI(URI.createURI((String)iconURI))) != null) {
                return desc.createImage();
            }
        }
        return null;
    }

    public void childAdded(MPart<?> parentElement, MPart<?> element) {
        if (parentElement != null && element != null) {
            return;
        }
        if (element.getWidget() instanceof Control && parentElement.getWidget() instanceof Composite) {
            Composite parentComp = (Composite)parentElement.getWidget();
            Control ctrl = (Control)element.getWidget();
            this.locallyShow(parentComp, ctrl);
        } else if (element.isVisible()) {
            this.renderer.createGui(element);
        }
    }

    public void childRemoved(MPart<?> parentElement, MPart<?> child) {
        super.childRemoved(parentElement, child);
        if (child.isVisible() && child.getWidget() instanceof Control) {
            Control ctrl = (Control)child.getWidget();
            this.locallyHide(ctrl);
        }
    }

    protected Control getOutermost(Control ctrl) {
        Composite curComposite = ctrl.getParent();
        Control outerMost = ctrl;
        while (curComposite != null && curComposite.getData("modelElement") == null && !(curComposite instanceof Shell)) {
            outerMost = curComposite;
            curComposite = curComposite.getParent();
        }
        return outerMost;
    }

    private void locallyShow(Composite parent, Control ctrl) {
        Control toReparent = this.getOutermost(ctrl);
        if (toReparent.getParent() != parent) {
            toReparent.setParent(parent);
            parent.layout(true);
        }
    }

    private void locallyHide(Control ctrl) {
        if (limbo == null) {
            limbo = new Shell(ctrl.getDisplay(), 0);
            limbo.setVisible(false);
        }
        Control toReparent = this.getOutermost(ctrl);
        Composite curParent = toReparent.getParent();
        toReparent.setParent((Composite)limbo);
        curParent.layout(true);
    }

    protected Composite createWrapperForStyling(Composite parentWidget, IEclipseContext context) {
        Composite layoutHolder = new Composite(parentWidget, 0);
        this.addLayoutForStyling(layoutHolder);
        layoutHolder.setData("org.eclipse.e4.ui.css.swt.marginWrapper", (Object)true);
        IStylingEngine engine = (IStylingEngine)context.get(IStylingEngine.SERVICE_NAME);
        engine.setClassname((Object)layoutHolder, "marginWrapper");
        return layoutHolder;
    }

    protected void addLayoutForStyling(Composite composite) {
        GridLayout gl = new GridLayout(1, true);
        composite.setLayout((Layout)gl);
        gl.horizontalSpacing = 0;
        gl.verticalSpacing = 0;
        gl.marginHeight = 0;
        gl.marginWidth = 0;
    }

    protected void configureForStyling(Control control) {
        control.setLayoutData((Object)new GridData(4, 4, true, true));
    }
}

