/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.workbench.ui.renderers.swt;

import org.eclipse.core.databinding.observable.value.AbstractObservableValue;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.e4.core.services.annotations.In;
import org.eclipse.e4.core.services.context.IEclipseContext;
import org.eclipse.e4.ui.model.application.ApplicationPackage;
import org.eclipse.e4.ui.model.application.MApplicationElement;
import org.eclipse.e4.ui.model.application.MItemPart;
import org.eclipse.e4.ui.model.application.MMenu;
import org.eclipse.e4.ui.model.application.MPart;
import org.eclipse.e4.ui.model.application.MStack;
import org.eclipse.e4.ui.model.application.MToolBar;
import org.eclipse.e4.ui.services.IStylingEngine;
import org.eclipse.e4.ui.widgets.CTabFolder;
import org.eclipse.e4.ui.widgets.CTabFolder2Adapter;
import org.eclipse.e4.ui.widgets.CTabFolder2Listener;
import org.eclipse.e4.ui.widgets.CTabFolderEvent;
import org.eclipse.e4.ui.widgets.CTabItem;
import org.eclipse.e4.ui.widgets.ETabFolder;
import org.eclipse.e4.ui.widgets.ETabItem;
import org.eclipse.e4.workbench.ui.internal.IValueFunction;
import org.eclipse.e4.workbench.ui.internal.Trackable;
import org.eclipse.e4.workbench.ui.renderers.swt.LazyStackRenderer;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.databinding.EMFObservables;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jface.databinding.swt.ISWTObservableValue;
import org.eclipse.jface.databinding.swt.SWTObservables;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.Widget;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StackRenderer
extends LazyStackRenderer {
    private static final String FOLDER_DISPOSED = "folderDisposed";
    Image viewMenuImage;
    @In
    IStylingEngine stylingEngine;

    public Object createWidget(MPart<?> part, Object parent) {
        ETabFolder newWidget = null;
        if (!(part instanceof MStack) || !(parent instanceof Composite)) {
            return null;
        }
        Widget parentWidget = (Widget)parent;
        if (parentWidget instanceof Composite) {
            boolean showCloseAlways = false;
            int styleModifier = 0;
            if (part.getPolicy() != null && part.getPolicy().length() > 0) {
                String policy = part.getPolicy();
                if (policy.indexOf("ViewStack") >= 0) {
                    styleModifier = 64;
                }
                if (policy.indexOf("EditorStack") >= 0) {
                    styleModifier = 64;
                    showCloseAlways = true;
                }
            }
            Composite stylingWrapper = this.createWrapperForStyling((Composite)parentWidget, part.getContext());
            ETabFolder ctf = new ETabFolder(stylingWrapper, 0x800 | styleModifier);
            this.configureForStyling((Control)ctf);
            ctf.setUnselectedCloseVisible(showCloseAlways);
            this.bindWidget(part, ctf);
            ctf.setVisible(true);
            newWidget = ctf;
            final IEclipseContext folderContext = part.getContext();
            folderContext.set("debugString", (Object)"TabFolder");
            folderContext.set("canCloseFunc", (Object)new IValueFunction(){

                public Object getValue() {
                    return true;
                }
            });
            folderContext.set(FOLDER_DISPOSED, (Object)Boolean.FALSE);
            final IEclipseContext toplevelContext = this.getToplevelContext(part);
            final Trackable updateActiveTab = new Trackable(folderContext, (CTabFolder)ctf){
                private final /* synthetic */ CTabFolder val$ctf;
                {
                    this.val$ctf = cTabFolder;
                    super($anonymous0);
                }

                public void run() {
                    IEclipseContext child;
                    if (!this.participating) {
                        return;
                    }
                    this.trackingContext.get(StackRenderer.FOLDER_DISPOSED);
                    IEclipseContext currentActive = toplevelContext;
                    while (currentActive != this.trackingContext && (child = (IEclipseContext)currentActive.get("activeChild")) != null && child != currentActive) {
                        currentActive = child;
                    }
                    String cssClassName = currentActive == this.trackingContext ? "active" : "inactive";
                    StackRenderer.this.stylingEngine.setClassname((Object)this.val$ctf, cssClassName);
                    if (this.val$ctf.getTopRight() != null) {
                        StackRenderer.this.stylingEngine.setClassname((Object)this.val$ctf.getTopRight(), cssClassName);
                    }
                    CTabItem[] items = this.val$ctf.getItems();
                    int i = 0;
                    while (i < items.length) {
                        StackRenderer.this.stylingEngine.setClassname((Object)items[i], cssClassName);
                        ++i;
                    }
                }
            };
            ctf.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent e) {
                    updateActiveTab.participating = false;
                    folderContext.set(StackRenderer.FOLDER_DISPOSED, (Object)Boolean.TRUE);
                }
            });
            folderContext.runAndTrack((Runnable)updateActiveTab);
        }
        return newWidget;
    }

    @Override
    public void postProcess(MPart<?> part) {
        super.postProcess(part);
        if (!(part instanceof MStack)) {
            return;
        }
        CTabFolder ctf = (CTabFolder)part.getWidget();
        MPart selPart = ((MStack)part).getActiveChild();
        if (selPart == null) {
            return;
        }
        CTabItem selItem = this.findItemForPart(part, selPart);
        if (selItem != null) {
            ctf.setSelection(selItem);
        }
    }

    @Override
    protected void internalChildAdded(MPart parentElement, MPart element) {
        super.internalChildAdded(parentElement, element);
        MItemPart itemPart = (MItemPart)element;
        CTabFolder ctf = (CTabFolder)parentElement.getWidget();
        int createFlags = 0;
        CTabItem cti = this.findItemForPart(parentElement, element);
        if (cti == null) {
            int index = this.calcIndexFor(element);
            cti = new ETabItem((ETabFolder)ctf, createFlags, index);
            String cssClassName = (String)ctf.getData("org.eclipse.e4.ui.css.CssClassName");
            this.stylingEngine.setClassname((Object)cti, cssClassName);
        }
        cti.setData("modelElement", (Object)element);
        cti.setText(itemPart.getName());
        cti.setImage(this.getImage((MApplicationElement)element));
        Control widget = (Control)element.getWidget();
        if (widget != null && widget.getParent() != cti.getParent()) {
            widget.setParent((Composite)cti.getParent());
        }
        cti.setControl(widget);
        this.hookTabControllerLogic(parentElement, element, cti);
    }

    private int calcIndexFor(MPart element) {
        int index = 0;
        EList kids = element.getParent().getChildren();
        for (MPart mPart : kids) {
            if (mPart == element) {
                return index;
            }
            if (!mPart.isVisible()) continue;
            ++index;
        }
        return index;
    }

    @Override
    public void childAdded(MPart<?> parentElement, MPart<?> element) {
        super.childAdded(parentElement, element);
        if (element instanceof MItemPart) {
            this.internalChildAdded(parentElement, element);
            Control ctrl = (Control)element.getWidget();
            if (ctrl != null) {
                this.showTab((MItemPart)element);
                this.stylingEngine.style((Object)ctrl);
            }
        }
    }

    private CTabItem findItemForPart(MPart<?> folder, MPart<?> part) {
        CTabFolder ctf = (CTabFolder)folder.getWidget();
        if (ctf == null) {
            return null;
        }
        CTabItem[] items = ctf.getItems();
        int i = 0;
        while (i < items.length) {
            if (items[i].getData("modelElement") == part) {
                return items[i];
            }
            ++i;
        }
        return null;
    }

    private void hookTabControllerLogic(MPart<?> parentElement, MPart<?> childElement, final CTabItem cti) {
        IObservableValue textObs = EMFObservables.observeValue(childElement, (EStructuralFeature)ApplicationPackage.Literals.MITEM__NAME);
        ISWTObservableValue uiObs = SWTObservables.observeText((Widget)cti);
        this.dbc.bindValue((IObservableValue)uiObs, textObs, null, null);
        IObservableValue emfTTipObs = EMFObservables.observeValue(childElement, (EStructuralFeature)ApplicationPackage.Literals.MITEM__TOOLTIP);
        AbstractObservableValue uiTTipObs = new AbstractObservableValue(){

            public Object getValueType() {
                return String.class;
            }

            protected Object doGetValue() {
                return cti.getToolTipText();
            }

            protected void doSetValue(Object val) {
                cti.setToolTipText((String)val);
            }
        };
        this.dbc.bindValue((IObservableValue)uiTTipObs, emfTTipObs, null, null);
        childElement.eAdapters().add((Object)new AdapterImpl(){

            public void notifyChanged(Notification msg) {
                MPart sm = (MPart)msg.getNotifier();
                if (ApplicationPackage.Literals.MITEM__ICON_URI.equals(msg.getFeature()) && !cti.isDisposed()) {
                    Image image = StackRenderer.this.getImage((MApplicationElement)sm);
                    cti.setImage(image);
                }
            }
        });
    }

    @Override
    public void childRemoved(MPart<?> parentElement, MPart<?> child) {
        boolean isEditorStack;
        super.childRemoved(parentElement, child);
        CTabItem oldItem = this.findItemForPart(parentElement, child);
        if (oldItem != null) {
            oldItem.setControl(null);
            oldItem.dispose();
        }
        CTabFolder ctf = (CTabFolder)parentElement.getWidget();
        String policy = parentElement.getPolicy();
        boolean bl = isEditorStack = policy != null && policy.indexOf("EditorStack") >= 0;
        if (ctf.getItemCount() == 0 && !isEditorStack) {
            final Shell sh = ctf.getShell();
            parentElement.setVisible(false);
            sh.getDisplay().asyncExec(new Runnable(){

                public void run() {
                    sh.layout(true, true);
                }
            });
        }
        if (isEditorStack) {
            parentElement.getChildren().remove(child);
        }
    }

    @Override
    public void hookControllerLogic(MPart<?> me) {
        super.hookControllerLogic(me);
        final MStack sm = (MStack)me;
        CTabFolder ctf = (CTabFolder)me.getWidget();
        ctf.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                MItemPart newPart = (MItemPart)e.item.getData("modelElement");
                if (sm.getActiveChild() != newPart) {
                    StackRenderer.this.activate((MPart)newPart);
                }
                StackRenderer.this.showTab(newPart);
            }
        });
        CTabFolder2Adapter closeListener = new CTabFolder2Adapter(){

            public void close(CTabFolderEvent event) {
                boolean canClose;
                MPart part = (MPart)event.item.getData("modelElement");
                IEclipseContext partContext = part.getContext();
                IValueFunction closeFunc = (IValueFunction)partContext.get("canCloseFunc");
                boolean bl = canClose = closeFunc == null || (Boolean)closeFunc.getValue() != false;
                if (!canClose) {
                    event.doit = false;
                    return;
                }
                part.setVisible(false);
            }
        };
        ctf.addCTabFolder2Listener((CTabFolder2Listener)closeListener);
        ctf.addListener(26, new Listener(){

            public void handleEvent(Event event) {
                CTabFolder ctf = (CTabFolder)event.widget;
                MStack stack = (MStack)ctf.getData("modelElement");
                MItemPart part = (MItemPart)stack.getActiveChild();
                if (part != null) {
                    StackRenderer.this.activate((MPart)part);
                }
            }
        });
        me.eAdapters().add(0, (Object)new AdapterImpl(){

            public void notifyChanged(Notification msg) {
                if (ApplicationPackage.Literals.MPART__ACTIVE_CHILD.equals(msg.getFeature())) {
                    MStack sm = (MStack)msg.getNotifier();
                    MPart selPart = sm.getActiveChild();
                    CTabFolder ctf = (CTabFolder)((MStack)msg.getNotifier()).getWidget();
                    CTabItem item = StackRenderer.this.findItemForPart((MPart)sm, selPart);
                    if (item != null && ctf.getSelection() != item) {
                        ctf.setSelection(item);
                    }
                }
            }
        });
    }

    private void showTab(MItemPart<?> part) {
        CTabFolder ctf = (CTabFolder)this.getParentWidget((MPart<?>)part);
        Control ctrl = (Control)part.getWidget();
        CTabItem cti = this.findItemForPart((MPart<?>)part.getParent(), (MPart<?>)part);
        cti.setControl(ctrl);
        ToolBar tb = this.getToolbar(part);
        if (tb != null) {
            Control curTR = ctf.getTopRight();
            if (curTR != null) {
                curTR.dispose();
            }
            if (tb.getSize().y > ctf.getTabHeight()) {
                ctf.setTabHeight(tb.getSize().y);
            }
            String cssClassName = (String)ctf.getData("org.eclipse.e4.ui.css.CssClassName");
            this.stylingEngine.setClassname((Object)tb, cssClassName);
            ctf.setTopRight((Control)tb, 131072);
            ctf.layout(true);
            ctf.notifyListeners(11, null);
        }
    }

    private ToolBar getToolbar(MItemPart<?> part) {
        if (part.getToolBar() == null && part.getMenu() == null) {
            return null;
        }
        CTabFolder ctf = (CTabFolder)this.getParentWidget((MPart<?>)part);
        MToolBar tbModel = part.getToolBar();
        ToolBar tb = tbModel != null ? (ToolBar)this.createToolBar(part.getParent(), ctf, tbModel) : new ToolBar((Composite)ctf, 0x800100);
        if (part.getMenu() != null) {
            this.addMenuButton(part, tb, part.getMenu());
        }
        tb.pack();
        return tb;
    }

    private void addMenuButton(MItemPart<?> part, ToolBar tb, MMenu menu) {
        ToolItem ti = new ToolItem(tb, 8);
        ti.setImage(this.getViewMenuImage());
        ti.setHotImage(null);
        ti.setToolTipText("View Menu");
        ti.setData("theMenu", (Object)menu);
        ti.setData("thePart", part);
        ti.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                StackRenderer.this.showMenu((ToolItem)e.widget);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                StackRenderer.this.showMenu((ToolItem)e.widget);
            }
        });
    }

    protected void showMenu(ToolItem item) {
        MMenu menuModel = (MMenu)item.getData("theMenu");
        MItemPart part = (MItemPart)item.getData("thePart");
        Menu menu = (Menu)this.createMenu((MPart<?>)part, item, menuModel);
        Rectangle ib = item.getBounds();
        Point displayAt = item.getParent().toDisplay(ib.x, ib.y + ib.height);
        menu.setLocation(displayAt);
        menu.setVisible(true);
        Display display = Display.getCurrent();
        while (!menu.isDisposed() && menu.isVisible()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        menu.dispose();
    }

    private Image getViewMenuImage() {
        if (this.viewMenuImage == null) {
            Display d = Display.getCurrent();
            Image viewMenu = new Image((Device)d, 16, 16);
            Image viewMenuMask = new Image((Device)d, 16, 16);
            Display display = Display.getCurrent();
            GC gc = new GC((Drawable)viewMenu);
            GC maskgc = new GC((Drawable)viewMenuMask);
            gc.setForeground(display.getSystemColor(17));
            gc.setBackground(display.getSystemColor(25));
            int[] shapeArray = new int[]{6, 1, 15, 1, 11, 5, 10, 5};
            gc.fillPolygon(shapeArray);
            gc.drawPolygon(shapeArray);
            Color black = display.getSystemColor(2);
            Color white = display.getSystemColor(1);
            maskgc.setBackground(black);
            maskgc.fillRectangle(0, 0, 16, 16);
            maskgc.setBackground(white);
            maskgc.setForeground(white);
            maskgc.fillPolygon(shapeArray);
            maskgc.drawPolygon(shapeArray);
            gc.dispose();
            maskgc.dispose();
            ImageData data = viewMenu.getImageData();
            data.transparentPixel = data.getPixel(0, 0);
            this.viewMenuImage = new Image((Device)d, viewMenu.getImageData(), viewMenuMask.getImageData());
            viewMenu.dispose();
            viewMenuMask.dispose();
        }
        return this.viewMenuImage;
    }
}

