/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.workbench.ui.renderers.swt;

import org.eclipse.e4.ui.model.application.MPart;
import org.eclipse.e4.ui.model.application.MToolBar;
import org.eclipse.e4.ui.model.application.MToolBarContainer;
import org.eclipse.e4.ui.model.application.MTrimmedPart;
import org.eclipse.e4.workbench.ui.renderers.swt.SWTPartRenderer;
import org.eclipse.e4.workbench.ui.renderers.swt.TrimmedPartLayout;
import org.eclipse.emf.common.util.EList;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TrimRenderer
extends SWTPartRenderer {
    public Object createWidget(MPart<?> element, Object parent) {
        if (!(element instanceof MTrimmedPart) || !(parent instanceof Composite)) {
            return null;
        }
        Composite parentWidget = (Composite)parent;
        Composite trimmedComp = new Composite(parentWidget, 0);
        TrimmedPartLayout trimLayout = new TrimmedPartLayout(trimmedComp);
        trimmedComp.setLayout((Layout)trimLayout);
        return trimLayout.clientArea;
    }

    @Override
    public <P extends MPart<?>> void processContents(MPart<P> me) {
        if (!(me instanceof MTrimmedPart)) {
            return;
        }
        MTrimmedPart trimModel = (MTrimmedPart)me;
        Composite clientArea = (Composite)me.getWidget();
        Composite trimmedComp = clientArea.getParent();
        TrimmedPartLayout layout = (TrimmedPartLayout)trimmedComp.getLayout();
        if (this.hasVisibleChildren(trimModel.getTopTrim())) {
            layout.top = this.createTrim(trimmedComp, 256, trimModel, trimModel.getTopTrim());
        }
        if (this.hasVisibleChildren(trimModel.getBottomTrim())) {
            layout.bottom = this.createTrim(trimmedComp, 256, trimModel, trimModel.getBottomTrim());
        }
        if (this.hasVisibleChildren(trimModel.getLeftTrim())) {
            layout.left = this.createTrim(trimmedComp, 512, trimModel, trimModel.getLeftTrim());
        }
        if (this.hasVisibleChildren(trimModel.getRightTrim())) {
            layout.right = this.createTrim(trimmedComp, 512, trimModel, trimModel.getRightTrim());
        }
        super.processContents(me);
    }

    private Composite createTrim(Composite trimmedComp, int orientation, MTrimmedPart<?> trimModel, MToolBarContainer trimContainer) {
        Composite trimComposite = new Composite(trimmedComp, 0);
        RowLayout trl = new RowLayout(orientation);
        trl.marginTop = 1;
        trl.marginBottom = 1;
        trimComposite.setLayout((Layout)trl);
        for (MToolBar tb : trimContainer.getToolbars()) {
            this.createToolBar((MPart<?>)trimModel, trimComposite, tb);
        }
        return trimComposite;
    }

    private boolean hasVisibleChildren(MToolBarContainer trimSide) {
        if (trimSide == null) {
            return false;
        }
        EList kids = trimSide.getToolbars();
        return kids != null && kids.size() > 0;
    }
}

