/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.workbench.ui.renderers.swt;

import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class TrimmedPartLayout
extends Layout {
    public Composite top;
    public Composite bottom;
    public Composite left;
    public Composite right;
    public Composite clientArea;

    public TrimmedPartLayout(Composite parent) {
        this.clientArea = new Composite(parent, 0);
        this.clientArea.setLayout((Layout)new FillLayout());
    }

    protected Point computeSize(Composite composite, int wHint, int hHint, boolean flushCache) {
        return new Point(-1, -1);
    }

    protected void layout(Composite composite, boolean flushCache) {
        Rectangle newBounds;
        Rectangle ca = composite.getClientArea();
        Rectangle caRect = new Rectangle(0, 0, ca.width, ca.height);
        final Shell shell = composite.getShell();
        shell.setLayoutDeferred(true);
        if (this.top != null) {
            Point topSize = this.top.computeSize(caRect.width, -1, true);
            caRect.y += topSize.y;
            caRect.height -= topSize.y;
            newBounds = new Rectangle(0, 0, caRect.width, topSize.y);
            if (!newBounds.equals((Object)this.top.getBounds())) {
                this.top.setBounds(newBounds);
                shell.layout(new Control[]{this.top});
            }
        }
        if (this.bottom != null) {
            Point bottomSize = this.bottom.computeSize(caRect.width, -1, true);
            caRect.height -= bottomSize.y;
            newBounds = new Rectangle(0, caRect.y + caRect.height, caRect.width, bottomSize.y);
            if (!newBounds.equals((Object)this.bottom.getBounds())) {
                this.bottom.setBounds(newBounds);
                shell.layout(new Control[]{this.bottom});
            }
        }
        if (this.left != null) {
            Point leftSize = this.left.computeSize(-1, caRect.height, true);
            caRect.x += leftSize.x;
            caRect.width -= leftSize.x;
            newBounds = new Rectangle(0, caRect.y, leftSize.x, caRect.height);
            if (!newBounds.equals((Object)this.left.getBounds())) {
                this.left.setBounds(newBounds);
                shell.layout(new Control[]{this.left});
            }
        }
        if (this.right != null) {
            Point rightSize = this.right.computeSize(-1, caRect.height, true);
            caRect.width -= rightSize.x;
            newBounds = new Rectangle(caRect.x + caRect.width, caRect.y, rightSize.x, caRect.height);
            if (!newBounds.equals((Object)this.right.getBounds())) {
                this.right.setBounds(caRect.x + caRect.width, caRect.y, rightSize.x, caRect.height);
                shell.layout(new Control[]{this.right});
            }
        }
        if (!caRect.equals((Object)this.clientArea.getBounds())) {
            this.clientArea.setBounds(caRect);
            shell.layout(new Control[]{this.clientArea});
        }
        shell.getDisplay().asyncExec(new Runnable(){

            public void run() {
                shell.setLayoutDeferred(false);
            }
        });
    }
}

