/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.workbench.ui.renderers.swt;

import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.e4.core.services.Logger;
import org.eclipse.e4.core.services.annotations.In;
import org.eclipse.e4.core.services.context.IEclipseContext;
import org.eclipse.e4.ui.model.application.ApplicationPackage;
import org.eclipse.e4.ui.model.application.MApplicationElement;
import org.eclipse.e4.ui.model.application.MPart;
import org.eclipse.e4.ui.model.application.MWindow;
import org.eclipse.e4.ui.model.workbench.MWorkbenchWindow;
import org.eclipse.e4.workbench.ui.renderers.swt.SWTPartRenderer;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.databinding.EMFObservables;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jface.databinding.swt.ISWTObservableValue;
import org.eclipse.jface.databinding.swt.SWTObservables;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WBWRenderer
extends SWTPartRenderer {
    @In
    Logger logger;

    public Object createWidget(MPart<?> part, Object parent) {
        Shell newWidget;
        block8: {
            String uri;
            Shell wbwShell;
            if (!(part instanceof MWindow) || parent != null && !(parent instanceof Shell)) {
                return null;
            }
            MWindow window = (MWindow)part;
            Shell parentShell = (Shell)parent;
            IEclipseContext parentContext = this.getContextForParent(part);
            if (parentShell == null) {
                wbwShell = new Shell(Display.getCurrent(), 1264);
            } else {
                wbwShell = new Shell(parentShell, 1264);
                wbwShell.setLocation(window.getX(), window.getY());
                wbwShell.setSize(window.getWidth(), window.getHeight());
                wbwShell.setVisible(true);
            }
            wbwShell.setLayout((Layout)new FillLayout());
            newWidget = wbwShell;
            this.bindWidget(part, newWidget);
            IEclipseContext localContext = part.getContext();
            localContext.set("debugString", (Object)"MWorkbenchWindow");
            parentContext.set("activeChild", (Object)localContext);
            localContext.set(Shell.class.getName(), (Object)wbwShell);
            localContext.set("localActiveShell", (Object)wbwShell);
            if (!(part instanceof MWorkbenchWindow)) {
                wbwShell.setLayout((Layout)new FillLayout());
            }
            if (((MWindow)part).getName() != null) {
                wbwShell.setText(((MWindow)part).getName());
            }
            if ((uri = ((MWindow)part).getIconURI()) != null) {
                try {
                    Image image = ImageDescriptor.createFromURL((URL)new URL(uri)).createImage();
                    wbwShell.setImage(image);
                }
                catch (MalformedURLException e) {
                    if (this.logger == null) break block8;
                    this.logger.error((Throwable)e);
                }
            }
        }
        return newWidget;
    }

    @Override
    public void hookControllerLogic(MPart<?> me) {
        ISWTObservableValue uiTextObs;
        super.hookControllerLogic(me);
        Widget widget = (Widget)me.getWidget();
        if (widget instanceof Shell && me instanceof MWindow) {
            final Shell shell = (Shell)widget;
            final MWindow w = (MWindow)me;
            shell.addControlListener(new ControlListener(){

                public void controlResized(ControlEvent e) {
                    w.setWidth(shell.getSize().x);
                    w.setHeight(shell.getSize().y);
                }

                public void controlMoved(ControlEvent e) {
                    w.setX(shell.getLocation().x);
                    w.setY(shell.getLocation().y);
                }
            });
        }
        IObservableValue emfTextObs = EMFObservables.observeValue(me, (EStructuralFeature)ApplicationPackage.Literals.MITEM__NAME);
        if (widget instanceof Control && !(widget instanceof Composite)) {
            uiTextObs = SWTObservables.observeText((Control)((Control)widget));
            this.dbc.bindValue((IObservableValue)uiTextObs, emfTextObs, null, null);
        } else if (widget instanceof Item) {
            uiTextObs = SWTObservables.observeText((Widget)widget);
            this.dbc.bindValue((IObservableValue)uiTextObs, emfTextObs, null, null);
        }
        IObservableValue emfTTipObs = EMFObservables.observeValue(me, (EStructuralFeature)ApplicationPackage.Literals.MITEM__TOOLTIP);
        if (widget instanceof Control) {
            ISWTObservableValue uiTTipObs = SWTObservables.observeTooltipText((Control)((Control)widget));
            this.dbc.bindValue((IObservableValue)uiTTipObs, emfTTipObs, null, null);
        } else if (widget instanceof Item && !(widget instanceof MenuItem)) {
            ISWTObservableValue uiTTipObs = SWTObservables.observeTooltipText((Widget)widget);
            this.dbc.bindValue((IObservableValue)uiTTipObs, emfTTipObs, null, null);
        }
        me.eAdapters().add((Object)new AdapterImpl(){

            public void notifyChanged(Notification msg) {
                Widget widget;
                MPart sm = (MPart)msg.getNotifier();
                if (ApplicationPackage.Literals.MITEM__ICON_URI.equals(msg.getFeature()) && (widget = (Widget)sm.getWidget()) instanceof Item) {
                    Item item = (Item)widget;
                    Image image = WBWRenderer.this.getImage((MApplicationElement)sm);
                    if (image != null) {
                        item.setImage(image);
                    }
                }
            }
        });
    }

    @Override
    public <P extends MPart<?>> void processContents(MPart<P> me) {
        super.processContents(me);
        if (me.getMenu() != null) {
            this.createMenu(me, me.getWidget(), me.getMenu());
        }
    }

    public void postProcess(MPart<?> childME) {
        super.postProcess(childME);
        Shell shell = (Shell)childME.getWidget();
        shell.layout(true);
    }
}

