/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.tm.ui.editor;

import java.util.ArrayList;
import java.util.Collection;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.e4.tm.builder.IBuilder;
import org.eclipse.e4.tm.ui.Activator;
import org.eclipse.e4.tm.ui.EditorPartModelContext;
import org.eclipse.e4.tm.ui.ModelPartContent;
import org.eclipse.e4.tm.ui.TmLabelProvider;
import org.eclipse.e4.tm.ui.TmPartStyle;
import org.eclipse.e4.tm.ui.editor.IPostProcessor;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.presentation.EcoreEditor;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.ui.dnd.EditingDomainViewerDropAdapter;
import org.eclipse.emf.edit.ui.dnd.LocalTransfer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.SWTError;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbenchPart;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TmEcoreEditor
extends EcoreEditor {
    protected ModelPartContent modelContent;
    private TmPartStyle partStyle = new TmPartStyle.SashStyle();
    private boolean autoLoadToolkitModels = true;
    private IPostProcessor[] postProcessors;
    public static final String TM_FILE_EXTENSION = "tm";

    protected Composite createPageContainer(Composite parent) {
        this.partStyle.createPageContainer(parent);
        this.partStyle.addTmComposite((Object)this);
        return this.partStyle.getTreeParent();
    }

    public void createPages() {
        this.postProcessors = Activator.getDefault().getPostProcessors();
        super.createPages();
        this.selectionViewer.setLabelProvider((IBaseLabelProvider)new TmLabelProvider((ILabelProvider)this.selectionViewer.getLabelProvider()));
        this.modelContent = new ModelPartContent(this.partStyle.getTmComposite((Object)this)){

            protected void buildModel(EObject model) {
                super.buildModel(model);
                IPostProcessor[] iPostProcessorArray = TmEcoreEditor.this.postProcessors;
                int n = iPostProcessorArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IPostProcessor postProcessor = iPostProcessorArray[n2];
                    postProcessor.postBuildModel(model, (IBuilder)this.getBuilder(), new IAdaptable(){

                        public Object getAdapter(Class key) {
                            if (key.equals(Composite.class)) {
                                return this.getModelComposite();
                            }
                            return TmEcoreEditor.this.getAdapter(key);
                        }
                    });
                    ++n2;
                }
            }
        };
        if (this.autoLoadToolkitModels) {
            this.loadToolkitModel();
        }
        IPostProcessor[] iPostProcessorArray = this.postProcessors;
        int n = this.postProcessors.length;
        int n2 = 0;
        while (n2 < n) {
            IPostProcessor postProcessor = iPostProcessorArray[n2];
            postProcessor.postLoadModel((IAdaptable)this);
            ++n2;
        }
        this.modelContent.setModelContext(new EditorPartModelContext((IWorkbenchPart)this));
    }

    public Object getAdapter(Class key) {
        if (key.equals(EditingDomain.class)) {
            return this.getEditingDomain();
        }
        if (key.equals(URIConverter.class)) {
            return this.getEditingDomain().getResourceSet().getURIConverter();
        }
        if (key.equals(Composite.class)) {
            return this.getContainer();
        }
        if (IEditorInput.class.isAssignableFrom(key) && key.isInstance(this.getEditorInput())) {
            return this.getEditorInput();
        }
        IPostProcessor[] iPostProcessorArray = this.postProcessors;
        int n = this.postProcessors.length;
        int n2 = 0;
        while (n2 < n) {
            IPostProcessor postProcessor = iPostProcessorArray[n2];
            Object adapted = postProcessor.getAdapter(key);
            if (key.isInstance(adapted)) {
                return adapted;
            }
            ++n2;
        }
        return super.getAdapter(key);
    }

    private void loadToolkitModel() {
        ResourceSet resSet = this.getEditingDomain().getResourceSet();
        EList resources = resSet.getResources();
        Resource[] resourceArray = resources.toArray(new Resource[resources.size()]);
        int n = resourceArray.length;
        int n2 = 0;
        while (n2 < n) {
            Resource res = resourceArray[n2];
            URI uri = res.getURI();
            URI tmUri = uri.trimFileExtension().appendFileExtension(TM_FILE_EXTENSION);
            if ("xmi".equals(uri.fileExtension()) && resSet.getURIConverter().exists(tmUri, null)) {
                try {
                    resSet.getResource(tmUri, true);
                    break;
                }
                catch (RuntimeException runtimeException) {}
            }
            ++n2;
        }
    }

    protected void createContextMenuForGen(StructuredViewer viewer) {
        block2: {
            Transfer[] transferTypes = new Transfer[]{TextTransfer.getInstance(), LocalTransfer.getInstance()};
            viewer.addDropSupport(3, transferTypes, (DropTargetListener)new EditingDomainViewerDropAdapter(this.getEditingDomain(), (Viewer)viewer){

                private boolean isTransfer(Transfer transfer, DropTargetEvent event) {
                    int i = 0;
                    while (i < event.dataTypes.length) {
                        if (transfer.isSupportedType(event.dataTypes[i])) {
                            return true;
                        }
                        ++i;
                    }
                    return false;
                }

                protected void helper(DropTargetEvent event) {
                    if (this.isTransfer((Transfer)TextTransfer.getInstance(), event)) {
                        event.feedback = 1 | this.getAutoFeedback();
                        this.originalOperation = 1;
                        event.detail = 1;
                    } else {
                        super.helper(event);
                    }
                }

                protected Collection<?> getDragSource(DropTargetEvent event) {
                    if (this.isTransfer((Transfer)TextTransfer.getInstance(), event)) {
                        return null;
                    }
                    return super.getDragSource(event);
                }

                protected Collection<?> extractDragSource(Object object) {
                    if (object instanceof String) {
                        return TmEcoreEditor.this.getDragSource((String)object);
                    }
                    return super.extractDragSource(object);
                }
            });
            try {
                super.createContextMenuForGen(viewer);
            }
            catch (SWTError swtError) {
                if (swtError.code == 2001) break block2;
                throw swtError;
            }
        }
    }

    private Collection<EObject> getDragSource(String uris) {
        ArrayList<EObject> eObjects = new ArrayList<EObject>();
        ResourceSetImpl resSet = new ResourceSetImpl();
        StringTokenizer tokens = new StringTokenizer(uris);
        while (tokens.hasMoreTokens()) {
            Resource res;
            EObject eObject;
            String uri = tokens.nextToken();
            int pos = uri.indexOf("#");
            if (pos <= 0 || (eObject = (res = resSet.getResource(URI.createURI((String)uri.substring(0, pos)), true)).getEObject(uri.substring(pos + "#".length()))) == null) continue;
            eObjects.add(EcoreUtil.copy((EObject)eObject));
        }
        return eObjects;
    }
}

