/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.touchpoint.eclipse.actions;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.equinox.internal.p2.touchpoint.eclipse.Util;
import org.eclipse.equinox.internal.p2.touchpoint.eclipse.actions.Messages;
import org.eclipse.equinox.internal.provisional.p2.engine.IProfile;
import org.eclipse.equinox.internal.provisional.p2.engine.ProvisioningAction;
import org.eclipse.equinox.internal.provisional.p2.metadata.IArtifactKey;
import org.eclipse.equinox.internal.provisional.p2.metadata.IInstallableUnit;
import org.eclipse.osgi.util.NLS;

public class LinkAction
extends ProvisioningAction {
    public static final String ID = "ln";

    public IStatus execute(Map parameters) {
        String linkTarget;
        String targetDir = (String)parameters.get("targetDir");
        if (targetDir == null) {
            return Util.createError(NLS.bind((String)Messages.parameter_not_set, (Object)"targetDir", (Object)ID));
        }
        if (targetDir.equals("@artifact")) {
            try {
                targetDir = LinkAction.resolveArtifactParam(parameters);
            }
            catch (CoreException e) {
                return e.getStatus();
            }
            File dir = new File(targetDir);
            if (!dir.isDirectory()) {
                return Util.createError(NLS.bind((String)Messages.artifact_not_directory, (Object)dir));
            }
        }
        if ((linkTarget = (String)parameters.get("linkTarget")) == null) {
            return Util.createError(NLS.bind((String)Messages.parameter_not_set, (Object)"linkTarget", (Object)ID));
        }
        String linkName = (String)parameters.get("linkName");
        if (linkName == null) {
            return Util.createError(NLS.bind((String)Messages.parameter_not_set, (Object)"linkName", (Object)ID));
        }
        String force = (String)parameters.get("force");
        this.ln(targetDir, linkTarget, linkName, Boolean.valueOf(force));
        return Status.OK_STATUS;
    }

    public IStatus undo(Map parameters) {
        return null;
    }

    private void ln(String targetDir, String linkTarget, String linkName, boolean force) {
        Runtime r = Runtime.getRuntime();
        try {
            Process process = r.exec(new String[]{ID, "-s" + (force ? "f" : ""), linkTarget, String.valueOf(targetDir) + '/' + linkName});
            this.readOffStream(process.getErrorStream());
            this.readOffStream(process.getInputStream());
            try {
                process.waitFor();
            }
            catch (InterruptedException interruptedException) {
                Thread.currentThread().interrupt();
            }
        }
        catch (IOException iOException) {}
    }

    private void readOffStream(InputStream inputStream) {
        block12: {
            BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream));
            try {
                try {
                    while (reader.readLine() != null) {
                    }
                }
                catch (IOException iOException) {
                    try {
                        reader.close();
                    }
                    catch (IOException iOException2) {}
                    break block12;
                }
            }
            catch (Throwable throwable) {
                try {
                    reader.close();
                }
                catch (IOException iOException) {}
                throw throwable;
            }
            try {
                reader.close();
            }
            catch (IOException iOException) {}
        }
    }

    private static String resolveArtifactParam(Map parameters) throws CoreException {
        IProfile profile = (IProfile)parameters.get("profile");
        IInstallableUnit iu = (IInstallableUnit)parameters.get("iu");
        IArtifactKey[] artifacts = iu.getArtifacts();
        if (artifacts == null || artifacts.length == 0) {
            throw new CoreException(Util.createError(NLS.bind((String)Messages.iu_contains_no_arifacts, (Object)iu)));
        }
        IArtifactKey artifactKey = artifacts[0];
        File fileLocation = Util.getArtifactFile(artifactKey, profile);
        if (fileLocation == null || !fileLocation.exists()) {
            throw new CoreException(Util.createError(NLS.bind((String)Messages.artifact_file_not_found, (Object)artifactKey)));
        }
        return fileLocation.getAbsolutePath();
    }
}

