/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.touchpoint.eclipse.actions;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.preferences.IPreferencesService;
import org.eclipse.equinox.internal.p2.core.helpers.ServiceHelper;
import org.eclipse.equinox.internal.p2.engine.Profile;
import org.eclipse.equinox.internal.p2.touchpoint.eclipse.Activator;
import org.eclipse.equinox.internal.p2.touchpoint.eclipse.Util;
import org.eclipse.equinox.internal.p2.touchpoint.eclipse.actions.Messages;
import org.eclipse.equinox.internal.provisional.p2.artifact.repository.IArtifactRepositoryManager;
import org.eclipse.equinox.internal.provisional.p2.engine.IProfile;
import org.eclipse.equinox.internal.provisional.p2.engine.IProfileRegistry;
import org.eclipse.equinox.internal.provisional.p2.engine.ProvisioningAction;
import org.eclipse.equinox.internal.provisional.p2.metadata.repository.IMetadataRepositoryManager;
import org.eclipse.equinox.internal.provisional.p2.repository.IRepositoryManager;
import org.eclipse.equinox.internal.provisional.p2.repository.RepositoryEvent;
import org.eclipse.osgi.util.NLS;
import org.osgi.framework.BundleContext;
import org.osgi.service.prefs.BackingStoreException;
import org.osgi.service.prefs.Preferences;

abstract class RepositoryAction
extends ProvisioningAction {
    private static final String METADATA_REPOSITORY = "org.eclipse.equinox.p2.metadata.repository";
    private static final String ARTIFACT_REPOSITORY = "org.eclipse.equinox.p2.artifact.repository";
    private static final String NODE_REPOSITORIES = "repositories";
    private static final String REPOSITORY_COUNT = "count";
    private static final String KEY_URI = "uri";
    private static final String KEY_ENABLED = "enabled";
    private static final String KEY_NICKNAME = "nickname";
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    RepositoryAction() {
    }

    private static IRepositoryManager getRepositoryManager(int type) {
        if (type == 0) {
            return (IRepositoryManager)ServiceHelper.getService((BundleContext)Activator.getContext(), (String)IMetadataRepositoryManager.SERVICE_NAME);
        }
        if (type == 1) {
            return (IRepositoryManager)ServiceHelper.getService((BundleContext)Activator.getContext(), (String)IArtifactRepositoryManager.SERVICE_NAME);
        }
        return null;
    }

    protected void addRepositoryToProfile(Profile profile, URI location, String nickname, int type, boolean enabled) {
        Preferences node = this.getRepositoryPreferenceNode(profile, location, type);
        int count = 0;
        if (this.repositoryExists(node) && (count = this.getRepositoryCount(node)) == 0) {
            count = 1;
        }
        node.put(KEY_URI, location.toString());
        node.put(KEY_ENABLED, Boolean.toString(enabled));
        if (nickname != null) {
            node.put(KEY_NICKNAME, nickname);
        }
        this.setRepositoryCount(node, ++count);
        try {
            node.flush();
        }
        catch (BackingStoreException backingStoreException) {}
    }

    protected void addToSelf(RepositoryEvent event) {
        String name;
        IRepositoryManager manager = RepositoryAction.getRepositoryManager(event.getRepositoryType());
        URI location = event.getRepositoryLocation();
        Preferences node = this.getRepositoryPreferenceNode(null, location, event.getRepositoryType());
        int count = this.getRepositoryCount(node);
        if (manager.contains(location)) {
            if (count == 0) {
                count = 1;
            }
        } else if (manager != null) {
            manager.addRepository(location);
        }
        this.setRepositoryCount(node, ++count);
        if (!event.isRepositoryEnabled()) {
            manager.setEnabled(location, false);
        }
        if ((name = event.getRepositoryNickname()) != null) {
            manager.setRepositoryProperty(location, "p2.nickname", name);
        }
    }

    protected RepositoryEvent createEvent(Map parameters) throws CoreException {
        String parm = (String)parameters.get("location");
        if (parm == null) {
            throw new CoreException(Util.createError(NLS.bind((String)Messages.parameter_not_set, (Object)"location", (Object)this.getId())));
        }
        URI location = null;
        try {
            location = new URI(parm);
        }
        catch (URISyntaxException e) {
            throw new CoreException(Util.createError(NLS.bind((String)Messages.parameter_not_set, (Object)"location", (Object)this.getId()), e));
        }
        parm = (String)parameters.get("type");
        if (parm == null) {
            throw new CoreException(Util.createError(NLS.bind((String)Messages.parameter_not_set, (Object)"type", (Object)this.getId())));
        }
        int type = 0;
        try {
            type = Integer.parseInt(parm);
        }
        catch (NumberFormatException e) {
            throw new CoreException(Util.createError(NLS.bind((String)Messages.parameter_not_set, (Object)"type", (Object)this.getId()), e));
        }
        String name = (String)parameters.get("name");
        String enablement = (String)parameters.get(KEY_ENABLED);
        boolean enabled = enablement == null ? true : Boolean.valueOf(enablement);
        return RepositoryEvent.newDiscoveryEvent((URI)location, (String)name, (int)type, (boolean)enabled);
    }

    protected abstract String getId();

    protected boolean isSelfProfile(Profile profile) {
        IProfileRegistry registry;
        if (profile == null) {
            return true;
        }
        BundleContext bundleContext = Activator.getContext();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.equinox.internal.provisional.p2.engine.IProfileRegistry");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((registry = (IProfileRegistry)ServiceHelper.getService((BundleContext)bundleContext, (String)clazz.getName())) == null) {
            return false;
        }
        IProfile selfProfile = registry.getProfile("_SELF_");
        if (selfProfile == null) {
            return true;
        }
        return profile.getProfileId().equals(selfProfile.getProfileId());
    }

    protected void removeFromSelf(RepositoryEvent event) {
        IRepositoryManager manager = RepositoryAction.getRepositoryManager(event.getRepositoryType());
        Preferences node = this.getRepositoryPreferenceNode(null, event.getRepositoryLocation(), event.getRepositoryType());
        int count = this.getRepositoryCount(node);
        if (--count < 1 && manager != null) {
            manager.removeRepository(event.getRepositoryLocation());
        }
        this.setRepositoryCount(node, count);
    }

    protected void removeRepositoryFromProfile(Profile profile, URI location, int type) {
        Preferences node = this.getRepositoryPreferenceNode(profile, location, type);
        int count = this.getRepositoryCount(node);
        if (--count < 1) {
            try {
                String[] keys = node.keys();
                int i = 0;
                while (i < keys.length) {
                    node.remove(keys[i]);
                    ++i;
                }
            }
            catch (BackingStoreException backingStoreException) {}
        } else {
            this.setRepositoryCount(node, count);
        }
        try {
            node.flush();
        }
        catch (BackingStoreException backingStoreException) {}
    }

    protected int getRepositoryCount(Preferences node) {
        return node.getInt(REPOSITORY_COUNT, 0);
    }

    protected void setRepositoryCount(Preferences node, int count) {
        if (count < 1) {
            node.remove(REPOSITORY_COUNT);
        } else {
            node.putInt(REPOSITORY_COUNT, count);
        }
    }

    protected boolean repositoryExists(Preferences node) {
        return node.get(KEY_URI, null) != null;
    }

    protected Preferences getRepositoryPreferenceNode(Profile profile, URI location, int type) {
        String key = type == 0 ? METADATA_REPOSITORY : ARTIFACT_REPOSITORY;
        BundleContext bundleContext = Activator.getContext();
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.core.runtime.preferences.IPreferencesService");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        IPreferencesService prefService = (IPreferencesService)ServiceHelper.getService((BundleContext)bundleContext, (String)clazz.getName());
        if (profile != null) {
            return prefService.getRootNode().node("/profile/" + profile.getProfileId() + "/" + key + "/" + NODE_REPOSITORIES + "/" + this.getKey(location));
        }
        return prefService.getRootNode().node("/profile/_SELF_/" + key + "/" + NODE_REPOSITORIES + "/" + this.getKey(location));
    }

    private String getKey(URI location) {
        String key = location.toString().replace('/', '_');
        if (key.endsWith("_")) {
            key = key.substring(0, key.length() - 1);
        }
        return key;
    }
}

