/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.tm.builder;

import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import org.eclipse.e4.tm.builder.IBinderContext;
import org.eclipse.e4.tm.stringconverters.ClassStringConverter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReflectionSupport {
    private IBinderContext context;
    private Map<String, Method> methodMap = new HashMap<String, Method>();
    private Map<Object, Method> getterMap = new HashMap<Object, Method>();
    private Map<Object, Method> setterMap = new HashMap<Object, Method>();
    private Map<Object, Field> fieldMap = new HashMap<Object, Field>();

    public ReflectionSupport(IBinderContext context) {
        this.context = context;
    }

    static boolean hasSingleParameterForValue(Class<?>[] parameterTypes, Object value, boolean ignoreType) {
        return parameterTypes.length == 1 && (ignoreType || ClassStringConverter.getObjectClass(parameterTypes[0]).isInstance(value));
    }

    public Method getMethod(Object object, String signature) {
        String key = String.valueOf(object.getClass().getName()) + '.' + signature;
        Method method = this.methodMap.get(key);
        if (method != null) {
            return method;
        }
        Class[] types = null;
        int pos = signature.indexOf(40);
        try {
            if (pos >= 0) {
                StringTokenizer parameters = new StringTokenizer(signature.substring(pos + 1, signature.length() - 1), ",");
                signature = signature.substring(0, pos);
                types = new Class[parameters.countTokens()];
                int i = 0;
                while (parameters.hasMoreTokens()) {
                    String typeSpec = parameters.nextToken();
                    boolean isArray = false;
                    if (typeSpec.endsWith("[]")) {
                        isArray = true;
                        typeSpec = typeSpec.substring(0, typeSpec.length() - 2);
                    } else if (typeSpec.endsWith("*")) {
                        isArray = true;
                        typeSpec = typeSpec.substring(0, typeSpec.length() - 1);
                    }
                    Class<?> type = this.context.convert(typeSpec, Class.class);
                    if (isArray) {
                        type = Array.newInstance(type, 0).getClass();
                    }
                    types[i] = type;
                    ++i;
                }
            }
            method = object.getClass().getMethod(signature, types);
            this.methodMap.put(key, method);
        }
        catch (Exception exception) {}
        return method;
    }

    public Method getGetterMethod(Object object, String name) {
        String key = String.valueOf(object.getClass().getName()) + '.' + name;
        Method method = this.getterMap.get(key);
        if (method != null) {
            return method;
        }
        Method[] methods = object.getClass().getMethods();
        int i = 0;
        while (i < methods.length) {
            method = methods[i];
            if (this.isPrefixedName(method.getName(), "get", name) && method.getParameterTypes().length == 0) {
                this.getterMap.put(key, method);
                return method;
            }
            ++i;
        }
        return null;
    }

    private boolean isPrefixedName(String name, String prefix, String propertyName) {
        return name.length() == 3 + propertyName.length() && name.startsWith(prefix) && name.charAt(prefix.length()) == Character.toUpperCase(propertyName.charAt(0)) && name.endsWith(propertyName.substring(1));
    }

    public Method getSetterMethod(Object object, String name, Object value, boolean ignoreType) {
        String key = String.valueOf(object.getClass().getName()) + '.' + name;
        Method method = this.setterMap.get(key);
        if (method != null) {
            return method;
        }
        Method[] methods = object.getClass().getMethods();
        int i = 0;
        while (i < methods.length) {
            method = methods[i];
            if (this.isPrefixedName(method.getName(), "set", name) && ReflectionSupport.hasSingleParameterForValue(method.getParameterTypes(), value, ignoreType)) {
                this.setterMap.put(key, method);
                return method;
            }
            ++i;
        }
        return null;
    }

    private Field getField(Object object, String name, Object value, boolean ignoreType) {
        String key = String.valueOf(object.getClass().getName()) + '.' + name;
        Field field = this.fieldMap.get(key);
        if (field != null) {
            return field;
        }
        try {
            field = object.getClass().getField(name);
            if (ignoreType || value == null || ClassStringConverter.getObjectClass(field.getType()).isInstance(value)) {
                this.fieldMap.put(key, field);
                return field;
            }
        }
        catch (Exception exception) {}
        return null;
    }

    public Object getGetterProperty(Object object, String name) {
        Method getterMethod = this.getGetterMethod(object, name);
        Exception ex = null;
        if (getterMethod != null) {
            try {
                return getterMethod.invoke(object, null);
            }
            catch (Exception e) {
                ex = e;
            }
        }
        throw new RuntimeException("Couldn't invoke getter for " + name, ex);
    }

    public Object getMethodProperty(Object object, String methodSpec, Object[] args) {
        Method method = this.getMethod(object, methodSpec);
        Exception ex = null;
        if (method != null) {
            try {
                return method.invoke(object, args);
            }
            catch (Exception e) {
                ex = e;
            }
        }
        throw new RuntimeException("Couldn't invoke method for " + methodSpec, ex);
    }

    public Object getFieldProperty(Object object, String name) {
        Field field = this.getField(object, name, null, true);
        Exception ex = null;
        if (field != null) {
            try {
                return field.get(object);
            }
            catch (Exception e) {
                ex = e;
            }
        }
        throw new RuntimeException("Couldn't get field for " + name, ex);
    }

    public Exception setSetterProperty(Object object, String name, Object value) {
        Method setterMethod = this.getSetterMethod(object, name, value, true);
        if (setterMethod != null) {
            try {
                value = this.context.adapt(value, setterMethod.getParameterTypes()[0]);
                setterMethod.invoke(object, value);
                return null;
            }
            catch (Exception e) {
                return e;
            }
        }
        return new NoSuchMethodException("Couldn't invoke setter for " + name);
    }

    public Exception setMethodProperty(Object object, String methodSpec, Object[] args) {
        Method method = this.getMethod(object, methodSpec);
        if (method != null) {
            try {
                Class<?>[] parameterTypes = method.getParameterTypes();
                int i = 0;
                while (i < args.length) {
                    args[i] = this.context.adapt(args[i], parameterTypes[i]);
                    ++i;
                }
                method.invoke(object, args);
                return null;
            }
            catch (Exception e) {
                return e;
            }
        }
        return new NoSuchMethodException("Couldn't invoke method for " + methodSpec);
    }

    public Exception setFieldProperty(Object object, String name, Object value) {
        Field field = this.getField(object, name, value, true);
        if (field != null) {
            try {
                value = this.context.adapt(value, field.getType());
                field.set(object, value);
                return null;
            }
            catch (Exception e) {
                return e;
            }
        }
        return new NoSuchFieldException("No field for " + name);
    }

    public void setProperty(Object object, String name, Object value) throws Exception {
        Exception ex = this.setSetterProperty(object, name, value);
        if (ex != null) {
            ex = this.setFieldProperty(object, name, value);
        }
        if (ex != null) {
            throw ex;
        }
    }
}

