/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.director;

import java.util.Arrays;
import java.util.Dictionary;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.equinox.internal.p2.core.helpers.LogHelper;
import org.eclipse.equinox.internal.p2.core.helpers.Tracing;
import org.eclipse.equinox.internal.p2.director.DirectorActivator;
import org.eclipse.equinox.internal.p2.director.Messages;
import org.eclipse.equinox.internal.p2.director.QueryableArray;
import org.eclipse.equinox.internal.p2.director.TwoTierMap;
import org.eclipse.equinox.internal.provisional.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.internal.provisional.p2.metadata.IInstallableUnitPatch;
import org.eclipse.equinox.internal.provisional.p2.metadata.IRequiredCapability;
import org.eclipse.equinox.internal.provisional.p2.metadata.IRequirementChange;
import org.eclipse.equinox.internal.provisional.p2.metadata.query.CapabilityQuery;
import org.eclipse.equinox.internal.provisional.p2.query.Collector;
import org.eclipse.equinox.internal.provisional.p2.query.IQueryable;
import org.eclipse.equinox.internal.provisional.p2.query.Query;
import org.eclipse.osgi.util.NLS;
import org.osgi.framework.InvalidSyntaxException;

public class Slicer {
    private static boolean DEBUG = false;
    private IQueryable possibilites;
    private LinkedList toProcess;
    private Set considered;
    private TwoTierMap slice;
    protected Dictionary selectionContext;
    private MultiStatus result;
    private boolean considerMetaRequirements = false;

    public Slicer(IQueryable input, Dictionary context, boolean considerMetaRequirements) {
        this.possibilites = input;
        this.slice = new TwoTierMap();
        this.selectionContext = context;
        this.result = new MultiStatus("org.eclipse.equinox.p2.director", 0, Messages.Planner_Problems_resolving_plan, null);
        this.considerMetaRequirements = considerMetaRequirements;
    }

    public IQueryable slice(IInstallableUnit[] ius, IProgressMonitor monitor) {
        try {
            long start = 0L;
            if (DEBUG) {
                start = System.currentTimeMillis();
                System.out.println("Start slicing: " + start);
            }
            this.validateInput(ius);
            this.considered = new HashSet<IInstallableUnit>(Arrays.asList(ius));
            this.toProcess = new LinkedList(this.considered);
            while (!this.toProcess.isEmpty()) {
                if (monitor.isCanceled()) {
                    this.result.merge(Status.CANCEL_STATUS);
                    throw new OperationCanceledException();
                }
                this.processIU((IInstallableUnit)this.toProcess.removeFirst());
            }
            if (DEBUG) {
                long stop = System.currentTimeMillis();
                System.out.println("Slicing complete: " + (stop - start));
            }
        }
        catch (IllegalStateException e) {
            this.result.add((IStatus)new Status(4, "org.eclipse.equinox.p2.director", e.getMessage(), (Throwable)e));
        }
        if (Tracing.DEBUG && this.result.getSeverity() != 0) {
            LogHelper.log((IStatus)this.result);
        }
        if (this.result.getSeverity() == 4) {
            return null;
        }
        return new QueryableArray(this.considered.toArray(new IInstallableUnit[this.considered.size()]));
    }

    public MultiStatus getStatus() {
        return this.result;
    }

    private void validateInput(IInstallableUnit[] ius) {
        int i = 0;
        while (i < ius.length) {
            if (!this.isApplicable(ius[i])) {
                throw new IllegalStateException("The IU " + ius[i] + " can't be installed in this environment because its filter does not match.");
            }
            ++i;
        }
    }

    protected boolean isApplicable(IRequiredCapability req) {
        String filter = req.getFilter();
        if (filter == null) {
            return true;
        }
        try {
            return DirectorActivator.context.createFilter(filter).match(this.selectionContext);
        }
        catch (InvalidSyntaxException invalidSyntaxException) {
            return false;
        }
    }

    protected boolean isApplicable(IInstallableUnit iu) {
        String enablementFilter = iu.getFilter();
        if (enablementFilter == null) {
            return true;
        }
        try {
            return DirectorActivator.context.createFilter(enablementFilter).match(this.selectionContext);
        }
        catch (InvalidSyntaxException invalidSyntaxException) {
            return false;
        }
    }

    protected void processIU(IInstallableUnit iu) {
        iu = iu.unresolved();
        this.slice.put(iu.getId(), iu.getVersion(), iu);
        if (!this.isApplicable(iu)) {
            return;
        }
        IRequiredCapability[] reqs = this.getRequiredCapabilities(iu);
        if (reqs.length == 0) {
            return;
        }
        int i = 0;
        while (i < reqs.length) {
            if (this.isApplicable(reqs[i]) && this.isGreedy(reqs[i])) {
                this.expandRequirement(iu, reqs[i]);
            }
            ++i;
        }
    }

    protected boolean isGreedy(IRequiredCapability req) {
        return req.isGreedy();
    }

    private IRequiredCapability[] getRequiredCapabilities(IInstallableUnit iu) {
        if (!(iu instanceof IInstallableUnitPatch)) {
            if (iu.getMetaRequiredCapabilities().length == 0 || !this.considerMetaRequirements) {
                return iu.getRequiredCapabilities();
            }
            IRequiredCapability[] aggregatedCapabilities = new IRequiredCapability[iu.getRequiredCapabilities().length + iu.getMetaRequiredCapabilities().length];
            System.arraycopy(iu.getRequiredCapabilities(), 0, aggregatedCapabilities, 0, iu.getRequiredCapabilities().length);
            System.arraycopy(iu.getMetaRequiredCapabilities(), 0, aggregatedCapabilities, iu.getRequiredCapabilities().length, iu.getMetaRequiredCapabilities().length);
            return aggregatedCapabilities;
        }
        IInstallableUnitPatch patchIU = (IInstallableUnitPatch)iu;
        IRequirementChange[] changes = patchIU.getRequirementsChange();
        int initialRequirementCount = iu.getRequiredCapabilities().length;
        IRequiredCapability[] aggregatedCapabilities = new IRequiredCapability[initialRequirementCount + changes.length];
        System.arraycopy(iu.getRequiredCapabilities(), 0, aggregatedCapabilities, 0, initialRequirementCount);
        int i = 0;
        while (i < changes.length) {
            aggregatedCapabilities[initialRequirementCount++] = changes[i].newValue();
            ++i;
        }
        return aggregatedCapabilities;
    }

    private void expandRequirement(IInstallableUnit iu, IRequiredCapability req) {
        Collector matches = this.possibilites.query((Query)new CapabilityQuery(req), new Collector(), null);
        int validMatches = 0;
        Iterator iterator = matches.iterator();
        while (iterator.hasNext()) {
            IInstallableUnit match = (IInstallableUnit)iterator.next();
            if (!this.isApplicable(match)) continue;
            ++validMatches;
            if (this.slice.containsKey(match.getId(), match.getVersion())) continue;
            this.consider(match);
        }
        if (validMatches == 0) {
            if (req.isOptional()) {
                if (DEBUG) {
                    System.out.println("No IU found to satisfy optional dependency of " + iu + " on req " + req);
                }
            } else {
                this.result.add((IStatus)new Status(2, "org.eclipse.equinox.p2.director", NLS.bind((String)Messages.Planner_Unsatisfied_dependency, (Object)iu, (Object)req)));
            }
        }
    }

    private void consider(IInstallableUnit match) {
        if (this.considered.add(match)) {
            this.toProcess.addLast(match);
        }
    }
}

