/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.engine;

import java.io.File;
import java.net.URL;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.internal.preferences.EclipsePreferences;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.equinox.internal.p2.core.helpers.LogHelper;
import org.eclipse.equinox.internal.p2.core.helpers.ServiceHelper;
import org.eclipse.equinox.internal.p2.core.helpers.Tracing;
import org.eclipse.equinox.internal.p2.core.helpers.URLUtil;
import org.eclipse.equinox.internal.p2.engine.EngineActivator;
import org.eclipse.equinox.internal.p2.engine.Messages;
import org.eclipse.equinox.internal.p2.engine.SimpleProfileRegistry;
import org.eclipse.equinox.internal.provisional.p2.core.location.AgentLocation;
import org.eclipse.equinox.internal.provisional.p2.engine.IProfileRegistry;
import org.osgi.framework.BundleContext;
import org.osgi.service.prefs.BackingStoreException;

public class ProfilePreferences
extends EclipsePreferences {
    private static Set loadedNodes = new HashSet();
    public static final Object PROFILE_SAVE_JOB_FAMILY = new Object();
    private static final long SAVE_SCHEDULE_DELAY = 500L;
    private IEclipsePreferences loadLevel;
    private Object profileLock;
    private String qualifier;
    private SaveJob saveJob;
    private int segmentCount;
    static /* synthetic */ Class class$0;

    public ProfilePreferences() {
        this(null, null);
    }

    public ProfilePreferences(EclipsePreferences nodeParent, String nodeName) {
        super(nodeParent, nodeName);
        String path = this.absolutePath();
        this.segmentCount = ProfilePreferences.getSegmentCount((String)path);
        if (this.segmentCount <= 1) {
            return;
        }
        if (this.segmentCount == 2) {
            this.profileLock = new Object();
        }
        if (this.segmentCount < 3) {
            return;
        }
        this.qualifier = ProfilePreferences.getSegment((String)path, (int)2);
    }

    private boolean containsProfile(String profileId) {
        BundleContext bundleContext = EngineActivator.getContext();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.equinox.internal.provisional.p2.engine.IProfileRegistry");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        IProfileRegistry profileRegistry = (IProfileRegistry)ServiceHelper.getService((BundleContext)bundleContext, (String)clazz.getName());
        if (profileId == null || profileRegistry == null) {
            return false;
        }
        return profileRegistry.containsProfile(profileId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doSave() throws BackingStoreException {
        Object object = ((ProfilePreferences)this.parent).profileLock;
        synchronized (object) {
            String profileId = ProfilePreferences.getSegment((String)this.absolutePath(), (int)1);
            if (!this.containsProfile(profileId)) {
                IPath location;
                if ("_SELF_".equals(profileId) && (location = this.getDefaultLocation()) != null) {
                    super.save(location);
                    return;
                }
                if (Tracing.DEBUG_PROFILE_PREFERENCES) {
                    Tracing.debug((String)("Not saving preferences since there is no file for node: " + this.absolutePath()));
                }
                return;
            }
            super.save(this.getProfileLocation(profileId));
        }
    }

    private IPath getDefaultLocation() {
        AgentLocation location = (AgentLocation)ServiceHelper.getService((BundleContext)EngineActivator.getContext(), (String)AgentLocation.SERVICE_NAME);
        if (location == null) {
            LogHelper.log((IStatus)new Status(2, "org.eclipse.equinox.p2.engine", "Agent location service not available", (Throwable)new RuntimeException()));
            return null;
        }
        Path dataArea = new Path(URLUtil.toFile((URL)location.getDataArea("org.eclipse.equinox.p2.engine")).getAbsolutePath());
        return this.computeLocation((IPath)dataArea, this.qualifier);
    }

    protected IEclipsePreferences getLoadLevel() {
        if (this.loadLevel == null) {
            if (this.qualifier == null) {
                return null;
            }
            ProfilePreferences node = this;
            int i = 3;
            while (i < this.segmentCount) {
                node = (EclipsePreferences)node.parent();
                ++i;
            }
            this.loadLevel = node;
        }
        return this.loadLevel;
    }

    private IPath getProfileLocation(String profileId) {
        BundleContext bundleContext = EngineActivator.getContext();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.equinox.internal.provisional.p2.engine.IProfileRegistry");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        SimpleProfileRegistry profileRegistry = (SimpleProfileRegistry)ServiceHelper.getService((BundleContext)bundleContext, (String)clazz.getName());
        File profileDataDirectory = profileRegistry.getProfileDataDirectory(profileId);
        return this.computeLocation((IPath)new Path(profileDataDirectory.getAbsolutePath()), this.qualifier);
    }

    protected EclipsePreferences internalCreate(EclipsePreferences nodeParent, String nodeName, Object context) {
        return new ProfilePreferences(nodeParent, nodeName);
    }

    protected synchronized boolean isAlreadyLoaded(IEclipsePreferences node) {
        return loadedNodes.contains(node.absolutePath());
    }

    protected synchronized boolean isAlreadyLoaded(String path) {
        return loadedNodes.contains(path);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void load() throws BackingStoreException {
        Object object = ((ProfilePreferences)this.parent).profileLock;
        synchronized (object) {
            String profileId = ProfilePreferences.getSegment((String)this.absolutePath(), (int)1);
            if (!this.containsProfile(profileId)) {
                IPath location;
                if ("_SELF_".equals(profileId) && (location = this.getDefaultLocation()) != null) {
                    this.load(location);
                    return;
                }
                if (Tracing.DEBUG_PROFILE_PREFERENCES) {
                    Tracing.debug((String)("Not loading preferences since there is no file for node: " + this.absolutePath()));
                }
                return;
            }
            this.load(this.getProfileLocation(profileId));
        }
    }

    protected synchronized void loaded() {
        loadedNodes.add(this.name());
    }

    public void removeNode() throws BackingStoreException {
        super.removeNode();
        loadedNodes.remove(this.absolutePath());
    }

    protected synchronized void save() {
        BundleContext context;
        if (this.saveJob == null) {
            this.saveJob = new SaveJob();
        }
        if ((context = EngineActivator.getContext()) == null) {
            return;
        }
        try {
            if (context.getBundle().getState() == 32) {
                this.saveJob.schedule(500L);
            }
        }
        catch (IllegalStateException illegalStateException) {}
    }

    private class SaveJob
    extends Job {
        SaveJob() {
            super(Messages.ProfilePreferences_saving);
            this.setSystem(true);
        }

        public boolean belongsTo(Object family) {
            return family == PROFILE_SAVE_JOB_FAMILY;
        }

        protected IStatus run(IProgressMonitor monitor) {
            try {
                ProfilePreferences.this.doSave();
            }
            catch (BackingStoreException e) {
                LogHelper.log((IStatus)new Status(2, "org.eclipse.equinox.p2.engine", "Exception saving profile preferences", (Throwable)e));
            }
            return Status.OK_STATUS;
        }
    }
}

