/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.ds.model;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Vector;
import org.eclipse.equinox.internal.ds.Activator;
import org.eclipse.equinox.internal.ds.InstanceProcess;
import org.eclipse.equinox.internal.ds.Messages;
import org.eclipse.equinox.internal.ds.Reference;
import org.eclipse.equinox.internal.ds.SCRUtil;
import org.eclipse.equinox.internal.ds.impl.ComponentInstanceImpl;
import org.eclipse.equinox.internal.ds.model.ServiceComponent;
import org.eclipse.equinox.internal.util.io.Externalizable;
import org.eclipse.osgi.util.NLS;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.ComponentInstance;

public class ComponentReference
implements Externalizable {
    public static final int CARDINALITY_0_1 = 0;
    public static final int CARDINALITY_0_N = 1;
    public static final int CARDINALITY_1_1 = 2;
    public static final int CARDINALITY_1_N = 3;
    public static final int POLICY_STATIC = 0;
    public static final int POLICY_DYNAMIC = 1;
    public String name;
    public String interfaceName;
    public int cardinality = 2;
    public int policy = 0;
    public String target;
    public String bind;
    public String unbind;
    public ServiceComponent component;
    private boolean bindCached;
    private boolean unbindCached;
    Method bindMethod;
    Method unbindMethod;
    public Hashtable serviceReferences = new Hashtable(3);
    private Hashtable serviceReferencesToUnbind = new Hashtable(3);
    static final Class[] SERVICE_REFERENCE;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    static {
        Class[] classArray = new Class[1];
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.osgi.framework.ServiceReference");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[0] = clazz;
        SERVICE_REFERENCE = classArray;
    }

    ComponentReference(ServiceComponent component) {
        this.component = component;
        if (this.component.references == null) {
            this.component.references = new Vector(2);
        }
        this.component.references.addElement(this);
    }

    Method getMethod(ComponentInstanceImpl componentInstance, Reference reference, String methodName, ServiceReference serviceReference) {
        Class<?> consumerClass = componentInstance.getInstance().getClass();
        Object serviceObject = null;
        Class<?> serviceObjectClass = null;
        Class<?> interfaceClass = null;
        Class[] param_interfaceClass = null;
        Method method = null;
        while (consumerClass != null) {
            try {
                method = consumerClass.getDeclaredMethod(methodName, SERVICE_REFERENCE);
            }
            catch (NoSuchMethodException noSuchMethodException) {
            }
            catch (NoClassDefFoundError err) {
                this.logWarning(NLS.bind((String)Messages.EXCEPTION_GETTING_METHOD, (Object)methodName, (Object)consumerClass.getName()), err, reference);
            }
            if (method != null && SCRUtil.checkMethodAccess(componentInstance.getInstance().getClass(), consumerClass, method, this.component.namespace11)) break;
            if (serviceObject == null) {
                serviceObject = componentInstance.bindedServices.get(serviceReference);
                if (serviceObject == null) {
                    serviceObject = InstanceProcess.staticRef.getService(reference, serviceReference);
                }
                if (serviceObject == null) {
                    this.logWarning(Messages.CANT_GET_SERVICE_OBJECT, null, reference);
                    return null;
                }
                componentInstance.bindedServices.put(serviceReference, serviceObject);
                Class<?> searchForInterfaceClass = serviceObjectClass = serviceObject.getClass();
                while (searchForInterfaceClass != null) {
                    Class<?>[] interfaceClasses = searchForInterfaceClass.getInterfaces();
                    int i = 0;
                    while (i < interfaceClasses.length) {
                        if (interfaceClasses[i].getName().equals(this.interfaceName)) {
                            interfaceClass = interfaceClasses[i];
                            break;
                        }
                        ++i;
                    }
                    if (interfaceClass != null) break;
                    if (searchForInterfaceClass.getName().equals(this.interfaceName)) {
                        interfaceClass = searchForInterfaceClass;
                        break;
                    }
                    searchForInterfaceClass = searchForInterfaceClass.getSuperclass();
                }
                param_interfaceClass = new Class[]{interfaceClass};
            }
            try {
                method = consumerClass.getDeclaredMethod(methodName, param_interfaceClass);
            }
            catch (NoSuchMethodException noSuchMethodException) {
            }
            catch (NoClassDefFoundError err) {
                this.logWarning(NLS.bind((String)Messages.EXCEPTION_GETTING_METHOD, (Object)methodName, (Object)consumerClass.getName()), err, reference);
            }
            if (method != null && SCRUtil.checkMethodAccess(componentInstance.getInstance().getClass(), consumerClass, method, this.component.namespace11)) break;
            Method[] methods = consumerClass.getDeclaredMethods();
            int i = 0;
            while (i < methods.length) {
                Class<?>[] params = methods[i].getParameterTypes();
                if (params.length == 1 && methods[i].getName().equals(methodName) && params[0].isAssignableFrom(serviceObjectClass)) {
                    method = methods[i];
                    break;
                }
                ++i;
            }
            if (method != null && SCRUtil.checkMethodAccess(componentInstance.getInstance().getClass(), consumerClass, method, this.component.namespace11)) break;
            if (this.component.namespace11) {
                i = 0;
                while (i < methods.length) {
                    Class<?>[] params = methods[i].getParameterTypes();
                    if (params.length == 2 && methods[i].getName().equals(methodName) && params[0] == interfaceClass) {
                        Class<?> clazz = params[1];
                        Class<?> clazz2 = class$1;
                        if (clazz2 == null) {
                            try {
                                clazz2 = Class.forName("java.util.Map");
                            }
                            catch (ClassNotFoundException classNotFoundException) {
                                throw new NoClassDefFoundError(classNotFoundException.getMessage());
                            }
                        }
                        if (clazz == clazz2) {
                            method = methods[i];
                            break;
                        }
                    }
                    ++i;
                }
                if (method != null && SCRUtil.checkMethodAccess(componentInstance.getInstance().getClass(), consumerClass, method, true)) break;
                i = 0;
                while (i < methods.length) {
                    Class<?>[] params = methods[i].getParameterTypes();
                    if (params.length == 2 && methods[i].getName().equals(methodName) && params[0].isAssignableFrom(serviceObjectClass)) {
                        Class<?> clazz = params[1];
                        Class<?> clazz3 = class$1;
                        if (clazz3 == null) {
                            try {
                                clazz3 = Class.forName("java.util.Map");
                            }
                            catch (ClassNotFoundException classNotFoundException) {
                                throw new NoClassDefFoundError(classNotFoundException.getMessage());
                            }
                        }
                        if (clazz == clazz3) {
                            method = methods[i];
                            break;
                        }
                    }
                    ++i;
                }
            }
            if (method != null) break;
            consumerClass = consumerClass.getSuperclass();
        }
        if (method == null) {
            this.logMethodNotFoundError(componentInstance, reference, methodName);
            return null;
        }
        if (!SCRUtil.checkMethodAccess(componentInstance.getInstance().getClass(), consumerClass, method, this.component.namespace11)) {
            this.logMethodNotVisible(componentInstance, reference, methodName, method.getParameterTypes());
            return null;
        }
        int modifier = method.getModifiers();
        if (!Modifier.isPublic(modifier)) {
            SCRUtil.setAccessible(method);
        }
        return method;
    }

    private void logMethodNotVisible(ComponentInstanceImpl componentInstance, Reference reference, String methodName, Class[] param_interfaceClasses) {
        StringBuffer buffer = this.createBuffer();
        buffer.append("[SCR] Method ");
        buffer.append(methodName);
        buffer.append('(');
        int i = 0;
        while (i < param_interfaceClasses.length) {
            buffer.append(param_interfaceClasses[i].getName());
            if (i < param_interfaceClasses.length - 1) {
                buffer.append(',');
            }
            ++i;
        }
        buffer.append(')');
        buffer.append(" is not accessible!");
        this.appendDetails(buffer, reference);
        String message = buffer.toString();
        Activator.log(reference.reference.component.bc, 1, message, null);
    }

    private void logMethodNotFoundError(ComponentInstanceImpl componentInstance, Reference reference, String methodName) {
        StringBuffer buffer = this.createBuffer();
        buffer.append("[SCR] Method was not found: ");
        buffer.append(methodName);
        buffer.append('(');
        buffer.append("...");
        buffer.append(')');
        this.appendDetails(buffer, reference);
        String message = buffer.toString();
        Activator.log(reference.reference.component.bc, 1, message, null);
    }

    private void appendDetails(StringBuffer buffer, Reference reference) {
        try {
            String indent = "\n\t";
            buffer.append(indent);
            buffer.append("Details:");
            buffer.append(indent);
            buffer.append("Problematic reference = " + reference.reference);
            buffer.append(indent);
            buffer.append("of service component = ");
            buffer.append(reference.reference.component.name);
            buffer.append(indent);
            buffer.append("component implementation class = ");
            buffer.append(reference.reference.component.implementation);
            buffer.append(indent);
            buffer.append("located in bundle with symbolic name = ");
            buffer.append(this.component.bc.getBundle().getSymbolicName());
            buffer.append(indent);
            buffer.append("bundle location = ");
            buffer.append(this.component.bc.getBundle().getLocation());
        }
        catch (Throwable throwable) {}
    }

    private void logWarning(String message, Throwable t, Reference reference) {
        StringBuffer buffer = this.createBuffer();
        buffer.append(message);
        this.appendDetails(buffer, reference);
        Activator.log(reference.reference.component.bc, 2, buffer.toString(), t);
    }

    private void logError(String message, Throwable t, Reference reference) {
        StringBuffer buffer = this.createBuffer();
        buffer.append(message);
        this.appendDetails(buffer, reference);
        Activator.log(reference.reference.component.bc, 1, buffer.toString(), t);
    }

    private StringBuffer createBuffer() {
        return new StringBuffer(400);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    final void bind(Reference reference, ComponentInstance instance, ServiceReference serviceReference) throws Exception {
        block31: {
            block32: {
                if (this.bind == null) break block31;
                isComponentFactory = this.component.factory != null;
                var5_5 = this.serviceReferences;
                synchronized (var5_5) {
                    if (isComponentFactory) {
                        instances = (Vector<ComponentInstance>)this.serviceReferences.get(serviceReference);
                        if (instances == null) {
                            instances = new Vector<ComponentInstance>(2);
                            instances.addElement(instance);
                            this.serviceReferences.put(serviceReference, instances);
                        } else {
                            if (instances.contains(instance)) {
                                if (reference.isUnary()) {
                                    this.logWarning(NLS.bind((String)Messages.SERVICE_REFERENCE_ALREADY_BOUND, (Object)serviceReference, (Object)instance), null, reference);
                                }
                                return;
                            }
                            instances.addElement(instance);
                        }
                    } else {
                        compInstance = this.serviceReferences.get(serviceReference);
                        if (compInstance == instance) {
                            if (reference.isUnary()) {
                                this.logWarning(NLS.bind((String)Messages.SERVICE_REFERENCE_ALREADY_BOUND, (Object)serviceReference, (Object)instance), null, reference);
                            }
                            return;
                        }
                        if (compInstance != null) {
                            this.logWarning(NLS.bind((String)Messages.SERVICE_REFERENCE_BOUND, (Object)serviceReference, compInstance), null, reference);
                            return;
                        }
                        this.serviceReferences.put(serviceReference, instance);
                    }
                }
                if (!this.bindCached) {
                    this.bindMethod = this.getMethod((ComponentInstanceImpl)instance, reference, this.bind, serviceReference);
                    if (this.bindMethod != null) {
                        this.bindCached = true;
                    }
                }
                if (this.bindMethod == null) break block32;
                methodParam /* !! */  = null;
                paramTypes = this.bindMethod.getParameterTypes();
                if (paramTypes.length != 1) ** GOTO lbl-1000
                v1 = paramTypes[0];
                v2 = ComponentReference.class$0;
                if (v2 == null) {
                    try {
                        v2 = ComponentReference.class$0 = Class.forName("org.osgi.framework.ServiceReference");
                    }
                    catch (ClassNotFoundException v3) {
                        throw new NoClassDefFoundError(v3.getMessage());
                    }
                }
                if (v1.equals(v2)) {
                    methodParam /* !! */  = serviceReference;
                } else lbl-1000:
                // 2 sources

                {
                    if ((methodParam /* !! */  = (ServiceReference)((ComponentInstanceImpl)instance).bindedServices.get(serviceReference)) == null && (methodParam /* !! */  = InstanceProcess.staticRef.getService(reference, serviceReference)) != null) {
                        ((ComponentInstanceImpl)instance).bindedServices.put(serviceReference, methodParam /* !! */ );
                    }
                    if (methodParam /* !! */  == null) {
                        this.removeServiceReference(serviceReference, instance);
                        return;
                    }
                }
                params = null;
                if (paramTypes.length == 1) {
                    params = SCRUtil.getObjectArray();
                    params[0] = methodParam /* !! */ ;
                } else {
                    map = new HashMap<String, Object>();
                    keys = serviceReference.getPropertyKeys();
                    i = 0;
                    while (i < keys.length) {
                        map.put(keys[i], serviceReference.getProperty(keys[i]));
                        ++i;
                    }
                    params = new Object[]{methodParam /* !! */ , map};
                }
                try {
                    try {
                        this.bindMethod.invoke(instance.getInstance(), params);
                    }
                    catch (Throwable t) {
                        this.logError(NLS.bind((String)Messages.ERROR_BINDING_REFERENCE, (Object)this), t, reference);
                        this.removeServiceReference(serviceReference, instance);
                        if (params.length != 1) ** GOTO lbl91
                        SCRUtil.release(params);
                    }
                }
                finally {
                    if (params.length == 1) {
                        SCRUtil.release(params);
                    }
                }
            }
            this.removeServiceReference(serviceReference, instance);
            this.logWarning(NLS.bind((String)Messages.BIND_METHOD_NOT_FOUND_OR_NOT_ACCESSIBLE, (Object)this.bind), null, reference);
        }
    }

    private void removeServiceReference(ServiceReference serviceReference, ComponentInstance instance) {
        boolean isComponentFactory;
        boolean bl = isComponentFactory = this.component.factory != null;
        if (isComponentFactory) {
            Vector instances = (Vector)this.serviceReferences.get(serviceReference);
            instances.removeElement(instance);
            if (instances.isEmpty()) {
                this.serviceReferences.remove(serviceReference);
            }
        } else {
            this.serviceReferences.remove(serviceReference);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void unbind(Reference reference, ComponentInstance instance, ServiceReference serviceReference) {
        boolean componentFactory;
        block60: {
            Class<?>[] paramTypes;
            Object methodParam;
            block62: {
                boolean referenceExists = true;
                componentFactory = this.component.factory != null;
                Hashtable hashtable = this.serviceReferences;
                synchronized (hashtable) {
                    Vector instances;
                    if (componentFactory) {
                        instances = (Vector)this.serviceReferences.get(serviceReference);
                        if (instances == null) {
                            referenceExists = false;
                        } else if (!instances.contains(instance)) {
                            this.logWarning(NLS.bind((String)Messages.INSTANCE_NOT_BOUND, (Object)instance), null, reference);
                            return;
                        }
                    } else {
                        Object compInstance = this.serviceReferences.get(serviceReference);
                        if (compInstance == null) {
                            referenceExists = false;
                        } else if (compInstance != instance) {
                            this.logWarning(NLS.bind((String)Messages.INSTANCE_NOT_BOUND, (Object)instance), null, reference);
                            return;
                        }
                    }
                    if (referenceExists) {
                        if (componentFactory) {
                            instances = (Vector)this.serviceReferencesToUnbind.get(serviceReference);
                            if (instances != null && instances.contains(instance)) {
                                return;
                            }
                            if (instances == null) {
                                instances = new Vector(2);
                                this.serviceReferencesToUnbind.put(serviceReference, instances);
                            }
                            instances.addElement(instance);
                        } else {
                            if (this.serviceReferencesToUnbind.get(serviceReference) == instance) {
                                return;
                            }
                            this.serviceReferencesToUnbind.put(serviceReference, instance);
                        }
                    }
                }
                if (!referenceExists) {
                    this.logWarning(NLS.bind((String)Messages.INVALID_SERVICE_REFERENCE, (Object)serviceReference), null, reference);
                    return;
                }
                if (this.unbind == null) break block60;
                if (!this.unbindCached) {
                    this.unbindCached = true;
                    this.unbindMethod = this.getMethod((ComponentInstanceImpl)instance, reference, this.unbind, serviceReference);
                }
                if (this.unbindMethod == null) break block60;
                methodParam = null;
                paramTypes = this.unbindMethod.getParameterTypes();
                if (paramTypes.length == 1) {
                    Class<?> clazz = paramTypes[0];
                    Class<?> clazz2 = class$0;
                    if (clazz2 == null) {
                        try {
                            clazz2 = class$0 = Class.forName("org.osgi.framework.ServiceReference");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    if (clazz.equals(clazz2)) {
                        methodParam = serviceReference;
                        break block62;
                    }
                }
                if ((methodParam = (Object)((ComponentInstanceImpl)instance).bindedServices.get(serviceReference)) == null) {
                    methodParam = InstanceProcess.staticRef.getService(reference, serviceReference);
                }
                if (methodParam != null) break block62;
                Hashtable hashtable2 = this.serviceReferences;
                synchronized (hashtable2) {
                    if (componentFactory) {
                        Vector instances = (Vector)this.serviceReferences.get(serviceReference);
                        instances.removeElement(instance);
                        if (instances.isEmpty()) {
                            this.serviceReferences.remove(serviceReference);
                        }
                        instances = (Vector)this.serviceReferencesToUnbind.get(serviceReference);
                        instances.removeElement(instance);
                        if (instances.isEmpty()) {
                            this.serviceReferencesToUnbind.remove(serviceReference);
                        }
                    } else {
                        this.serviceReferences.remove(serviceReference);
                        this.serviceReferencesToUnbind.remove(serviceReference);
                    }
                }
                return;
            }
            try {
                Object[] params = null;
                if (paramTypes.length == 1) {
                    params = SCRUtil.getObjectArray();
                    params[0] = methodParam;
                } else {
                    HashMap<String, Object> map = new HashMap<String, Object>();
                    String[] keys = serviceReference.getPropertyKeys();
                    int i = 0;
                    while (i < keys.length) {
                        map.put(keys[i], serviceReference.getProperty(keys[i]));
                        ++i;
                    }
                    params = new Object[]{methodParam, map};
                }
                try {
                    try {
                        this.unbindMethod.invoke(instance.getInstance(), params);
                    }
                    catch (Throwable t) {
                        this.logError(NLS.bind((String)Messages.EXCEPTION_UNBINDING_REFERENCE, (Object)this), t, reference);
                        if (params.length == 1) {
                            SCRUtil.release(params);
                        }
                        break block60;
                    }
                }
                catch (Throwable throwable) {
                    if (params.length == 1) {
                        SCRUtil.release(params);
                    }
                    throw throwable;
                }
                if (params.length == 1) {
                    SCRUtil.release(params);
                }
            }
            catch (Throwable throwable) {
                Hashtable hashtable = this.serviceReferences;
                synchronized (hashtable) {
                    if (componentFactory) {
                        Vector instances = (Vector)this.serviceReferences.get(serviceReference);
                        instances.removeElement(instance);
                        if (instances.isEmpty()) {
                            this.serviceReferences.remove(serviceReference);
                        }
                        instances = (Vector)this.serviceReferencesToUnbind.get(serviceReference);
                        instances.removeElement(instance);
                        if (instances.isEmpty()) {
                            this.serviceReferencesToUnbind.remove(serviceReference);
                        }
                    } else {
                        this.serviceReferences.remove(serviceReference);
                        this.serviceReferencesToUnbind.remove(serviceReference);
                    }
                }
                throw throwable;
            }
        }
        Hashtable hashtable = this.serviceReferences;
        synchronized (hashtable) {
            if (componentFactory) {
                Vector instances = (Vector)this.serviceReferences.get(serviceReference);
                instances.removeElement(instance);
                if (instances.isEmpty()) {
                    this.serviceReferences.remove(serviceReference);
                }
                instances = (Vector)this.serviceReferencesToUnbind.get(serviceReference);
                instances.removeElement(instance);
                if (instances.isEmpty()) {
                    this.serviceReferencesToUnbind.remove(serviceReference);
                }
            } else {
                this.serviceReferences.remove(serviceReference);
                this.serviceReferencesToUnbind.remove(serviceReference);
            }
        }
        if (((ComponentInstanceImpl)instance).bindedServices.remove(serviceReference) != null) {
            this.component.bc.ungetService(serviceReference);
        }
    }

    public final void dispose() {
        this.unbindCached = false;
        this.bindCached = false;
        this.unbindMethod = null;
        this.bindMethod = null;
        this.serviceReferences = null;
    }

    public final String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("Reference[");
        buffer.append("name = ").append(this.name);
        buffer.append(", interface = ").append(this.interfaceName);
        buffer.append(", policy = ");
        switch (this.policy) {
            case 1: {
                buffer.append("dynamic");
                break;
            }
            case 0: {
                buffer.append("static");
            }
        }
        buffer.append(", cardinality = ");
        switch (this.cardinality) {
            case 0: {
                buffer.append("0..1");
                break;
            }
            case 1: {
                buffer.append("0..n");
                break;
            }
            case 2: {
                buffer.append("1..1");
                break;
            }
            case 3: {
                buffer.append("1..n");
            }
        }
        buffer.append(", target = ").append(this.target);
        buffer.append(", bind = ").append(this.bind);
        buffer.append(", unbind = ").append(this.unbind);
        buffer.append("]");
        return buffer.toString();
    }

    public synchronized void writeObject(OutputStream o) throws Exception {
        try {
            DataOutputStream out = o instanceof DataOutputStream ? (DataOutputStream)o : new DataOutputStream(o);
            out.writeUTF(this.name);
            out.writeUTF(this.interfaceName);
            out.writeInt(this.cardinality);
            out.writeInt(this.policy);
            boolean flag = this.target != null;
            out.writeBoolean(flag);
            if (flag) {
                out.writeUTF(this.target);
            }
            flag = this.bind != null;
            out.writeBoolean(flag);
            if (flag) {
                out.writeUTF(this.bind);
            }
            flag = this.unbind != null;
            out.writeBoolean(flag);
            if (flag) {
                out.writeUTF(this.unbind);
            }
        }
        catch (Exception e) {
            Activator.log.error(Messages.ERROR_WRITING_OBJECT, (Throwable)e);
        }
    }

    public synchronized void readObject(InputStream s) throws Exception {
        try {
            DataInputStream in = s instanceof DataInputStream ? (DataInputStream)s : new DataInputStream(s);
            this.name = in.readUTF();
            this.interfaceName = in.readUTF();
            this.cardinality = in.readInt();
            this.policy = in.readInt();
            boolean flag = in.readBoolean();
            if (flag) {
                this.target = in.readUTF();
            }
            if (flag = in.readBoolean()) {
                this.bind = in.readUTF();
            }
            if (flag = in.readBoolean()) {
                this.unbind = in.readUTF();
            }
        }
        catch (Exception e) {
            Activator.log.error(Messages.ERROR_READING_OBJECT, (Throwable)e);
        }
    }
}

