/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.sse.ui;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.jface.text.DefaultInformationControl;
import org.eclipse.jface.text.IAutoEditStrategy;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentExtension3;
import org.eclipse.jface.text.IDocumentPartitioner;
import org.eclipse.jface.text.IInformationControl;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.ITextDoubleClickStrategy;
import org.eclipse.jface.text.ITextHover;
import org.eclipse.jface.text.IUndoManager;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.contentassist.IContentAssistant;
import org.eclipse.jface.text.formatter.IContentFormatter;
import org.eclipse.jface.text.hyperlink.IHyperlinkPresenter;
import org.eclipse.jface.text.hyperlink.MultipleHyperlinkPresenter;
import org.eclipse.jface.text.information.IInformationPresenter;
import org.eclipse.jface.text.information.IInformationProvider;
import org.eclipse.jface.text.information.InformationPresenter;
import org.eclipse.jface.text.presentation.IPresentationDamager;
import org.eclipse.jface.text.presentation.IPresentationReconciler;
import org.eclipse.jface.text.presentation.IPresentationRepairer;
import org.eclipse.jface.text.quickassist.IQuickAssistAssistant;
import org.eclipse.jface.text.quickassist.IQuickAssistProcessor;
import org.eclipse.jface.text.quickassist.QuickAssistAssistant;
import org.eclipse.jface.text.reconciler.IReconciler;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.IAnnotationHover;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.editors.text.EditorsUI;
import org.eclipse.ui.editors.text.TextSourceViewerConfiguration;
import org.eclipse.ui.texteditor.ChainedPreferenceStore;
import org.eclipse.wst.sse.core.internal.text.rules.StructuredTextPartitioner;
import org.eclipse.wst.sse.ui.StructuredTextMultiPassContentFormatter;
import org.eclipse.wst.sse.ui.StructuredTextViewerUndoManager;
import org.eclipse.wst.sse.ui.TextHoverInformationProvider;
import org.eclipse.wst.sse.ui.internal.ExtendedConfigurationBuilder;
import org.eclipse.wst.sse.ui.internal.SSEUIPlugin;
import org.eclipse.wst.sse.ui.internal.StructuredTextAnnotationHover;
import org.eclipse.wst.sse.ui.internal.contentassist.StructuredContentAssistant;
import org.eclipse.wst.sse.ui.internal.correction.CompoundQuickAssistProcessor;
import org.eclipse.wst.sse.ui.internal.derived.HTMLTextPresenter;
import org.eclipse.wst.sse.ui.internal.provisional.preferences.CommonEditorPreferenceNames;
import org.eclipse.wst.sse.ui.internal.provisional.style.LineStyleProvider;
import org.eclipse.wst.sse.ui.internal.provisional.style.ReconcilerHighlighter;
import org.eclipse.wst.sse.ui.internal.provisional.style.StructuredPresentationReconciler;
import org.eclipse.wst.sse.ui.internal.reconcile.StructuredRegionProcessor;
import org.eclipse.wst.sse.ui.internal.rules.StructuredDocumentDamagerRepairer;
import org.eclipse.wst.sse.ui.internal.taginfo.AnnotationHoverProcessor;
import org.eclipse.wst.sse.ui.internal.taginfo.BestMatchHover;
import org.eclipse.wst.sse.ui.internal.taginfo.ProblemAnnotationHoverProcessor;
import org.eclipse.wst.sse.ui.internal.taginfo.TextHoverManager;
import org.eclipse.wst.sse.ui.internal.util.EditorUtility;

public class StructuredTextViewerConfiguration
extends TextSourceViewerConfiguration {
    private StructuredContentAssistant fContentAssistant = null;
    private IQuickAssistAssistant fQuickAssistant = null;
    private IReconciler fReconciler;
    private final String AUTOEDITSTRATEGY = "autoeditstrategy";
    private ReconcilerHighlighter fHighlighter = null;

    public StructuredTextViewerConfiguration() {
        this.fPreferenceStore = this.createCombinedPreferenceStore();
    }

    private IPreferenceStore createCombinedPreferenceStore() {
        IPreferenceStore sseEditorPrefs = SSEUIPlugin.getDefault().getPreferenceStore();
        IPreferenceStore baseEditorPrefs = EditorsUI.getPreferenceStore();
        return new ChainedPreferenceStore(new IPreferenceStore[]{sseEditorPrefs, baseEditorPrefs});
    }

    public final IAnnotationHover getAnnotationHover(ISourceViewer sourceViewer) {
        return new StructuredTextAnnotationHover(){

            protected boolean isIncluded(Annotation annotation) {
                return StructuredTextViewerConfiguration.this.isShowInVerticalRuler(annotation);
            }
        };
    }

    private Color getColor(String key) {
        RGB rgb = PreferenceConverter.getColor((IPreferenceStore)this.fPreferenceStore, (String)key);
        return EditorUtility.getColor(rgb);
    }

    public IAutoEditStrategy[] getAutoEditStrategies(ISourceViewer sourceViewer, String contentType) {
        ArrayList<IAutoEditStrategy> allStrategies = new ArrayList<IAutoEditStrategy>(0);
        IAutoEditStrategy[] superStrategies = super.getAutoEditStrategies(sourceViewer, contentType);
        int i = 0;
        while (i < superStrategies.length) {
            allStrategies.add(superStrategies[i]);
            ++i;
        }
        List extendedAutoEdits = ExtendedConfigurationBuilder.getInstance().getConfigurations("autoeditstrategy", contentType);
        if (!extendedAutoEdits.isEmpty()) {
            allStrategies.addAll(extendedAutoEdits);
        }
        return allStrategies.toArray(new IAutoEditStrategy[allStrategies.size()]);
    }

    public final String getConfiguredDocumentPartitioning(ISourceViewer sourceViewer) {
        return "org.eclipse.wst.sse.core.default_structured_text_partitioning";
    }

    public int[] getConfiguredTextHoverStateMasks(ISourceViewer sourceViewer, String contentType) {
        TextHoverManager.TextHoverDescriptor[] hoverDescs = SSEUIPlugin.getDefault().getTextHoverManager().getTextHovers();
        int[] stateMasks = new int[hoverDescs.length];
        int stateMasksLength = 0;
        int i = 0;
        while (i < hoverDescs.length) {
            if (hoverDescs[i].isEnabled()) {
                int j = 0;
                int stateMask = StructuredTextViewerConfiguration.computeStateMask((String)hoverDescs[i].getModifierString());
                while (j < stateMasksLength) {
                    if (stateMasks[j] == stateMask) break;
                    ++j;
                }
                if (j == stateMasksLength) {
                    stateMasks[stateMasksLength++] = stateMask;
                }
            }
            ++i;
        }
        if (stateMasksLength == hoverDescs.length) {
            return stateMasks;
        }
        int[] shortenedStateMasks = new int[stateMasksLength];
        System.arraycopy(stateMasks, 0, shortenedStateMasks, 0, stateMasksLength);
        return shortenedStateMasks;
    }

    public IContentAssistant getContentAssistant(ISourceViewer sourceViewer) {
        if (this.fContentAssistant == null) {
            this.fContentAssistant = new StructuredContentAssistant();
            this.fContentAssistant.setDocumentPartitioning(this.getConfiguredDocumentPartitioning(sourceViewer));
            this.fContentAssistant.enableAutoActivation(true);
            this.fContentAssistant.setProposalPopupOrientation(10);
            this.fContentAssistant.setContextInformationPopupOrientation(20);
            this.fContentAssistant.setInformationControlCreator(this.getInformationControlCreator(sourceViewer));
            if (this.fPreferenceStore != null) {
                int delay = this.fPreferenceStore.getInt("content_assist_autoactivation_delay");
                this.fContentAssistant.setAutoActivationDelay(delay);
                Color color = this.getColor("content_assist_proposals_background");
                this.fContentAssistant.setProposalSelectorBackground(color);
                color = this.getColor("content_assist_proposals_foreground");
                this.fContentAssistant.setProposalSelectorForeground(color);
                color = this.getColor("content_assist_parameters_background");
                this.fContentAssistant.setContextInformationPopupBackground(color);
                this.fContentAssistant.setContextSelectorBackground(color);
                color = this.getColor("content_assist_parameters_foreground");
                this.fContentAssistant.setContextInformationPopupForeground(color);
                this.fContentAssistant.setContextSelectorForeground(color);
            }
        }
        if (!this.fContentAssistant.isInitialized()) {
            String[] types = this.getConfiguredContentTypes(sourceViewer);
            int i = 0;
            while (i < types.length) {
                String type = types[i];
                IContentAssistProcessor[] processors = this.getContentAssistProcessors(sourceViewer, type);
                if (processors != null) {
                    int j = 0;
                    while (j < processors.length) {
                        this.fContentAssistant.setContentAssistProcessor(processors[j], type);
                        ++j;
                    }
                }
                ++i;
            }
        }
        return this.fContentAssistant;
    }

    protected IContentAssistProcessor[] getContentAssistProcessors(ISourceViewer sourceViewer, String partitionType) {
        return null;
    }

    public IContentFormatter getContentFormatter(ISourceViewer sourceViewer) {
        String partitioning;
        IDocumentPartitioner partitioner;
        IDocument document;
        StructuredTextMultiPassContentFormatter formatter = null;
        if (sourceViewer != null && (document = sourceViewer.getDocument()) instanceof IDocumentExtension3 && (partitioner = ((IDocumentExtension3)document).getDocumentPartitioner(partitioning = this.getConfiguredDocumentPartitioning(sourceViewer))) instanceof StructuredTextPartitioner) {
            String defaultPartitionType = ((StructuredTextPartitioner)partitioner).getDefaultPartitionType();
            formatter = new StructuredTextMultiPassContentFormatter(partitioning, defaultPartitionType);
        }
        return formatter;
    }

    public ITextDoubleClickStrategy getDoubleClickStrategy(ISourceViewer sourceViewer, String contentType) {
        ITextDoubleClickStrategy strategy = null;
        Object extendedStrategy = ExtendedConfigurationBuilder.getInstance().getConfiguration("doubleClickStrategy", contentType);
        strategy = extendedStrategy instanceof ITextDoubleClickStrategy ? (ITextDoubleClickStrategy)extendedStrategy : super.getDoubleClickStrategy(sourceViewer, contentType);
        return strategy;
    }

    public final IHyperlinkPresenter getHyperlinkPresenter(ISourceViewer sourceViewer) {
        if (this.fPreferenceStore == null) {
            return super.getHyperlinkPresenter(sourceViewer);
        }
        return new MultipleHyperlinkPresenter(this.fPreferenceStore);
    }

    public final IInformationControlCreator getInformationControlCreator(ISourceViewer sourceViewer) {
        return new IInformationControlCreator(){

            public IInformationControl createInformationControl(Shell parent) {
                return new DefaultInformationControl(parent, (DefaultInformationControl.IInformationPresenter)new HTMLTextPresenter(true));
            }
        };
    }

    public final IInformationPresenter getInformationPresenter(ISourceViewer sourceViewer) {
        InformationPresenter presenter = new InformationPresenter(this.getInformationPresenterControlCreator(sourceViewer));
        presenter.setSizeConstraints(60, 10, true, true);
        presenter.setDocumentPartitioning(this.getConfiguredDocumentPartitioning(sourceViewer));
        String[] types = this.getConfiguredContentTypes(sourceViewer);
        int i = 0;
        while (i < types.length) {
            String type = types[i];
            IInformationProvider provider = this.getInformationProvider(sourceViewer, type);
            if (provider != null) {
                presenter.setInformationProvider(provider, type);
            }
            ++i;
        }
        return presenter;
    }

    protected IInformationProvider getInformationProvider(ISourceViewer sourceViewer, String partitionType) {
        BestMatchHover bestMatchHover = new BestMatchHover(this.createDocumentationHovers(partitionType));
        return new TextHoverInformationProvider(bestMatchHover);
    }

    private IInformationControlCreator getInformationPresenterControlCreator(ISourceViewer sourceViewer) {
        return new IInformationControlCreator(){

            public IInformationControl createInformationControl(Shell parent) {
                int shellStyle = 20;
                int style = 768;
                return new DefaultInformationControl(parent, shellStyle, style, (DefaultInformationControl.IInformationPresenter)new HTMLTextPresenter(false));
            }
        };
    }

    public LineStyleProvider[] getLineStyleProviders(ISourceViewer sourceViewer, String partitionType) {
        return null;
    }

    public IPresentationReconciler getPresentationReconciler(ISourceViewer sourceViewer) {
        StructuredPresentationReconciler reconciler = new StructuredPresentationReconciler();
        reconciler.setDocumentPartitioning(this.getConfiguredDocumentPartitioning(sourceViewer));
        String[] contentTypes = this.getConfiguredContentTypes(sourceViewer);
        if (contentTypes != null) {
            StructuredDocumentDamagerRepairer dr = null;
            int i = 0;
            while (i < contentTypes.length) {
                LineStyleProvider provider;
                if (this.fHighlighter != null && (provider = this.fHighlighter.getProvider(contentTypes[i])) != null) {
                    dr = new StructuredDocumentDamagerRepairer(provider);
                    dr.setDocument(sourceViewer.getDocument());
                    reconciler.setDamager((IPresentationDamager)dr, contentTypes[i]);
                    reconciler.setRepairer((IPresentationRepairer)dr, contentTypes[i]);
                }
                ++i;
            }
        }
        return reconciler;
    }

    public IAnnotationHover getOverviewRulerAnnotationHover(ISourceViewer sourceViewer) {
        return new StructuredTextAnnotationHover(true){

            protected boolean isIncluded(Annotation annotation) {
                return StructuredTextViewerConfiguration.this.isShowInOverviewRuler(annotation);
            }
        };
    }

    public IQuickAssistAssistant getQuickAssistAssistant(ISourceViewer sourceViewer) {
        if (this.fQuickAssistant == null) {
            QuickAssistAssistant assistant = new QuickAssistAssistant();
            assistant.setQuickAssistProcessor((IQuickAssistProcessor)new CompoundQuickAssistProcessor());
            assistant.setInformationControlCreator(this.getQuickAssistAssistantInformationControlCreator());
            if (this.fPreferenceStore != null) {
                Color color = this.getColor("content_assist_proposals_background");
                assistant.setProposalSelectorBackground(color);
                color = this.getColor("content_assist_proposals_foreground");
                assistant.setProposalSelectorForeground(color);
            }
            this.fQuickAssistant = assistant;
        }
        return this.fQuickAssistant;
    }

    private IInformationControlCreator getQuickAssistAssistantInformationControlCreator() {
        return new IInformationControlCreator(){

            public IInformationControl createInformationControl(Shell parent) {
                return new DefaultInformationControl(parent, 0, (DefaultInformationControl.IInformationPresenter)new HTMLTextPresenter(true));
            }
        };
    }

    public final IReconciler getReconciler(ISourceViewer sourceViewer) {
        boolean reconcilingEnabled = this.fPreferenceStore.getBoolean(CommonEditorPreferenceNames.EVALUATE_TEMPORARY_PROBLEMS);
        if (sourceViewer == null || !reconcilingEnabled) {
            return null;
        }
        if (this.fReconciler == null && sourceViewer != null) {
            StructuredRegionProcessor reconciler = new StructuredRegionProcessor();
            reconciler.setDocumentPartitioning(this.getConfiguredDocumentPartitioning(sourceViewer));
            this.fReconciler = reconciler;
        }
        return this.fReconciler;
    }

    public ILabelProvider getStatusLineLabelProvider(ISourceViewer sourceViewer) {
        return null;
    }

    private ITextHover[] createDocumentationHovers(String partitionType) {
        List extendedTextHover = ExtendedConfigurationBuilder.getInstance().getConfigurations("documentationTextHover", partitionType);
        ITextHover[] hovers = extendedTextHover.toArray(new ITextHover[extendedTextHover.size()]);
        return hovers;
    }

    public ITextHover getTextHover(ISourceViewer sourceViewer, String contentType, int stateMask) {
        Object textHover = null;
        TextHoverManager.TextHoverDescriptor[] hoverDescs = SSEUIPlugin.getDefault().getTextHoverManager().getTextHovers();
        int i = 0;
        while (i < hoverDescs.length && textHover == null) {
            if (hoverDescs[i].isEnabled() && StructuredTextViewerConfiguration.computeStateMask((String)hoverDescs[i].getModifierString()) == stateMask) {
                ITextHover[] hovers;
                String hoverType = hoverDescs[i].getId();
                if ("problemHover".equalsIgnoreCase(hoverType)) {
                    textHover = new ProblemAnnotationHoverProcessor();
                } else if ("annotationHover".equalsIgnoreCase(hoverType)) {
                    textHover = new AnnotationHoverProcessor();
                } else if ("combinationHover".equalsIgnoreCase(hoverType)) {
                    textHover = new BestMatchHover(this.createDocumentationHovers(contentType));
                } else if ("documentationHover".equalsIgnoreCase(hoverType) && (hovers = this.createDocumentationHovers(contentType)).length > 0) {
                    textHover = hovers[0];
                }
            }
            ++i;
        }
        return textHover;
    }

    public final IUndoManager getUndoManager(ISourceViewer sourceViewer) {
        return new StructuredTextViewerUndoManager();
    }

    public void setHighlighter(ReconcilerHighlighter highlighter) {
        this.fHighlighter = highlighter;
    }
}

