/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.sse.ui.internal.contentassist;

import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.ITextViewerExtension5;
import org.eclipse.jface.text.contentassist.CompletionProposal;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.ICompletionProposalExtension;
import org.eclipse.jface.text.contentassist.ICompletionProposalExtension2;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.wst.sse.ui.internal.contentassist.IRelevanceCompletionProposal;

public class CustomCompletionProposal
implements ICompletionProposal,
ICompletionProposalExtension,
ICompletionProposalExtension2,
IRelevanceCompletionProposal {
    private String fAdditionalProposalInfo;
    private IContextInformation fContextInformation;
    private int fCursorPosition = 0;
    private String fDisplayString;
    private Image fImage;
    private int fOriginalReplacementLength;
    private int fRelevance = 0;
    private int fReplacementLength = 0;
    private int fReplacementOffset = 0;
    private String fReplacementString = null;
    private boolean fUpdateLengthOnValidate;
    private char[] fTriggers;

    public CustomCompletionProposal(String replacementString, int replacementOffset, int replacementLength, int cursorPosition, Image image, String displayString, IContextInformation contextInformation, String additionalProposalInfo, int relevance, boolean updateReplacementLengthOnValidate) {
        this.fReplacementString = replacementString;
        this.fReplacementOffset = replacementOffset;
        this.fReplacementLength = replacementLength;
        this.fCursorPosition = cursorPosition;
        this.fImage = image;
        this.fDisplayString = displayString;
        this.fContextInformation = contextInformation;
        this.fAdditionalProposalInfo = additionalProposalInfo;
        this.fRelevance = relevance;
        this.fUpdateLengthOnValidate = updateReplacementLengthOnValidate;
        this.fOriginalReplacementLength = this.fReplacementLength;
    }

    public CustomCompletionProposal(String replacementString, int replacementOffset, int replacementLength, int cursorPosition, Image image, String displayString, IContextInformation contextInformation, String additionalProposalInfo, int relevance) {
        this(replacementString, replacementOffset, replacementLength, cursorPosition, image, displayString, contextInformation, additionalProposalInfo, relevance, true);
    }

    public void apply(IDocument document) {
        CompletionProposal proposal = new CompletionProposal(this.getReplacementString(), this.getReplacementOffset(), this.getReplacementLength(), this.getCursorPosition(), this.getImage(), this.getDisplayString(), this.getContextInformation(), this.getAdditionalProposalInfo());
        proposal.apply(document);
    }

    public void apply(IDocument document, char trigger, int offset) {
        CompletionProposal proposal = new CompletionProposal(this.getReplacementString(), this.getReplacementOffset(), this.getReplacementLength(), this.getCursorPosition(), this.getImage(), this.getDisplayString(), this.getContextInformation(), this.getAdditionalProposalInfo());
        proposal.apply(document);
    }

    public void apply(ITextViewer viewer, char trigger, int stateMask, int offset) {
        IDocument document = viewer.getDocument();
        int caretOffset = viewer.getTextWidget().getCaretOffset();
        if (viewer instanceof ITextViewerExtension5) {
            ITextViewerExtension5 extension = (ITextViewerExtension5)viewer;
            caretOffset = extension.widgetOffset2ModelOffset(caretOffset);
        } else {
            caretOffset = viewer.getTextWidget().getCaretOffset() + viewer.getVisibleRegion().getOffset();
        }
        if (caretOffset == this.getReplacementOffset()) {
            this.apply(document);
        } else {
            try {
                int endOffsetOfChanges = this.getReplacementString().length() + this.getReplacementOffset();
                if (endOffsetOfChanges >= caretOffset) {
                    int postCaretReplacementLength = this.getReplacementOffset() + this.getReplacementLength() - caretOffset;
                    int preCaretReplacementLength = this.getReplacementString().length() - (endOffsetOfChanges - caretOffset);
                    if (postCaretReplacementLength < 0) {
                        postCaretReplacementLength = 0;
                    }
                    document.replace(caretOffset, postCaretReplacementLength, this.getReplacementString().substring(preCaretReplacementLength));
                }
                if (caretOffset > this.getReplacementOffset()) {
                    int preCaretTextLength = caretOffset - this.getReplacementOffset();
                    document.replace(this.getReplacementOffset(), preCaretTextLength, this.getReplacementString().substring(0, preCaretTextLength));
                }
            }
            catch (BadLocationException badLocationException) {
                this.apply(document);
            }
            catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
                this.apply(document);
            }
        }
    }

    public String getAdditionalProposalInfo() {
        return this.fAdditionalProposalInfo;
    }

    public IContextInformation getContextInformation() {
        return this.fContextInformation;
    }

    public void setContextInformation(IContextInformation contextInfo) {
        this.fContextInformation = contextInfo;
    }

    public int getContextInformationPosition() {
        if (this.getContextInformation() == null) {
            return this.getReplacementOffset() - 1;
        }
        return this.getReplacementOffset() + this.getCursorPosition();
    }

    public int getCursorPosition() {
        return this.fCursorPosition;
    }

    public void setCursorPosition(int pos) {
        this.fCursorPosition = pos;
    }

    public void setDisplayString(String newDisplayString) {
        this.fDisplayString = newDisplayString;
    }

    public String getDisplayString() {
        return this.fDisplayString;
    }

    public Image getImage() {
        return this.fImage;
    }

    public int getRelevance() {
        return this.fRelevance;
    }

    public void setReplacementLength(int newReplacementLength) {
        this.fReplacementLength = newReplacementLength;
    }

    public int getReplacementLength() {
        return this.fReplacementLength;
    }

    public int getReplacementOffset() {
        return this.fReplacementOffset;
    }

    public String getReplacementString() {
        return this.fReplacementString;
    }

    public Point getSelection(IDocument document) {
        CompletionProposal proposal = new CompletionProposal(this.getReplacementString(), this.getReplacementOffset(), this.getReplacementLength(), this.getCursorPosition(), this.getImage(), this.getDisplayString(), this.getContextInformation(), this.getAdditionalProposalInfo());
        return proposal.getSelection(document);
    }

    public char[] getTriggerCharacters() {
        return this.fTriggers;
    }

    public void setTriggerCharacters(char[] triggers) {
        this.fTriggers = triggers;
    }

    public boolean isValidFor(IDocument document, int offset) {
        return this.validate(document, offset, null);
    }

    public void selected(ITextViewer viewer, boolean smartToggle) {
    }

    protected boolean startsWith(IDocument document, int offset, String word) {
        int wordLength;
        int n = wordLength = word == null ? 0 : word.length();
        if (offset > this.fReplacementOffset + wordLength) {
            return false;
        }
        try {
            int length = offset - this.fReplacementOffset;
            String start = document.get(this.fReplacementOffset, length);
            if (word != null) {
                return word.substring(0, length).equalsIgnoreCase(start);
            }
        }
        catch (BadLocationException badLocationException) {}
        return false;
    }

    public void unselected(ITextViewer viewer) {
    }

    public boolean validate(IDocument document, int offset, DocumentEvent event) {
        if (offset < this.fReplacementOffset) {
            return false;
        }
        boolean validated = this.startsWith(document, offset, this.fDisplayString);
        if (this.fUpdateLengthOnValidate) {
            int newLength = offset - this.getReplacementOffset();
            int delta = newLength - this.fOriginalReplacementLength;
            this.fReplacementLength = delta + this.fOriginalReplacementLength;
            try {
                char firstChar = document.getChar(this.getReplacementOffset());
                if (firstChar == '\"' || firstChar == '\'') {
                    ++this.fReplacementLength;
                }
            }
            catch (BadLocationException badLocationException) {}
        }
        return validated;
    }

    public void setReplacementOffset(int replacementOffset) {
        this.fReplacementOffset = replacementOffset;
    }

    public void setReplacementString(String replacementString) {
        this.fReplacementString = replacementString;
    }
}

