/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.minisat.constraints.cnf;

import java.io.Serializable;
import org.sat4j.minisat.constraints.cnf.Lits;
import org.sat4j.minisat.core.Constr;
import org.sat4j.minisat.core.ILits;
import org.sat4j.minisat.core.UnitPropagationListener;
import org.sat4j.specs.IVecInt;

public abstract class WLClause
implements Constr,
Serializable {
    private static final long serialVersionUID = 1L;
    protected double activity;
    protected final int[] lits;
    protected final ILits voc;
    static final /* synthetic */ boolean $assertionsDisabled;

    static {
        Class<?> clazz;
        try {
            clazz = Class.forName("org.sat4j.minisat.constraints.cnf.WLClause");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
    }

    public WLClause(IVecInt iVecInt, ILits iLits) {
        this.lits = new int[iVecInt.size()];
        iVecInt.moveTo(this.lits);
        if (!$assertionsDisabled && iVecInt.size() != 0) {
            throw new AssertionError();
        }
        this.voc = iLits;
        this.activity = 0.0;
    }

    public void calcReason(int n, IVecInt iVecInt) {
        int[] nArray = this.lits;
        int n2 = n == -1 ? 0 : 1;
        while (n2 < nArray.length) {
            if (!$assertionsDisabled && !this.voc.isFalsified(nArray[n2])) {
                throw new AssertionError();
            }
            iVecInt.push(nArray[n2] ^ 1);
            ++n2;
        }
    }

    public void remove(UnitPropagationListener unitPropagationListener) {
        this.voc.watches(this.lits[0] ^ 1).remove(this);
        this.voc.watches(this.lits[1] ^ 1).remove(this);
    }

    public boolean simplify() {
        int n = 0;
        while (n < this.lits.length) {
            if (this.voc.isSatisfied(this.lits[n])) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public boolean propagate(UnitPropagationListener unitPropagationListener, int n) {
        int[] nArray = this.lits;
        if (nArray[0] == (n ^ 1)) {
            nArray[0] = nArray[1];
            nArray[1] = n ^ 1;
        }
        int n2 = 2;
        while (n2 < nArray.length) {
            if (!this.voc.isFalsified(nArray[n2])) {
                nArray[1] = nArray[n2];
                nArray[n2] = n ^ 1;
                this.voc.watch(nArray[1] ^ 1, this);
                return true;
            }
            ++n2;
        }
        this.voc.watch(n, this);
        return unitPropagationListener.enqueue(nArray[0], this);
    }

    public boolean locked() {
        return this.voc.getReason(this.lits[0]) == this;
    }

    public double getActivity() {
        return this.activity;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < this.lits.length) {
            stringBuffer.append(Lits.toString(this.lits[n]));
            stringBuffer.append("[");
            stringBuffer.append(this.voc.valueToString(this.lits[n]));
            stringBuffer.append("]");
            stringBuffer.append(" ");
            ++n;
        }
        return stringBuffer.toString();
    }

    public int get(int n) {
        return this.lits[n];
    }

    public void rescaleBy(double d) {
        this.activity *= d;
    }

    public int size() {
        return this.lits.length;
    }

    public void assertConstraint(UnitPropagationListener unitPropagationListener) {
        boolean bl = unitPropagationListener.enqueue(this.lits[0], this);
        if (!$assertionsDisabled && !bl) {
            throw new AssertionError();
        }
    }

    public ILits getVocabulary() {
        return this.voc;
    }

    public int[] getLits() {
        int[] nArray = new int[this.size()];
        System.arraycopy(this.lits, 0, nArray, 0, this.size());
        return nArray;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        try {
            WLClause wLClause = (WLClause)object;
            if (this.lits.length != wLClause.lits.length) {
                return false;
            }
            int[] nArray = this.lits;
            int n = this.lits.length;
            int n2 = 0;
            while (true) {
                if (n2 >= n) {
                    return true;
                }
                int n3 = nArray[n2];
                boolean bl = false;
                int[] nArray2 = wLClause.lits;
                int n4 = wLClause.lits.length;
                int n5 = 0;
                while (n5 < n4) {
                    int n6 = nArray2[n5];
                    if (n3 == n6) {
                        bl = true;
                        break;
                    }
                    ++n5;
                }
                if (!bl) {
                    return false;
                }
                ++n2;
            }
        }
        catch (ClassCastException classCastException) {
            return false;
        }
    }

    public int hashCode() {
        long l = 0L;
        int[] nArray = this.lits;
        int n = this.lits.length;
        int n2 = 0;
        while (n2 < n) {
            int n3 = nArray[n2];
            l += (long)n3;
            ++n2;
        }
        return (int)l / this.lits.length;
    }
}

