/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.ui;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Text;
import org.eclipse.team.core.RepositoryProvider;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.internal.ccvs.core.CVSException;
import org.eclipse.team.internal.ccvs.core.CVSProviderPlugin;
import org.eclipse.team.internal.ccvs.core.CVSTag;
import org.eclipse.team.internal.ccvs.core.CVSTeamProvider;
import org.eclipse.team.internal.ccvs.core.ICVSFile;
import org.eclipse.team.internal.ccvs.core.ICVSFolder;
import org.eclipse.team.internal.ccvs.core.ICVSRepositoryLocation;
import org.eclipse.team.internal.ccvs.core.ICVSResourceVisitor;
import org.eclipse.team.internal.ccvs.core.IUserInfo;
import org.eclipse.team.internal.ccvs.core.resources.CVSEntryLineTag;
import org.eclipse.team.internal.ccvs.core.resources.CVSWorkspaceRoot;
import org.eclipse.team.internal.ccvs.core.syncinfo.FolderSyncInfo;
import org.eclipse.team.internal.ccvs.ui.CVSPropertiesPage;
import org.eclipse.team.internal.ccvs.ui.CVSUIMessages;
import org.eclipse.team.internal.ccvs.ui.CVSUIPlugin;
import org.eclipse.team.internal.ccvs.ui.Policy;
import org.eclipse.team.internal.ccvs.ui.repo.RepositoryComparator;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;

public class CVSProjectPropertiesPage
extends CVSPropertiesPage {
    IProject project;
    ICVSRepositoryLocation oldLocation;
    ICVSRepositoryLocation newLocation = null;
    private static final int TABLE_HEIGHT_HINT = 150;
    Text methodText;
    Text userText;
    Text hostText;
    Text pathText;
    Text moduleText;
    Text portText;
    Text tagText;
    private Button fetchButton;
    private Button watchEditButton;
    IUserInfo info;
    CVSTeamProvider provider;
    private boolean fetch;
    private boolean watchEdit;
    static /* synthetic */ Class class$0;

    public static boolean isCompatible(ICVSRepositoryLocation location, ICVSRepositoryLocation oldLocation) {
        if (!location.getHost().equals(oldLocation.getHost())) {
            return false;
        }
        if (!location.getRootDirectory().equals(oldLocation.getRootDirectory())) {
            return false;
        }
        return !location.equals(oldLocation);
    }

    protected Control createContents(Composite parent) {
        this.initialize();
        Composite composite = new Composite(parent, 0);
        composite.setLayoutData((Object)new GridData(1808));
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        composite.setLayout((Layout)layout);
        Label label = this.createLabel(composite, CVSUIMessages.CVSProjectPropertiesPage_connectionType, 1);
        this.methodText = this.createReadOnlyText(composite, "", 1);
        label = this.createLabel(composite, CVSUIMessages.CVSProjectPropertiesPage_user, 1);
        this.userText = this.createReadOnlyText(composite, "", 1);
        label = this.createLabel(composite, CVSUIMessages.CVSRepositoryLocationPropertySource_host, 1);
        this.hostText = this.createReadOnlyText(composite, "", 1);
        label = this.createLabel(composite, CVSUIMessages.CVSPropertiesPage_port, 1);
        this.portText = this.createReadOnlyText(composite, "", 1);
        label = this.createLabel(composite, CVSUIMessages.CVSRepositoryLocationPropertySource_root, 1);
        this.pathText = this.createReadOnlyText(composite, "", 1);
        label = this.createLabel(composite, CVSUIMessages.CVSPropertiesPage_module, 1);
        this.moduleText = this.createReadOnlyText(composite, "", 1);
        label = this.createLabel(composite, CVSUIMessages.CVSPropertiesPage_tag, 1);
        this.tagText = this.createReadOnlyText(composite, "", 1);
        this.createLabel(composite, "", 1);
        this.fetchButton = this.createCheckBox(composite, CVSUIMessages.CVSProjectPropertiesPage_fetchAbsentDirectoriesOnUpdate);
        this.fetchButton.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                CVSProjectPropertiesPage.this.fetch = CVSProjectPropertiesPage.this.fetchButton.getSelection();
            }
        });
        this.watchEditButton = this.createCheckBox(composite, CVSUIMessages.CVSProjectPropertiesPage_configureForWatchEdit);
        this.watchEditButton.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                CVSProjectPropertiesPage.this.watchEdit = CVSProjectPropertiesPage.this.watchEditButton.getSelection();
            }
        });
        this.createLabel(composite, "", 1);
        this.createLabel(composite, "", 1);
        this.createLabel(composite, "", 1);
        this.createLabel(composite, "", 1);
        label = new Label(composite, 64);
        label.setText(CVSUIMessages.CVSProjectPropertiesPage_You_can_change_the_sharing_of_this_project_to_another_repository_location__However__this_is_only_possible_if_the_new_location_is___compatible____on_the_same_host_with_the_same_repository_path___1);
        GridData data = new GridData(768);
        data.widthHint = 200;
        data.horizontalSpan = 2;
        label.setLayoutData((Object)data);
        Button changeButton = new Button(composite, 8);
        changeButton.setText(CVSUIMessages.CVSProjectPropertiesPage_Change_Sharing_5);
        changeButton.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                RepositorySelectionDialog dialog = new RepositorySelectionDialog(CVSProjectPropertiesPage.this.getShell(), CVSProjectPropertiesPage.this.oldLocation);
                dialog.open();
                ICVSRepositoryLocation location = dialog.getLocation();
                if (location == null) {
                    return;
                }
                CVSProjectPropertiesPage.this.newLocation = location;
                CVSProjectPropertiesPage.this.initializeValues(CVSProjectPropertiesPage.this.newLocation);
            }
        });
        this.initializeValues(this.oldLocation);
        PlatformUI.getWorkbench().getHelpSystem().setHelp(this.getControl(), "org.eclipse.team.cvs.ui.project_property_page_context");
        Dialog.applyDialogFont((Control)parent);
        return composite;
    }

    protected Label createLabel(Composite parent, String text, int span) {
        Label label = new Label(parent, 16384);
        label.setText(text);
        GridData data = new GridData();
        data.horizontalSpan = span;
        data.horizontalAlignment = 4;
        label.setLayoutData((Object)data);
        return label;
    }

    protected Text createReadOnlyText(Composite parent, String text, int span) {
        Text txt = new Text(parent, 16392);
        txt.setText(text);
        txt.setBackground(Display.getDefault().getSystemColor(22));
        GridData data = new GridData();
        data.horizontalSpan = span;
        data.horizontalAlignment = 4;
        txt.setLayoutData((Object)data);
        return txt;
    }

    protected Button createCheckBox(Composite group, String label) {
        Button button = new Button(group, 16416);
        button.setText(label);
        GridData data = new GridData();
        data.horizontalSpan = 2;
        button.setLayoutData((Object)data);
        return button;
    }

    private void initialize() {
        this.project = null;
        IAdaptable element = this.getElement();
        if (element instanceof IProject) {
            this.project = (IProject)element;
        } else {
            Object adapter;
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.core.resources.IProject");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((adapter = element.getAdapter((Class)clazz)) instanceof IProject) {
                this.project = (IProject)adapter;
            }
        }
        this.provider = (CVSTeamProvider)RepositoryProvider.getProvider((IProject)this.project, (String)CVSProviderPlugin.getTypeId());
        if (this.provider == null) {
            return;
        }
        CVSWorkspaceRoot cvsRoot = this.provider.getCVSWorkspaceRoot();
        try {
            this.oldLocation = cvsRoot.getRemoteLocation();
            this.fetch = this.provider.getFetchAbsentDirectories();
            this.watchEdit = this.provider.isWatchEditEnabled();
        }
        catch (TeamException e) {
            this.handle(e);
        }
    }

    private void initializeValues(ICVSRepositoryLocation location) {
        if (this.provider == null) {
            return;
        }
        CVSWorkspaceRoot cvsRoot = this.provider.getCVSWorkspaceRoot();
        ICVSFolder folder = cvsRoot.getLocalRoot();
        try {
            if (!folder.isCVSFolder()) {
                return;
            }
            this.methodText.setText(location.getMethod().getName());
            this.info = location.getUserInfo(true);
            this.userText.setText(this.info.getUsername());
            this.hostText.setText(location.getHost());
            int port = location.getPort();
            if (port == 0) {
                this.portText.setText(CVSUIMessages.CVSPropertiesPage_defaultPort);
            } else {
                this.portText.setText("" + port);
            }
            this.pathText.setText(location.getRootDirectory());
            FolderSyncInfo syncInfo = folder.getFolderSyncInfo();
            if (syncInfo == null) {
                return;
            }
            String label = syncInfo.getRepository();
            if (label.equals("CVSROOT/Emptydir")) {
                label = NLS.bind((String)CVSUIMessages.CVSPropertiesPage_virtualModule, (Object[])new String[]{label});
            }
            this.moduleText.setText(label);
            this.fetchButton.setSelection(this.fetch);
            this.watchEditButton.setSelection(this.watchEdit);
        }
        catch (TeamException e) {
            this.handle(e);
        }
        this.initializeTag();
    }

    private void initializeTag() {
        this.provider = (CVSTeamProvider)RepositoryProvider.getProvider((IProject)this.project, (String)CVSProviderPlugin.getTypeId());
        if (this.provider == null) {
            return;
        }
        try {
            ICVSFolder local = CVSWorkspaceRoot.getCVSFolderFor((IContainer)this.project);
            CVSEntryLineTag tag = local.getFolderSyncInfo().getTag();
            this.tagText.setText(CVSProjectPropertiesPage.getTagLabel((CVSTag)tag));
        }
        catch (TeamException e) {
            this.handle(e);
        }
    }

    public boolean performOk() {
        boolean[] changeReadOnly;
        block10: {
            changeReadOnly = new boolean[1];
            try {
                if (this.fetch != this.provider.getFetchAbsentDirectories()) {
                    this.provider.setFetchAbsentDirectories(this.fetch);
                }
                if (this.watchEdit != this.provider.isWatchEditEnabled()) {
                    this.provider.setWatchEditEnabled(this.watchEdit);
                    changeReadOnly[0] = true;
                }
            }
            catch (CVSException e) {
                this.handle(e);
            }
            if (this.newLocation == null && !changeReadOnly[0]) {
                return true;
            }
            if (this.newLocation == null || CVSProjectPropertiesPage.isCompatible(this.newLocation, this.oldLocation) || MessageDialog.openQuestion((Shell)this.getShell(), (String)CVSUIMessages.CVSProjectPropertiesPage_32, (String)CVSUIMessages.CVSProjectPropertiesPage_33)) break block10;
            return false;
        }
        try {
            new ProgressMonitorDialog(this.getShell()).run(true, true, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    try {
                        monitor.beginTask(CVSUIMessages.CVSProjectPropertiesPage_progressTaskName, (CVSProjectPropertiesPage.this.newLocation == null ? 0 : 100) + (changeReadOnly[0] ? 100 : 0));
                        if (CVSProjectPropertiesPage.this.newLocation != null) {
                            CVSProjectPropertiesPage.this.provider.setRemoteRoot(CVSProjectPropertiesPage.this.newLocation, Policy.subMonitorFor(monitor, 100));
                        }
                        if (changeReadOnly[0]) {
                            CVSProjectPropertiesPage.this.setReadOnly(CVSProjectPropertiesPage.this.watchEdit, Policy.infiniteSubMonitorFor(monitor, 100));
                        }
                    }
                    catch (TeamException e) {
                        throw new InvocationTargetException(e);
                    }
                }
            });
            this.newLocation = null;
            if (changeReadOnly[0]) {
                CVSUIPlugin.broadcastPropertyChange(new PropertyChangeEvent((Object)this, "org.eclipse.team.cvs.ui.P_DECORATORS_CHANGED", null, null));
            }
        }
        catch (InvocationTargetException e) {
            this.handle(e);
        }
        catch (InterruptedException interruptedException) {
            return false;
        }
        return true;
    }

    protected void setReadOnly(final boolean watchEdit, final IProgressMonitor monitor) throws CVSException {
        monitor.beginTask(null, 512);
        String taskName = watchEdit ? CVSUIMessages.CVSProjectPropertiesPage_setReadOnly : CVSUIMessages.CVSProjectPropertiesPage_clearReadOnly;
        monitor.subTask(taskName);
        ICVSFolder root = CVSWorkspaceRoot.getCVSFolderFor((IContainer)this.project);
        root.accept(new ICVSResourceVisitor(){

            public void visitFile(ICVSFile file) throws CVSException {
                if (file.isManaged() && !file.isModified(null)) {
                    file.setReadOnly(watchEdit);
                }
                monitor.worked(1);
            }

            public void visitFolder(ICVSFolder folder) throws CVSException {
                folder.acceptChildren((ICVSResourceVisitor)this);
            }
        });
        monitor.done();
    }

    protected void handle(Throwable t) {
        CVSUIPlugin.openError(this.getShell(), null, null, t);
    }

    private class RepositorySelectionDialog
    extends Dialog {
        ICVSRepositoryLocation[] allLocations;
        ICVSRepositoryLocation[] compatibleLocatons;
        ICVSRepositoryLocation selectedLocation;
        TableViewer viewer;
        Button okButton;
        boolean showCompatible = true;

        public RepositorySelectionDialog(Shell shell, ICVSRepositoryLocation oldLocation) {
            super(shell);
            this.initialize(oldLocation);
        }

        private void initialize(ICVSRepositoryLocation oldLocation) {
            this.allLocations = CVSUIPlugin.getPlugin().getRepositoryManager().getKnownRepositoryLocations();
            ArrayList<ICVSRepositoryLocation> locations = new ArrayList<ICVSRepositoryLocation>();
            int i = 0;
            while (i < this.allLocations.length) {
                ICVSRepositoryLocation location = this.allLocations[i];
                if (CVSProjectPropertiesPage.isCompatible(location, oldLocation)) {
                    locations.add(location);
                }
                ++i;
            }
            this.compatibleLocatons = locations.toArray(new ICVSRepositoryLocation[locations.size()]);
        }

        protected void createButtonsForButtonBar(Composite parent) {
            this.okButton = this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
            this.okButton.setEnabled(false);
            this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
        }

        protected Control createDialogArea(Composite parent) {
            parent.getShell().setText(CVSUIMessages.CVSProjectPropertiesPage_Select_a_Repository_1);
            Composite composite = (Composite)super.createDialogArea(parent);
            CVSProjectPropertiesPage.this.createLabel(composite, CVSUIMessages.CVSProjectPropertiesPage_Select_a_CVS_repository_location_to_share_the_project_with__2, 1);
            Table table = new Table(composite, 2820);
            GridData data = new GridData(768);
            data.heightHint = 150;
            table.setLayoutData((Object)data);
            this.viewer = new TableViewer(table);
            this.viewer.setLabelProvider((IBaseLabelProvider)new WorkbenchLabelProvider());
            this.viewer.setComparator((ViewerComparator)new RepositoryComparator());
            this.viewer.setContentProvider((IContentProvider)new WorkbenchContentProvider(this){
                final /* synthetic */ RepositorySelectionDialog this$1;
                {
                    this.this$1 = repositorySelectionDialog;
                }

                public Object[] getElements(Object inputElement) {
                    if (this.this$1.showCompatible) {
                        return this.this$1.compatibleLocatons;
                    }
                    return this.this$1.allLocations;
                }
            });
            this.viewer.addSelectionChangedListener(new ISelectionChangedListener(this){
                final /* synthetic */ RepositorySelectionDialog this$1;
                {
                    this.this$1 = repositorySelectionDialog;
                }

                public void selectionChanged(SelectionChangedEvent event) {
                    IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                    if (selection.isEmpty()) {
                        this.this$1.selectedLocation = null;
                        this.this$1.okButton.setEnabled(false);
                    } else {
                        this.this$1.selectedLocation = (ICVSRepositoryLocation)selection.getFirstElement();
                        this.this$1.okButton.setEnabled(true);
                    }
                }
            });
            this.viewer.addDoubleClickListener(new IDoubleClickListener(this){
                final /* synthetic */ RepositorySelectionDialog this$1;
                {
                    this.this$1 = repositorySelectionDialog;
                }

                public void doubleClick(DoubleClickEvent event) {
                    RepositorySelectionDialog.access$0(this.this$1);
                }
            });
            this.viewer.setInput((Object)this.compatibleLocatons);
            Button compatibleButton = CVSProjectPropertiesPage.this.createCheckBox(composite, CVSUIMessages.CVSProjectPropertiesPage_31);
            compatibleButton.setSelection(this.showCompatible);
            compatibleButton.addSelectionListener((SelectionListener)new SelectionAdapter(this, compatibleButton){
                final /* synthetic */ RepositorySelectionDialog this$1;
                private final /* synthetic */ Button val$compatibleButton;
                {
                    this.this$1 = repositorySelectionDialog;
                    this.val$compatibleButton = button;
                }

                public void widgetSelected(SelectionEvent e) {
                    this.this$1.showCompatible = this.val$compatibleButton.getSelection();
                    this.this$1.viewer.refresh();
                }
            });
            Dialog.applyDialogFont((Control)parent);
            return composite;
        }

        protected void cancelPressed() {
            this.selectedLocation = null;
            super.cancelPressed();
        }

        public ICVSRepositoryLocation getLocation() {
            return this.selectedLocation;
        }

        static /* synthetic */ void access$0(RepositorySelectionDialog repositorySelectionDialog) {
            repositorySelectionDialog.okPressed();
        }
    }
}

