/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.ui.tags;

import java.util.Arrays;
import java.util.HashSet;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.osgi.util.NLS;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.internal.ccvs.core.CVSTag;
import org.eclipse.team.internal.ccvs.core.ICVSFolder;
import org.eclipse.team.internal.ccvs.core.ICVSResource;
import org.eclipse.team.internal.ccvs.core.Policy;
import org.eclipse.team.internal.ccvs.ui.CVSUIMessages;
import org.eclipse.team.internal.ccvs.ui.CVSUIPlugin;
import org.eclipse.team.internal.ccvs.ui.tags.SingleFolderTagSource;

public class MultiFolderTagSource
extends SingleFolderTagSource {
    private final ICVSFolder[] folders;

    MultiFolderTagSource(ICVSFolder[] folders) {
        super(folders[0]);
        this.folders = folders;
    }

    public String getShortDescription() {
        return NLS.bind((String)CVSUIMessages.MultiFolderTagSource_0, (Object[])new String[]{Integer.toString(this.folders.length)});
    }

    public CVSTag[] getTags(int type) {
        if (type == 0 || type == -1) {
            return super.getTags(type);
        }
        HashSet<CVSTag> tags = new HashSet<CVSTag>();
        int i = 0;
        while (i < this.folders.length) {
            tags.addAll(Arrays.asList(MultiFolderTagSource.getTags(this.folders[i], type)));
            ++i;
        }
        return tags.toArray(new CVSTag[tags.size()]);
    }

    public CVSTag[] refresh(boolean bestEffort, IProgressMonitor monitor) throws TeamException {
        monitor.beginTask("", this.folders.length);
        HashSet<CVSTag> result = new HashSet<CVSTag>();
        int i = 0;
        while (i < this.folders.length) {
            ICVSFolder folder = this.folders[i];
            CVSTag[] tags = CVSUIPlugin.getPlugin().getRepositoryManager().refreshDefinedTags(folder, bestEffort, true, Policy.subMonitorFor((IProgressMonitor)monitor, (int)1));
            result.addAll(Arrays.asList(tags));
            ++i;
        }
        monitor.done();
        this.fireChange();
        return result.toArray(new CVSTag[result.size()]);
    }

    public ICVSResource[] getCVSResources() {
        return this.folders;
    }
}

