/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.demo.viewer;

import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.swt.graphics.Image;

public class ImageManagerHelper {
    public static final int IMAGE_WORKBENCH_WINDOW = 1;
    public static final int IMAGE_SASH = 2;
    public static final int IMAGE_STACK = 3;
    private static final String IMAGE_PATH = "platform:/plugin/org.eclipse.e4.demo.modifier/icons/obj16/";
    private ImageRegistry imageRegistry = new ImageRegistry();

    public Image getImage(String path) {
        URL url;
        if (path == null || path.length() == 0) {
            return null;
        }
        Image image = this.imageRegistry.get(path);
        if (image != null) {
            return image;
        }
        try {
            url = new URL(path);
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
            return null;
        }
        ImageDescriptor desc = ImageDescriptor.createFromURL((URL)url);
        image = desc.createImage();
        if (image != null) {
            this.imageRegistry.put(path, image);
        }
        return image;
    }

    public Image getImage(int id) {
        String registryID = Integer.toString(id);
        Image image = this.imageRegistry.get(registryID);
        if (image != null) {
            return image;
        }
        URL url = this.createURL(id);
        ImageDescriptor desc = ImageDescriptor.createFromURL((URL)url);
        image = desc.createImage();
        if (image != null) {
            this.imageRegistry.put(registryID, image);
        }
        return image;
    }

    private URL createURL(int id) {
        String result = null;
        switch (id) {
            case 1: {
                result = "platform:/plugin/org.eclipse.e4.demo.modifier/icons/obj16/prj_obj.gif";
                break;
            }
            case 2: {
                result = "platform:/plugin/org.eclipse.e4.demo.modifier/icons/obj16/fldr_obj.gif";
                break;
            }
            case 3: {
                result = "platform:/plugin/org.eclipse.e4.demo.modifier/icons/obj16/file_obj.gif";
            }
        }
        try {
            return new URL(result);
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
            return null;
        }
    }

    public void dispose() {
        this.imageRegistry.dispose();
    }
}

