/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.demo.viewer;

import java.util.Collections;
import java.util.List;
import org.eclipse.core.databinding.observable.IObservable;
import org.eclipse.core.databinding.observable.Observables;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.databinding.observable.list.ComputedList;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.core.databinding.observable.list.MultiList;
import org.eclipse.core.databinding.observable.list.WritableList;
import org.eclipse.core.databinding.observable.map.IObservableMap;
import org.eclipse.core.databinding.observable.masterdetail.IObservableFactory;
import org.eclipse.core.databinding.observable.set.IObservableSet;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.e4.core.services.context.IEclipseContext;
import org.eclipse.e4.demo.viewer.ImageManagerHelper;
import org.eclipse.e4.demo.viewer.ModelUtils;
import org.eclipse.e4.ui.model.application.ApplicationPackage;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.MContributedPart;
import org.eclipse.e4.ui.model.application.MHandledItem;
import org.eclipse.e4.ui.model.application.MItemContainer;
import org.eclipse.e4.ui.model.application.MPart;
import org.eclipse.e4.ui.model.application.MSashForm;
import org.eclipse.e4.ui.model.application.MStack;
import org.eclipse.e4.ui.model.workbench.MPerspective;
import org.eclipse.e4.ui.model.workbench.MWorkbenchWindow;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.databinding.EMFObservables;
import org.eclipse.emf.databinding.EMFProperties;
import org.eclipse.emf.databinding.IEMFValueProperty;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jface.databinding.viewers.ObservableListTreeContentProvider;
import org.eclipse.jface.databinding.viewers.ObservableMapLabelProvider;
import org.eclipse.jface.databinding.viewers.TreeStructureAdvisor;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.util.LocalSelectionTransfer;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Widget;

public class ModelExplorer {
    private IEclipseContext outputContext;
    private TreeViewer viewer;
    private ImageManagerHelper imageHelper;
    private DragSourceListener dragListener = new DragSourceListener(){

        public void dragFinished(DragSourceEvent event) {
        }

        public void dragSetData(DragSourceEvent event) {
        }

        public void dragStart(DragSourceEvent event) {
            IStructuredSelection selection = (IStructuredSelection)ModelExplorer.this.viewer.getSelection();
            event.doit = selection.size() != 1 ? false : selection.getFirstElement() instanceof MContributedPart;
        }
    };
    private DropTargetListener dropListener = new DropTargetListener(){

        public void dragEnter(DropTargetEvent event) {
        }

        public void dragOver(DropTargetEvent event) {
            event.feedback = 25;
            Widget curItem = event.item;
            if (curItem != null) {
                Object curElement = curItem.getData();
                event.detail = curElement instanceof MStack ? 2 : 0;
            }
        }

        public void dragOperationChanged(DropTargetEvent event) {
            if (LocalSelectionTransfer.getTransfer().isSupportedType(event.currentDataType) && event.detail != 1 && event.detail != 2) {
                event.detail = 0;
            }
        }

        public void drop(DropTargetEvent event) {
            if (LocalSelectionTransfer.getTransfer().isSupportedType(event.currentDataType)) {
                MStack sm = (MStack)event.item.getData();
                IStructuredSelection selection = (IStructuredSelection)ModelExplorer.this.viewer.getSelection();
                MContributedPart view = (MContributedPart)selection.getFirstElement();
                sm.getChildren().add((Object)view);
                ModelUtils.activate(view);
                ModelExplorer.this.viewer.refresh();
            }
        }

        public void dragLeave(DropTargetEvent event) {
        }

        public void dropAccept(DropTargetEvent event) {
        }
    };

    public ModelExplorer(Composite parent) {
        this.imageHelper = new ImageManagerHelper();
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        composite.setLayout((Layout)layout);
        GridData data = new GridData(1808);
        composite.setLayoutData((Object)data);
        Label label = new Label(composite, 0);
        label.setText("&E4 Model");
        GridData dataLabel = new GridData();
        dataLabel.horizontalIndent = 5;
        dataLabel.verticalIndent = 5;
        this.viewer = new TreeViewer(composite);
        this.viewer.getControl().setLayoutData((Object)new GridData(1808));
        final Realm realm = Realm.getDefault();
        IObservableFactory listFactory = new IObservableFactory(){

            public IObservable createObservable(Object element) {
                if (element instanceof EObject) {
                    EObject e = (EObject)element;
                    if (e instanceof MPart) {
                        IObservableList listChildren = EMFObservables.observeList((EObject)e, (EStructuralFeature)ApplicationPackage.Literals.MPART__CHILDREN);
                        final IObservableValue listMenu = EMFObservables.observeValue((EObject)e, (EStructuralFeature)ApplicationPackage.Literals.MPART__MENU);
                        ComputedList computedMenu = new ComputedList(){

                            protected List<?> calculate() {
                                Object value = listMenu.getValue();
                                return value == null ? Collections.EMPTY_LIST : Collections.singletonList(value);
                            }
                        };
                        final IObservableValue listToolbar = EMFObservables.observeValue((EObject)e, (EStructuralFeature)ApplicationPackage.Literals.MPART__TOOL_BAR);
                        ComputedList computedToolbar = new ComputedList(){

                            protected List<?> calculate() {
                                Object value = listToolbar.getValue();
                                return value == null ? Collections.EMPTY_LIST : Collections.singletonList(value);
                            }
                        };
                        IObservableList listHandler = EMFObservables.observeList((EObject)e, (EStructuralFeature)ApplicationPackage.Literals.MPART__HANDLERS);
                        return new MultiList(new IObservableList[]{listChildren, computedMenu, computedToolbar, listHandler});
                    }
                    if (e instanceof MHandledItem) {
                        final IObservableValue listCommands = EMFObservables.observeValue((EObject)e, (EStructuralFeature)ApplicationPackage.Literals.MHANDLED_ITEM__COMMAND);
                        ComputedList computedCommands = new ComputedList(){

                            protected List<?> calculate() {
                                Object value = listCommands.getValue();
                                return value == null ? Collections.EMPTY_LIST : Collections.singletonList(value);
                            }
                        };
                        final IObservableValue listMenus = EMFObservables.observeValue((EObject)e, (EStructuralFeature)ApplicationPackage.Literals.MHANDLED_ITEM__MENU);
                        ComputedList computedMenus = new ComputedList(){

                            protected List<?> calculate() {
                                Object value = listMenus.getValue();
                                return value == null ? Collections.EMPTY_LIST : Collections.singletonList(value);
                            }
                        };
                        return new MultiList(new IObservableList[]{computedCommands, computedMenus});
                    }
                    if (e instanceof MApplication) {
                        IObservableList listWindows = EMFObservables.observeList((EObject)e, (EStructuralFeature)ApplicationPackage.Literals.MAPPLICATION__WINDOWS);
                        IObservableList listCommands = EMFObservables.observeList((EObject)e, (EStructuralFeature)ApplicationPackage.Literals.MAPPLICATION__COMMAND);
                        return new MultiList(new IObservableList[]{listWindows, listCommands});
                    }
                    if (e instanceof MItemContainer) {
                        IObservableList listItems = EMFObservables.observeList((EObject)e, (EStructuralFeature)ApplicationPackage.Literals.MITEM_CONTAINER__ITEMS);
                        return listItems;
                    }
                } else if (element instanceof Object[]) {
                    EObject e = (EObject)((Object[])element)[0];
                    WritableList observableList = new WritableList(realm);
                    observableList.add((Object)e);
                    return observableList;
                }
                return Observables.emptyObservableList();
            }
        };
        ObservableListTreeContentProvider contentProvider = new ObservableListTreeContentProvider(listFactory, new TreeStructureAdvisor(){

            public Boolean hasChildren(Object element) {
                if (element instanceof EObject) {
                    return !((EObject)element).eContents().isEmpty();
                }
                return true;
            }
        });
        this.viewer.setContentProvider((IContentProvider)contentProvider);
        IEMFValueProperty propertyName = EMFProperties.value((EStructuralFeature)ApplicationPackage.Literals.MITEM__NAME);
        IEMFValueProperty propertyID = EMFProperties.value((EStructuralFeature)ApplicationPackage.Literals.MAPPLICATION_ELEMENT__ID);
        IObservableSet observableElements = contentProvider.getKnownElements();
        IObservableMap[] observables = new IObservableMap[]{propertyName.observeDetail(observableElements), propertyID.observeDetail(observableElements)};
        this.viewer.setLabelProvider((IBaseLabelProvider)new ViewLabelProvider(observables));
        this.viewer.getControl().setData("viewpart", (Object)this);
        this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ModelExplorer.this.handleSelection(event);
            }
        });
        int ops = 3;
        Transfer[] xFers = new Transfer[]{LocalSelectionTransfer.getTransfer()};
        this.viewer.addDragSupport(ops, xFers, this.dragListener);
        this.viewer.addDropSupport(ops, xFers, this.dropListener);
        MPart<?> element = ModelUtils.getElement(parent);
        EObject topObject = ModelUtils.topObject(element);
        this.viewer.setInput((Object)topObject);
        this.viewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                TreeSelection selection = (TreeSelection)event.getSelection();
                MPart selected = (MPart)selection.getFirstElement();
                ModelUtils.activate(selected);
            }
        });
        GridLayoutFactory.fillDefaults().generateLayout(parent);
    }

    protected void handleSelection(SelectionChangedEvent event) {
        IStructuredSelection sel;
        Object selObj;
        if (event.getSelection() instanceof IStructuredSelection && (selObj = (sel = (IStructuredSelection)event.getSelection()).getFirstElement()) instanceof EObject) {
            this.outputContext.set("selection", selObj);
        }
    }

    public String[] getPropIds(EObject selObj) {
        if (selObj == null) {
            return new String[0];
        }
        EList features = selObj.eClass().getEAllStructuralFeatures();
        String[] ids = new String[features.size()];
        int count = 0;
        for (EStructuralFeature structuralFeature : features) {
            String featureName = structuralFeature.getName();
            ids[count++] = featureName;
        }
        return ids;
    }

    public Object getProperty(EObject eObj, String id) {
        if (eObj == null) {
            return null;
        }
        EStructuralFeature eFeature = eObj.eClass().getEStructuralFeature(id);
        if (eFeature == null) {
            return null;
        }
        return eObj.eGet(eFeature);
    }

    public void dispose() {
    }

    public void contextSet(IEclipseContext context) {
        Object parent = context.get("parentContext");
        this.outputContext = parent instanceof IEclipseContext ? (IEclipseContext)parent : context;
    }

    class ViewLabelProvider
    extends ObservableMapLabelProvider {
        public ViewLabelProvider(IObservableMap[] attributeMaps) {
            super(attributeMaps);
        }

        public Image getImage(Object element) {
            if (element instanceof MContributedPart) {
                String iconPath = ((MContributedPart)element).getIconURI();
                return ModelExplorer.this.imageHelper.getImage(iconPath);
            }
            if (element instanceof MWorkbenchWindow) {
                return ModelExplorer.this.imageHelper.getImage(1);
            }
            if (element instanceof MStack) {
                return ModelExplorer.this.imageHelper.getImage(3);
            }
            if (element instanceof MPerspective || element instanceof MSashForm) {
                return ModelExplorer.this.imageHelper.getImage(2);
            }
            return null;
        }

        public String getText(Object element) {
            if (element instanceof MContributedPart) {
                return ((MContributedPart)element).getName();
            }
            if (element instanceof MStack) {
                return "Stack: \"" + ((MStack)element).getId() + "\"";
            }
            if (element instanceof MSashForm) {
                return "Sash: \"" + ((MSashForm)element).getId() + "\"";
            }
            if (element instanceof MPerspective) {
                return "Perspective \"" + ((MPerspective)element).getId() + "\"";
            }
            if (element instanceof MWorkbenchWindow) {
                return "Workbench Window";
            }
            return element.getClass().getSimpleName();
        }
    }
}

