/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.workbench.ui.renderers;

import org.eclipse.e4.core.services.IContributionFactory;
import org.eclipse.e4.core.services.context.IEclipseContext;
import org.eclipse.e4.ui.model.application.MApplicationElement;
import org.eclipse.e4.ui.model.application.MMenu;
import org.eclipse.e4.ui.model.application.MPart;
import org.eclipse.e4.ui.model.application.MToolBar;
import org.eclipse.e4.workbench.ui.renderers.PartRenderingEngine;
import org.eclipse.emf.databinding.EMFDataBindingContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractPartRenderer {
    public static final String OWNING_ME = "modelElement";
    protected PartRenderingEngine renderer;
    protected IContributionFactory contributionFactory;
    protected IEclipseContext context;
    protected EMFDataBindingContext dbc = new EMFDataBindingContext();

    public void init(PartRenderingEngine renderer, IEclipseContext context, IContributionFactory contributionFactory) {
        this.renderer = renderer;
        this.contributionFactory = contributionFactory;
        this.context = context;
    }

    public abstract Object createWidget(MPart<?> var1, Object var2);

    public abstract <P extends MPart<?>> void processContents(MPart<P> var1);

    public void postProcess(MPart<?> childME) {
    }

    public abstract void bindWidget(MPart<?> var1, Object var2);

    protected abstract Object getParentWidget(MPart<?> var1);

    public abstract void disposeWidget(MPart<?> var1);

    public abstract void hookControllerLogic(MPart<?> var1);

    public abstract void childAdded(MPart<?> var1, MPart<?> var2);

    public void childRemoved(MPart<?> parentElement, MPart<?> child) {
    }

    protected abstract Object getImage(MApplicationElement var1);

    public Object createMenu(MPart<?> part, Object widgetObject, MMenu menu) {
        return null;
    }

    public Object createToolBar(MPart<?> part, Object widgetObject, MToolBar toolBar) {
        return null;
    }

    protected IEclipseContext getContextForParent(MPart<?> part) {
        MPart parent = part.getParent();
        while (parent != null) {
            if (parent.getContext() != null) {
                return parent.getContext();
            }
            parent = parent.getParent();
        }
        return this.context;
    }

    protected IEclipseContext getContext(MPart<?> part) {
        if (part.getContext() != null) {
            return part.getContext();
        }
        return this.getContextForParent(part);
    }

    protected IEclipseContext getToplevelContext(MPart<?> part) {
        IEclipseContext result = null;
        if (part.getParent() != null) {
            result = this.getToplevelContext(part.getParent());
        }
        if (result == null) {
            result = part.getContext();
        }
        return result;
    }

    public void activate(MPart<?> part) {
        MPart parent = part.getParent();
        IEclipseContext partContext = part.getContext();
        while (parent != null) {
            IEclipseContext parentContext = parent.getContext();
            if (parentContext != null) {
                parentContext.set("activeChild", (Object)partContext);
                partContext = parentContext;
            }
            if (parent.getActiveChild() != part) {
                parent.setActiveChild(part);
            }
            part = parent;
            parent = parent.getParent();
        }
    }

    public void removeGui(MPart element, Object widget) {
    }
}

