/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.editors.text;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.filebuffers.FileBuffers;
import org.eclipse.core.filebuffers.IFileBufferManager;
import org.eclipse.core.filebuffers.manipulation.FileBufferOperationRunner;
import org.eclipse.core.filebuffers.manipulation.IFileBufferOperation;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.editors.text.ILocationProvider;
import org.eclipse.ui.editors.text.TextEditorMessages;

public class FileBufferOperationHandler
extends AbstractHandler {
    private IFileBufferOperation fFileBufferOperation;
    private IWorkbenchWindow fWindow;
    private IResource[] fResources;
    private IPath fLocation;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public FileBufferOperationHandler(IFileBufferOperation fileBufferOperation) {
        this.fFileBufferOperation = fileBufferOperation;
    }

    public void initialize(IResource[] resources, IPath location) {
        if (resources != null) {
            this.fResources = new IResource[resources.length];
            System.arraycopy(resources, 0, this.fResources, 0, resources.length);
        } else {
            this.fResources = null;
        }
        this.fLocation = location;
    }

    protected final void computeSelectedResources() {
        IWorkbenchPart workbenchPart;
        IWorkbenchWindow window;
        if (this.fResources != null || this.fLocation != null) {
            return;
        }
        ISelection selection = this.getSelection();
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection structuredSelection = (IStructuredSelection)selection;
            ArrayList<Object> resources = new ArrayList<Object>(structuredSelection.size());
            Iterator e = structuredSelection.iterator();
            while (e.hasNext()) {
                Object adapter;
                Object element = e.next();
                if (element instanceof IResource) {
                    resources.add(element);
                    continue;
                }
                if (!(element instanceof IAdaptable)) continue;
                IAdaptable adaptable = (IAdaptable)element;
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = Class.forName("org.eclipse.core.resources.IResource");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if (!((adapter = adaptable.getAdapter((Class)clazz)) instanceof IResource)) continue;
                resources.add(adapter);
            }
            if (!resources.isEmpty()) {
                this.fResources = resources.toArray(new IResource[resources.size()]);
            }
        } else if (selection instanceof ITextSelection && (window = this.getWorkbenchWindow()) != null && (workbenchPart = window.getPartService().getActivePart()) instanceof IEditorPart) {
            Object adapter;
            IEditorPart editorPart = (IEditorPart)workbenchPart;
            IEditorInput input = editorPart.getEditorInput();
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.core.resources.IResource");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((adapter = input.getAdapter((Class)clazz)) instanceof IResource) {
                this.fResources = new IResource[]{(IResource)adapter};
            } else {
                Class<?> clazz2 = class$1;
                if (clazz2 == null) {
                    try {
                        clazz2 = class$1 = Class.forName("org.eclipse.ui.editors.text.ILocationProvider");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if ((adapter = input.getAdapter((Class)clazz2)) instanceof ILocationProvider) {
                    ILocationProvider provider = (ILocationProvider)adapter;
                    this.fLocation = provider.getPath(input);
                }
            }
        }
    }

    protected final ISelection getSelection() {
        IWorkbenchWindow window = this.getWorkbenchWindow();
        if (window != null) {
            return window.getSelectionService().getSelection();
        }
        return null;
    }

    protected final IWorkbenchWindow getWorkbenchWindow() {
        if (this.fWindow == null) {
            this.fWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        }
        return this.fWindow;
    }

    protected IFile[] collectFiles(IResource[] resources) {
        HashSet<IResource> files = new HashSet<IResource>();
        int i = 0;
        while (i < resources.length) {
            IResource resource = resources[i];
            if ((1 & resource.getType()) > 0) {
                files.add(resource);
            }
            ++i;
        }
        return files.toArray(new IFile[files.size()]);
    }

    protected final void doRun(final IFile[] files, final IPath location, final IFileBufferOperation fileBufferOperation) {
        Job job = new Job(fileBufferOperation.getOperationName()){

            protected IStatus run(IProgressMonitor monitor) {
                Status status;
                try {
                    int ticks = 100;
                    monitor.beginTask(FileBufferOperationHandler.this.fFileBufferOperation.getOperationName(), ticks);
                    try {
                        IPath[] locations;
                        if (files != null) {
                            ticks -= 30;
                            locations = FileBufferOperationHandler.this.generateLocations(files, (IProgressMonitor)new SubProgressMonitor(monitor, 30));
                        } else {
                            locations = new IPath[]{location};
                        }
                        if (locations != null && locations.length > 0) {
                            FileBufferOperationRunner runner = new FileBufferOperationRunner((IFileBufferManager)FileBuffers.getTextFileBufferManager(), (Object)FileBufferOperationHandler.this.getShell());
                            runner.execute(locations, fileBufferOperation, (IProgressMonitor)new SubProgressMonitor(monitor, ticks));
                        }
                        status = new Status(0, "org.eclipse.ui.editors", 0, "", null);
                    }
                    finally {
                        monitor.done();
                    }
                }
                catch (OperationCanceledException operationCanceledException) {
                    status = new Status(8, "org.eclipse.ui.editors", 0, "", null);
                }
                catch (CoreException e) {
                    status = new Status(4, "org.eclipse.ui.editors", 0, "", (Throwable)e);
                }
                return status;
            }
        };
        job.setUser(true);
        job.schedule();
    }

    protected final Shell getShell() {
        IWorkbenchWindow window = this.getWorkbenchWindow();
        return window == null ? null : window.getShell();
    }

    protected final IPath[] generateLocations(IFile[] files, IProgressMonitor progressMonitor) {
        progressMonitor.beginTask(TextEditorMessages.FileBufferOperationHandler_collectionFiles_label, files.length);
        try {
            HashSet<IPath> locations = new HashSet<IPath>();
            int i = 0;
            while (i < files.length) {
                IPath fullPath = files[i].getFullPath();
                if (this.isAcceptableLocation(fullPath)) {
                    locations.add(fullPath);
                }
                progressMonitor.worked(1);
                ++i;
            }
            IPath[] iPathArray = locations.toArray(new IPath[locations.size()]);
            return iPathArray;
        }
        finally {
            progressMonitor.done();
        }
    }

    protected boolean isAcceptableLocation(IPath location) {
        return true;
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        this.computeSelectedResources();
        try {
            if (this.fResources != null && this.fResources.length > 0) {
                IFile[] files = this.collectFiles(this.fResources);
                if (files != null && files.length > 0) {
                    this.doRun(files, null, this.fFileBufferOperation);
                }
            } else if (this.isAcceptableLocation(this.fLocation)) {
                this.doRun(null, this.fLocation, this.fFileBufferOperation);
            }
            return null;
        }
        finally {
            this.fResources = null;
            this.fLocation = null;
        }
    }
}

