/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.net;

import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.core.internal.net.ProxySelector;
import org.eclipse.core.internal.net.StringUtil;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.jface.fieldassist.FieldDecorationRegistry;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnPixelData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.ui.internal.net.NetUIMessages;
import org.eclipse.ui.internal.net.NonProxyHostsContentProvider;
import org.eclipse.ui.internal.net.NonProxyHostsLabelProvider;
import org.eclipse.ui.internal.net.ProxyBypassData;

public class NonProxyHostsComposite
extends Composite {
    private Label hostsLabel;
    CheckboxTableViewer hostsViewer;
    private Button addButton;
    private Button editButton;
    private Button removeButton;
    protected String currentProvider;
    private ArrayList bypassHosts = new ArrayList();

    NonProxyHostsComposite(Composite parent, int style) {
        super(parent, style);
        this.createWidgets();
    }

    protected void createWidgets() {
        this.setLayout((Layout)new GridLayout(2, false));
        this.hostsLabel = new Label((Composite)this, 0);
        this.hostsLabel.setText(NetUIMessages.ProxyPreferencePage_12);
        this.hostsLabel.setLayoutData((Object)new GridData(16384, 128, false, false, 2, 1));
        Table hostsTable = new Table((Composite)this, 68386);
        hostsTable.setHeaderVisible(true);
        hostsTable.setLinesVisible(true);
        hostsTable.setLayoutData((Object)new GridData(4, 4, true, true, 1, 3));
        this.hostsViewer = new CheckboxTableViewer(hostsTable);
        NonProxyHostsLabelProvider labelProvider = new NonProxyHostsLabelProvider();
        NonProxyHostsContentProvider contentProvider = new NonProxyHostsContentProvider();
        labelProvider.createColumns((TableViewer)this.hostsViewer);
        this.hostsViewer.setContentProvider((IContentProvider)contentProvider);
        this.hostsViewer.setLabelProvider((IBaseLabelProvider)labelProvider);
        TableLayout tableLayout = new TableLayout();
        tableLayout.addColumnData((ColumnLayoutData)new ColumnPixelData(24));
        tableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(50, 50, true));
        tableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(50, 50, true));
        hostsTable.setLayout((Layout)tableLayout);
        this.addButton = this.createButton(NetUIMessages.ProxyPreferencePage_15);
        this.editButton = this.createButton(NetUIMessages.ProxyPreferencePage_16);
        this.removeButton = this.createButton(NetUIMessages.ProxyPreferencePage_17);
        this.hostsViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                NonProxyHostsComposite.this.enableButtons();
            }
        });
        this.hostsViewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                NonProxyHostsComposite.this.setProvider(NonProxyHostsComposite.this.currentProvider);
            }
        });
        this.hostsViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                NonProxyHostsComposite.this.editSelection();
            }
        });
        this.addButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                NonProxyHostsComposite.this.addHost();
            }
        });
        this.editButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                NonProxyHostsComposite.this.editSelection();
            }
        });
        this.removeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                NonProxyHostsComposite.this.removeSelection();
            }
        });
        this.initializeValues();
        this.enableButtons();
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.hostsViewer.getTable().setEnabled(enabled);
        this.enableButtons();
    }

    protected void enableButtons() {
        boolean enabled = this.getEnabled();
        if (enabled) {
            IStructuredSelection selection = (IStructuredSelection)this.hostsViewer.getSelection();
            Iterator iterator = selection.iterator();
            boolean editable = iterator.hasNext();
            while (iterator.hasNext()) {
                String provider = ((ProxyBypassData)iterator.next()).getSource();
                if (ProxySelector.canSetBypassHosts((String)provider)) continue;
                editable = false;
            }
            this.addButton.setEnabled(true);
            this.editButton.setEnabled(editable);
            this.removeButton.setEnabled(editable);
        } else {
            this.addButton.setEnabled(false);
            this.editButton.setEnabled(false);
            this.removeButton.setEnabled(false);
        }
    }

    protected void addHost() {
        String[] hosts = this.promptForHost(null);
        if (hosts != null) {
            int i = 0;
            while (i < hosts.length) {
                this.bypassHosts.add(0, new ProxyBypassData(hosts[i], this.getEditableProvider()));
                ++i;
            }
            this.hostsViewer.refresh();
            this.setProvider(this.currentProvider);
        }
    }

    private String getEditableProvider() {
        String[] providers = ProxySelector.getProviders();
        int i = 0;
        while (i < providers.length) {
            if (ProxySelector.canSetBypassHosts((String)providers[i])) {
                return providers[i];
            }
            ++i;
        }
        return null;
    }

    protected void removeSelection() {
        IStructuredSelection selection = (IStructuredSelection)this.hostsViewer.getSelection();
        Iterator it = selection.iterator();
        while (it.hasNext()) {
            ProxyBypassData data = (ProxyBypassData)it.next();
            this.bypassHosts.remove(data);
        }
        this.hostsViewer.refresh();
    }

    protected void editSelection() {
        IStructuredSelection selection = (IStructuredSelection)this.hostsViewer.getSelection();
        String selectedHosts = this.getStringList(selection.iterator());
        String[] hosts = this.promptForHost(selectedHosts);
        if (hosts != null) {
            Iterator it = selection.iterator();
            while (it.hasNext()) {
                ProxyBypassData data = (ProxyBypassData)it.next();
                this.bypassHosts.remove(data);
            }
            int i = 0;
            while (i < hosts.length) {
                this.bypassHosts.add(0, new ProxyBypassData(hosts[i], this.getEditableProvider()));
                ++i;
            }
            this.hostsViewer.refresh();
        }
    }

    String getStringList(Iterator iterator) {
        ProxyBypassData data;
        StringBuffer buffer = new StringBuffer();
        if (iterator.hasNext()) {
            data = (ProxyBypassData)iterator.next();
            buffer.append(data.getHost());
        }
        while (iterator.hasNext()) {
            buffer.append(';');
            data = (ProxyBypassData)iterator.next();
            buffer.append(data.getHost());
        }
        return buffer.toString();
    }

    private String[] promptForHost(String selectedHosts) {
        InputDialog dialog = new InputDialog(this.getShell(), NetUIMessages.ProxyBypassDialog_0, NetUIMessages.ProxyBypassDialog_1, selectedHosts, null){
            private ControlDecoration decorator;

            protected Control createDialogArea(Composite parent) {
                Control createDialogArea = super.createDialogArea(parent);
                this.decorator = new ControlDecoration((Control)this.getText(), 16512);
                this.decorator.setDescriptionText(NetUIMessages.ProxyBypassDialog_2);
                this.decorator.setImage(FieldDecorationRegistry.getDefault().getFieldDecoration("DEC_INFORMATION").getImage());
                return createDialogArea;
            }

            public boolean close() {
                this.decorator.dispose();
                return super.close();
            }
        };
        int result = dialog.open();
        if (result != 1) {
            String value = dialog.getValue();
            String[] hosts = StringUtil.split((String)value, (String[])new String[]{";", "|"});
            ArrayList<String> filtered = new ArrayList<String>();
            int i = 0;
            while (i < hosts.length) {
                if (hosts[i].length() != 0) {
                    filtered.add(hosts[i]);
                }
                ++i;
            }
            return filtered.toArray(new String[0]);
        }
        return null;
    }

    private Button createButton(String message) {
        Button button = new Button((Composite)this, 8);
        button.setText(message);
        button.setLayoutData((Object)new GridData(4, 128, false, false));
        return button;
    }

    public void initializeValues() {
        String[] providers = ProxySelector.getProviders();
        int i = 0;
        while (i < providers.length) {
            String[] hosts = ProxySelector.getBypassHosts((String)providers[i]);
            int j = 0;
            while (hosts != null && j < hosts.length) {
                ProxyBypassData data = new ProxyBypassData(hosts[j], providers[i]);
                this.bypassHosts.add(data);
                ++j;
            }
            ++i;
        }
        this.hostsViewer.setInput((Object)this.bypassHosts);
        this.setProvider(ProxySelector.getDefaultProvider());
    }

    public void setProvider(String item) {
        if (item == null) {
            item = this.currentProvider;
        } else {
            this.currentProvider = item;
        }
        ArrayList<ProxyBypassData> selected = new ArrayList<ProxyBypassData>();
        Iterator it = this.bypassHosts.iterator();
        while (it.hasNext()) {
            ProxyBypassData data = (ProxyBypassData)it.next();
            if (!data.getSource().equalsIgnoreCase(item)) continue;
            selected.add(data);
        }
        this.hostsViewer.setCheckedElements((Object[])selected.toArray(new ProxyBypassData[0]));
    }

    public void performApply() {
        String[] data;
        String provider = this.getEditableProvider();
        Iterator it = this.bypassHosts.iterator();
        ArrayList<String> hosts = new ArrayList<String>();
        while (it.hasNext()) {
            data = (String[])it.next();
            if (!data.getSource().equals(provider)) continue;
            hosts.add(data.getHost());
        }
        data = hosts.toArray(new String[0]);
        ProxySelector.setBypassHosts((String)provider, (String[])data);
    }
}

