/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.publisher.actions;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.equinox.internal.p2.core.helpers.FileUtils;
import org.eclipse.equinox.internal.p2.metadata.ArtifactKey;
import org.eclipse.equinox.internal.provisional.p2.artifact.repository.IArtifactDescriptor;
import org.eclipse.equinox.internal.provisional.p2.core.Version;
import org.eclipse.equinox.internal.provisional.p2.core.VersionRange;
import org.eclipse.equinox.internal.provisional.p2.metadata.IArtifactKey;
import org.eclipse.equinox.internal.provisional.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.internal.provisional.p2.metadata.IProvidedCapability;
import org.eclipse.equinox.internal.provisional.p2.metadata.IRequiredCapability;
import org.eclipse.equinox.internal.provisional.p2.metadata.MetadataFactory;
import org.eclipse.equinox.p2.publisher.AbstractPublisherAction;
import org.eclipse.equinox.p2.publisher.IPublisherInfo;
import org.eclipse.equinox.p2.publisher.IPublisherResult;
import org.eclipse.equinox.p2.publisher.PublisherResult;
import org.eclipse.equinox.p2.publisher.actions.IRootFilesAdvice;
import org.eclipse.equinox.p2.publisher.actions.RootFilesAdvice;
import org.eclipse.equinox.spi.p2.publisher.PublisherHelper;

public class RootFilesAction
extends AbstractPublisherAction {
    private String idBase;
    private Version version;
    private String flavor;
    static /* synthetic */ Class class$0;

    public static String computeIUId(String id, String flavor) {
        return String.valueOf(flavor) + id + ".rootfiles";
    }

    public RootFilesAction(IPublisherInfo info, String idBase, Version version, String flavor) {
        this.idBase = idBase == null ? "org.eclipse" : idBase;
        this.version = version;
        this.flavor = flavor;
    }

    public IStatus perform(IPublisherInfo info, IPublisherResult results, IProgressMonitor monitor) {
        PublisherResult innerResult = new PublisherResult();
        String[] configSpecs = info.getConfigurations();
        int i = 0;
        while (i < configSpecs.length) {
            if (monitor.isCanceled()) {
                return Status.CANCEL_STATUS;
            }
            this.generateRootFileIUs(configSpecs[i], info, innerResult);
            ++i;
        }
        results.merge(innerResult, 2);
        this.publishTopLevelRootFilesIU(innerResult.getIUs((String)null, "root"), results);
        if (monitor.isCanceled()) {
            return Status.CANCEL_STATUS;
        }
        return Status.OK_STATUS;
    }

    private void publishTopLevelRootFilesIU(Collection children, IPublisherResult result) {
        MetadataFactory.InstallableUnitDescription descriptor = this.createParentIU(children, RootFilesAction.computeIUId(this.idBase, this.flavor), this.version);
        descriptor.setSingleton(true);
        IInstallableUnit rootIU = MetadataFactory.createInstallableUnit((MetadataFactory.InstallableUnitDescription)descriptor);
        if (rootIU == null) {
            return;
        }
        result.addIU(rootIU, "root");
    }

    private void generateRootFileIUs(String configSpec, IPublisherInfo info, IPublisherResult result) {
        MetadataFactory.InstallableUnitDescription iu = new MetadataFactory.InstallableUnitDescription();
        iu.setSingleton(true);
        String idPrefix = String.valueOf(this.idBase) + ".rootfiles";
        String iuId = String.valueOf(idPrefix) + '.' + this.createIdString(configSpec);
        iu.setId(iuId);
        iu.setVersion(this.version);
        String filter = this.createFilterSpec(configSpec);
        iu.setFilter(filter);
        ArtifactKey key = PublisherHelper.createBinaryArtifactKey(iuId, this.version);
        iu.setArtifacts(new IArtifactKey[]{key});
        iu.setTouchpointType(PublisherHelper.TOUCHPOINT_NATIVE);
        IProvidedCapability launcherCapability = MetadataFactory.createProvidedCapability((String)(String.valueOf(this.flavor) + this.idBase), (String)idPrefix, (Version)this.version);
        iu.setCapabilities(new IProvidedCapability[]{PublisherHelper.createSelfCapability(iuId, this.version), launcherCapability});
        result.addIU(MetadataFactory.createInstallableUnit((MetadataFactory.InstallableUnitDescription)iu), "root");
        MetadataFactory.InstallableUnitFragmentDescription cu = new MetadataFactory.InstallableUnitFragmentDescription();
        String configUnitId = String.valueOf(this.flavor) + iuId;
        cu.setId(configUnitId);
        cu.setVersion(this.version);
        cu.setFilter(filter);
        cu.setHost(new IRequiredCapability[]{MetadataFactory.createRequiredCapability((String)"org.eclipse.equinox.p2.iu", (String)iuId, (VersionRange)new VersionRange(this.version, true, this.version, true), null, (boolean)false, (boolean)false)});
        cu.setProperty("org.eclipse.equinox.p2.type.fragment", Boolean.TRUE.toString());
        cu.setCapabilities(new IProvidedCapability[]{PublisherHelper.createSelfCapability(configUnitId, this.version)});
        cu.setTouchpointType(PublisherHelper.TOUCHPOINT_NATIVE);
        HashMap<String, String> touchpointData = new HashMap<String, String>();
        String configurationData = "unzip(source:@artifact, target:${installFolder});";
        touchpointData.put("install", configurationData);
        String unConfigurationData = "cleanupzip(source:@artifact, target:${installFolder});";
        touchpointData.put("uninstall", unConfigurationData);
        cu.addTouchpointData(MetadataFactory.createTouchpointData(touchpointData));
        IInstallableUnit unit = MetadataFactory.createInstallableUnit((MetadataFactory.InstallableUnitDescription)cu);
        result.addIU(unit, "root");
        if ((info.getArtifactOptions() & 3) > 0) {
            IArtifactDescriptor descriptor = PublisherHelper.createArtifactDescriptor((IArtifactKey)key, null);
            IRootFilesAdvice advice = this.getAdvice(configSpec, info);
            this.publishArtifact(descriptor, advice.getIncludedFiles(), advice.getExcludedFiles(), info, this.createPrefixComputer(advice.getRoot()));
        }
    }

    private FileUtils.IPathComputer createPrefixComputer(File root) {
        if (root == null) {
            return this.createParentPrefixComputer(1);
        }
        return this.createRootPrefixComputer(root);
    }

    private IRootFilesAdvice getAdvice(String configSpec, IPublisherInfo info) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.equinox.p2.publisher.actions.IRootFilesAdvice");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Collection advice = info.getAdvice(configSpec, true, null, null, clazz);
        ArrayList<File> inclusions = new ArrayList<File>();
        ArrayList<File> exclusions = new ArrayList<File>();
        File root = null;
        Iterator i = advice.iterator();
        while (i.hasNext()) {
            File[] list;
            IRootFilesAdvice entry = (IRootFilesAdvice)i.next();
            if (root == null) {
                root = entry.getRoot();
            }
            if ((list = entry.getIncludedFiles()) != null) {
                inclusions.addAll(Arrays.asList(list));
            }
            if ((list = entry.getExcludedFiles()) == null) continue;
            exclusions.addAll(Arrays.asList(list));
        }
        File[] includeList = inclusions.toArray(new File[inclusions.size()]);
        File[] excludeList = exclusions.toArray(new File[exclusions.size()]);
        return new RootFilesAdvice(root, includeList, excludeList, configSpec);
    }
}

