/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.publisher.eclipse;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.zip.ZipFile;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.equinox.internal.p2.core.helpers.LogHelper;
import org.eclipse.equinox.internal.p2.publisher.Activator;
import org.eclipse.equinox.internal.provisional.p2.artifact.repository.IArtifactDescriptor;
import org.eclipse.equinox.internal.provisional.p2.core.Version;
import org.eclipse.equinox.internal.provisional.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.internal.provisional.p2.metadata.IProvidedCapability;
import org.eclipse.equinox.internal.provisional.p2.metadata.IRequiredCapability;
import org.eclipse.equinox.internal.provisional.p2.metadata.ITouchpointData;
import org.eclipse.equinox.internal.provisional.p2.metadata.ITouchpointInstruction;
import org.eclipse.equinox.internal.provisional.p2.metadata.MetadataFactory;
import org.eclipse.equinox.p2.publisher.AbstractAdvice;
import org.eclipse.equinox.p2.publisher.actions.IAdditionalInstallableUnitAdvice;
import org.eclipse.equinox.p2.publisher.actions.ICapabilityAdvice;
import org.eclipse.equinox.p2.publisher.actions.IPropertyAdvice;
import org.eclipse.equinox.p2.publisher.actions.ITouchpointAdvice;
import org.eclipse.equinox.p2.publisher.eclipse.AdviceFileParser;

public class AdviceFileAdvice
extends AbstractAdvice
implements ITouchpointAdvice,
ICapabilityAdvice,
IPropertyAdvice,
IAdditionalInstallableUnitAdvice {
    public static final IPath BUNDLE_ADVICE_FILE = new Path("META-INF/p2.inf");
    private final String id;
    private final Version version;
    private Map touchpointInstructions;
    private IProvidedCapability[] providedCapabilities;
    private IRequiredCapability[] requiredCapabilities;
    private IRequiredCapability[] metaRequiredCapabilities;
    private Properties iuProperties;
    private MetadataFactory.InstallableUnitDescription[] additionalIUs;
    private boolean containsAdvice = false;

    public AdviceFileAdvice(String id, Version version, IPath basePath, IPath adviceFilePath) {
        Assert.isNotNull((Object)id);
        Assert.isNotNull((Object)version);
        Assert.isNotNull((Object)basePath);
        Assert.isNotNull((Object)adviceFilePath);
        this.id = id;
        this.version = version;
        Map advice = AdviceFileAdvice.loadAdviceMap(basePath, adviceFilePath);
        if (advice.isEmpty()) {
            return;
        }
        AdviceFileParser parser = new AdviceFileParser(id, version, advice);
        try {
            parser.parse();
        }
        catch (Exception e) {
            String message = "An error occured while parsing advice file: basePath=" + basePath + ", adviceFilePath=" + adviceFilePath + ".";
            Status status = new Status(4, Activator.ID, message, (Throwable)e);
            LogHelper.log((IStatus)status);
            return;
        }
        this.touchpointInstructions = parser.getTouchpointInstructions();
        this.providedCapabilities = parser.getProvidedCapabilities();
        this.requiredCapabilities = parser.getRequiredCapabilities();
        this.metaRequiredCapabilities = parser.getMetaRequiredCapabilities();
        this.iuProperties = parser.getProperties();
        this.additionalIUs = parser.getAdditionalInstallableUnitDescriptions();
        this.containsAdvice = true;
    }

    public boolean containsAdvice() {
        return this.containsAdvice;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private static Map loadAdviceMap(IPath basePath, IPath adviceFilePath) {
        block37: {
            block35: {
                block36: {
                    block33: {
                        block34: {
                            location = basePath.toFile();
                            if (location == null || !location.exists()) {
                                return Collections.EMPTY_MAP;
                            }
                            jar = null;
                            stream = null;
                            if (!location.isDirectory()) ** GOTO lbl27
                            adviceFile = new File(location, adviceFilePath.toString());
                            if (adviceFile.isFile()) break block33;
                            var9_7 = Collections.EMPTY_MAP;
                            if (stream == null) break block34;
                            try {
                                stream.close();
                            }
                            catch (IOException v0) {}
                        }
                        if (jar != null) {
                            try {
                                jar.close();
                            }
                            catch (IOException v1) {}
                        }
                        return var9_7;
                    }
                    stream = new BufferedInputStream(new FileInputStream(adviceFile));
                    ** GOTO lbl47
lbl27:
                    // 1 sources

                    if (!location.isFile()) ** GOTO lbl47
                    jar = new ZipFile(location);
                    entry = jar.getEntry(adviceFilePath.toString());
                    if (entry != null) break block35;
                    var9_8 = Collections.EMPTY_MAP;
                    if (stream == null) break block36;
                    try {
                        stream.close();
                    }
                    catch (IOException v2) {}
                }
                if (jar != null) {
                    try {
                        jar.close();
                    }
                    catch (IOException v3) {}
                }
                return var9_8;
            }
            stream = new BufferedInputStream(jar.getInputStream(entry));
lbl47:
            // 3 sources

            advice = new Properties();
            advice.load(stream);
            v4 /* !! */  = var9_9 /* !! */  = advice != null ? advice : Collections.EMPTY_MAP;
            if (stream == null) break block37;
            try {
                stream.close();
            }
            catch (IOException v5) {}
        }
        if (jar != null) {
            try {
                jar.close();
            }
            catch (IOException v6) {}
        }
        return var9_9 /* !! */ ;
        catch (IOException e) {
            block38: {
                try {
                    message = "An error occured while reading advice file: basePath=" + basePath + ", adviceFilePath=" + adviceFilePath + ".";
                    status = new Status(4, Activator.ID, message, (Throwable)e);
                    LogHelper.log((IStatus)status);
                    var9_10 = Collections.EMPTY_MAP;
                    if (stream == null) break block38;
                }
                catch (Throwable var8_13) {
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (IOException v7) {}
                    }
                    if (jar != null) {
                        try {
                            jar.close();
                        }
                        catch (IOException v8) {}
                    }
                    throw var8_13;
                }
                try {
                    stream.close();
                }
                catch (IOException v9) {}
            }
            if (jar != null) {
                try {
                    jar.close();
                }
                catch (IOException v10) {}
            }
            return var9_10;
        }
    }

    public boolean isApplicable(String configSpec, boolean includeDefault, String candidateId, Version candidateVersion) {
        return this.id.equals(candidateId) && this.version.equals((Object)candidateVersion);
    }

    public ITouchpointData getTouchpointData(ITouchpointData existing) {
        if (this.touchpointInstructions == null) {
            return existing;
        }
        HashMap<String, ITouchpointInstruction> resultInstructions = new HashMap<String, ITouchpointInstruction>(existing.getInstructions());
        Iterator iterator = this.touchpointInstructions.keySet().iterator();
        while (iterator.hasNext()) {
            String key = (String)iterator.next();
            ITouchpointInstruction instruction = (ITouchpointInstruction)this.touchpointInstructions.get(key);
            ITouchpointInstruction existingInstruction = (ITouchpointInstruction)resultInstructions.get(key);
            if (existingInstruction != null) {
                String body = existingInstruction.getBody();
                if (body == null || body.length() == 0) {
                    body = instruction.getBody();
                } else if (instruction.getBody() != null) {
                    if (!body.endsWith(";")) {
                        body = String.valueOf(body) + ';';
                    }
                    body = String.valueOf(body) + instruction.getBody();
                }
                String importAttribute = existingInstruction.getImportAttribute();
                if (importAttribute == null || importAttribute.length() == 0) {
                    importAttribute = instruction.getImportAttribute();
                } else if (instruction.getImportAttribute() != null) {
                    if (!importAttribute.endsWith(",")) {
                        importAttribute = String.valueOf(importAttribute) + ',';
                    }
                    importAttribute = String.valueOf(importAttribute) + instruction.getBody();
                }
                instruction = MetadataFactory.createTouchpointInstruction((String)body, (String)importAttribute);
            }
            resultInstructions.put(key, instruction);
        }
        return MetadataFactory.createTouchpointData(resultInstructions);
    }

    public IProvidedCapability[] getProvidedCapabilities(MetadataFactory.InstallableUnitDescription iu) {
        return this.providedCapabilities;
    }

    public IRequiredCapability[] getRequiredCapabilities(MetadataFactory.InstallableUnitDescription iu) {
        return this.requiredCapabilities;
    }

    public IRequiredCapability[] getMetaRequiredCapabilities(MetadataFactory.InstallableUnitDescription iu) {
        return this.metaRequiredCapabilities;
    }

    public MetadataFactory.InstallableUnitDescription[] getAdditionalInstallableUnitDescriptions(IInstallableUnit iu) {
        return this.additionalIUs;
    }

    public Properties getArtifactProperties(IInstallableUnit iu, IArtifactDescriptor descriptor) {
        return null;
    }

    public Properties getInstallableUnitProperties(MetadataFactory.InstallableUnitDescription iu) {
        return this.iuProperties;
    }
}

