/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.css.swt.helpers;

import org.eclipse.e4.ui.css.core.css2.CSS2FontHelper;
import org.eclipse.e4.ui.css.core.css2.CSS2FontPropertiesHelpers;
import org.eclipse.e4.ui.css.core.css2.CSS2PrimitiveValueImpl;
import org.eclipse.e4.ui.css.core.dom.properties.css2.CSS2FontProperties;
import org.eclipse.e4.ui.css.core.dom.properties.css2.CSS2FontPropertiesImpl;
import org.eclipse.e4.ui.css.core.engine.CSSElementContext;
import org.eclipse.e4.ui.widgets.ETabItem;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Widget;
import org.w3c.dom.css.CSSPrimitiveValue;

public class CSSSWTFontHelper {
    public static CSS2FontProperties getCSS2FontProperties(Widget widget, Font font, CSSElementContext context) {
        CSS2FontProperties fontProperties = CSS2FontPropertiesHelpers.getCSS2FontProperties((CSSElementContext)context);
        if (fontProperties == null) {
            fontProperties = CSSSWTFontHelper.getCSS2FontProperties(font);
            CSS2FontPropertiesHelpers.setCSS2FontProperties((CSS2FontProperties)fontProperties, (CSSElementContext)context);
        }
        return fontProperties;
    }

    public static CSS2FontProperties getCSS2FontProperties(Widget widget, CSSElementContext context) {
        return CSSSWTFontHelper.getCSS2FontProperties(CSSSWTFontHelper.getFont(widget), context);
    }

    public static CSS2FontProperties getCSS2FontProperties(Font font, CSSElementContext context) {
        CSS2FontProperties fontProperties = CSS2FontPropertiesHelpers.getCSS2FontProperties((CSSElementContext)context);
        if (fontProperties == null && font != null) {
            fontProperties = CSSSWTFontHelper.getCSS2FontProperties(font);
            CSS2FontPropertiesHelpers.setCSS2FontProperties((CSS2FontProperties)fontProperties, (CSSElementContext)context);
        }
        return fontProperties;
    }

    public static CSS2FontProperties getCSS2FontProperties(Font font) {
        CSS2FontPropertiesImpl fontProperties = new CSS2FontPropertiesImpl();
        if (font != null) {
            FontData fontData = CSSSWTFontHelper.getFirstFontData(font);
            String fontFamily = CSSSWTFontHelper.getFontFamily(font);
            fontProperties.setFamily((CSSPrimitiveValue)new CSS2PrimitiveValueImpl(fontFamily));
            int fontSize = fontData.getHeight();
            fontProperties.setSize((CSSPrimitiveValue)new CSS2PrimitiveValueImpl(fontSize));
            String fontWeight = CSSSWTFontHelper.getFontWeight(font);
            fontProperties.setWeight((CSSPrimitiveValue)new CSS2PrimitiveValueImpl(fontWeight));
            String fontStyle = CSSSWTFontHelper.getFontStyle(font);
            fontProperties.setStyle((CSSPrimitiveValue)new CSS2PrimitiveValueImpl(fontStyle));
        }
        return fontProperties;
    }

    public static Font getFont(CSS2FontProperties fontProperties, Control control) {
        FontData oldFontData = CSSSWTFontHelper.getFirstFontData(control.getFont());
        return CSSSWTFontHelper.getFont(fontProperties, oldFontData, control.getDisplay());
    }

    public static Font getFont(CSS2FontProperties fontProperties, FontData oldFontData, Display display) {
        FontData newFontData = CSSSWTFontHelper.getFontData(fontProperties, oldFontData);
        return new Font((Device)display, newFontData);
    }

    public static FontData getFontData(CSS2FontProperties fontProperties, FontData oldFontData) {
        FontData newFontData = new FontData();
        int style = CSSSWTFontHelper.getSWTStyle(fontProperties, oldFontData);
        newFontData.setStyle(style);
        CSSPrimitiveValue cssFontSize = fontProperties.getSize();
        if (cssFontSize != null) {
            newFontData.setHeight((int)cssFontSize.getFloatValue((short)9));
        } else if (oldFontData != null) {
            newFontData.setHeight(oldFontData.getHeight());
        }
        CSSPrimitiveValue cssFontFamily = fontProperties.getFamily();
        if (cssFontFamily != null) {
            newFontData.setName(cssFontFamily.getStringValue());
        } else if (oldFontData != null) {
            newFontData.setName(oldFontData.getName());
        }
        return newFontData;
    }

    public static int getSWTStyle(CSS2FontProperties fontProperties, FontData fontData) {
        CSSPrimitiveValue cssFontWeight;
        if (fontData == null) {
            return 0;
        }
        int fontStyle = fontData.getStyle();
        CSSPrimitiveValue cssFontStyle = fontProperties.getStyle();
        if (cssFontStyle != null) {
            String style = cssFontStyle.getStringValue();
            if ("italic".equals(style)) {
                fontStyle |= 2;
            } else if (fontStyle == (fontStyle | 2)) {
                fontStyle ^= 2;
            }
        }
        if ((cssFontWeight = fontProperties.getWeight()) != null) {
            String weight = cssFontWeight.getStringValue();
            if ("bold".equals(weight.toLowerCase())) {
                fontStyle |= 1;
            } else if (fontStyle == (fontStyle | 1)) {
                fontStyle ^= 1;
            }
        }
        return fontStyle;
    }

    public static String getFontFamily(Widget widget) {
        return CSSSWTFontHelper.getFontFamily(CSSSWTFontHelper.getFont(widget));
    }

    public static String getFontFamily(Font font) {
        FontData fontData = CSSSWTFontHelper.getFirstFontData(font);
        return CSSSWTFontHelper.getFontFamily(fontData);
    }

    public static String getFontFamily(FontData fontData) {
        if (fontData != null) {
            String family = fontData.getName();
            return CSS2FontHelper.getFontFamily((String)family);
        }
        return null;
    }

    public static String getFontSize(Widget widget) {
        return CSSSWTFontHelper.getFontSize(CSSSWTFontHelper.getFont(widget));
    }

    public static String getFontSize(Font font) {
        FontData fontData = CSSSWTFontHelper.getFirstFontData(font);
        return CSSSWTFontHelper.getFontSize(fontData);
    }

    public static String getFontSize(FontData fontData) {
        if (fontData != null) {
            return CSS2FontHelper.getFontSize((int)fontData.getHeight());
        }
        return null;
    }

    public static String getFontStyle(Widget widget) {
        return CSSSWTFontHelper.getFontStyle(CSSSWTFontHelper.getFont(widget));
    }

    public static String getFontStyle(Font font) {
        FontData fontData = CSSSWTFontHelper.getFirstFontData(font);
        return CSSSWTFontHelper.getFontStyle(fontData);
    }

    public static String getFontStyle(FontData fontData) {
        boolean isItalic = false;
        if (fontData != null) {
            isItalic = CSSSWTFontHelper.isItalic(fontData);
        }
        return CSS2FontHelper.getFontStyle((boolean)isItalic);
    }

    public static boolean isItalic(FontData fontData) {
        int fontStyle = fontData.getStyle();
        return (fontStyle | 2) == fontStyle;
    }

    public static String getFontWeight(Widget widget) {
        return CSSSWTFontHelper.getFontWeight(CSSSWTFontHelper.getFont(widget));
    }

    public static String getFontWeight(Font font) {
        FontData fontData = CSSSWTFontHelper.getFirstFontData(font);
        return CSSSWTFontHelper.getFontWeight(fontData);
    }

    public static String getFontWeight(FontData fontData) {
        boolean isBold = false;
        if (fontData != null) {
            isBold = CSSSWTFontHelper.isBold(fontData);
        }
        return CSS2FontHelper.getFontWeight((boolean)isBold);
    }

    public static boolean isBold(FontData fontData) {
        int fontStyle = fontData.getStyle();
        return (fontStyle | 1) == fontStyle;
    }

    public static String getFontComposite(Control control) {
        return CSSSWTFontHelper.getFontComposite(control.getFont());
    }

    public static String getFontComposite(Font font) {
        FontData fontData = CSSSWTFontHelper.getFirstFontData(font);
        return CSSSWTFontHelper.getFontComposite(fontData);
    }

    public static String getFontComposite(FontData fontData) {
        if (fontData != null) {
            StringBuffer composite = new StringBuffer();
            composite.append(CSSSWTFontHelper.getFontFamily(fontData));
            composite.append(" ");
            composite.append(CSSSWTFontHelper.getFontSize(fontData));
            composite.append(" ");
            composite.append(CSSSWTFontHelper.getFontWeight(fontData));
            composite.append(" ");
            composite.append(CSSSWTFontHelper.getFontStyle(fontData));
            return composite.toString();
        }
        return null;
    }

    public static FontData getFirstFontData(Control control) {
        Font font = control.getFont();
        if (font == null) {
            return null;
        }
        return CSSSWTFontHelper.getFirstFontData(font);
    }

    public static FontData getFirstFontData(Font font) {
        FontData[] fontDatas = font.getFontData();
        if (fontDatas == null || fontDatas.length < 1) {
            return null;
        }
        return fontDatas[0];
    }

    private static Font getFont(Widget widget) {
        if (widget instanceof CTabItem) {
            return ((CTabItem)widget).getFont();
        }
        if (widget instanceof ETabItem) {
            return ((ETabItem)widget).getFont();
        }
        if (widget instanceof Control) {
            return ((Control)widget).getFont();
        }
        return null;
    }
}

