/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.workbench.swt.internal;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProduct;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.RegistryFactory;
import org.eclipse.e4.core.services.context.EclipseContextFactory;
import org.eclipse.e4.core.services.context.IEclipseContext;
import org.eclipse.e4.ui.workbench.swt.Activator;
import org.eclipse.e4.ui.workbench.swt.internal.CSSStylingSupport;
import org.eclipse.e4.ui.workbench.swt.internal.ResourceUtility;
import org.eclipse.e4.ui.workbench.swt.internal.WorkbenchWindowHandler;
import org.eclipse.e4.workbench.ui.IResourceUtiltities;
import org.eclipse.e4.workbench.ui.IWorkbenchWindowHandler;
import org.eclipse.e4.workbench.ui.internal.Workbench;
import org.eclipse.emf.common.util.URI;
import org.eclipse.equinox.app.IApplication;
import org.eclipse.equinox.app.IApplicationContext;
import org.eclipse.jface.databinding.swt.SWTObservables;
import org.eclipse.swt.widgets.Display;
import org.osgi.framework.BundleContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WorkbenchApplication
implements IApplication {
    private static final String APPLICATION_CSS_RESOURCES_ARG = "-applicationCSSResources";
    private static final String APPLICATION_CSS_RESOURCES = "applicationCSSResources";
    private static final String APPLICATION_CSS_ARG = "-applicationCSS";
    private static final String APPLICATION_CSS = "applicationCSS";
    private static final String APPLICATION_XMI_ARG = "-applicationXMI";
    private static final String APPLICATION_XMI = "applicationXMI";
    public static Workbench workbench;

    public Object start(IApplicationContext applicationContext) throws Exception {
        final Display display = new Display();
        String[] args = (String[])applicationContext.getArguments().get("application.args");
        Map<String, String> argsList = this.processArgs(args);
        String appURI = argsList.get(APPLICATION_XMI);
        String cssURIr = argsList.get(APPLICATION_CSS);
        String cssResourcesURIr = argsList.get(APPLICATION_CSS_RESOURCES);
        IProduct product = Platform.getProduct();
        if (product != null) {
            if (appURI == null) {
                appURI = product.getProperty(APPLICATION_XMI);
            }
            if (cssURIr == null) {
                cssURIr = product.getProperty(APPLICATION_CSS);
            }
            if (cssResourcesURIr == null) {
                cssResourcesURIr = product.getProperty(APPLICATION_CSS_RESOURCES);
            }
        }
        final String cssURI = cssURIr;
        final String cssResourcesURI = cssResourcesURIr;
        Assert.isNotNull((Object)appURI, (String)"-applicationXMI argument missing");
        final URI initialWorkbenchDefinitionInstance = URI.createPlatformPluginURI((String)appURI, (boolean)true);
        Realm.runWithDefault((Realm)SWTObservables.getRealm((Display)display), (Runnable)new Runnable(){

            public void run() {
                try {
                    IEclipseContext serviceContext = EclipseContextFactory.createServiceContext((BundleContext)Activator.getDefault().getContext());
                    IEclipseContext appContext = EclipseContextFactory.create((IEclipseContext)serviceContext, null);
                    appContext.set("debugString", (Object)"WorkbenchAppContext");
                    appContext.set(IResourceUtiltities.class.getName(), (Object)new ResourceUtility(Activator.getDefault().getBundleAdmin()));
                    Workbench wb = new Workbench(Activator.getDefault().getInstanceLocation(), RegistryFactory.getRegistry(), Activator.getDefault().getBundleAdmin(), appContext, (IWorkbenchWindowHandler)new WorkbenchWindowHandler());
                    wb.setWorkbenchModelURI(initialWorkbenchDefinitionInstance);
                    if (cssURI != null) {
                        CSSStylingSupport.initializeStyling(display, cssURI, cssResourcesURI, wb.getContext());
                    }
                    wb.createUIFromModel();
                    wb.run();
                }
                catch (ThreadDeath th) {
                    throw th;
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
                catch (Error err) {
                    err.printStackTrace();
                }
            }
        });
        return IApplication.EXIT_OK;
    }

    private Map<String, String> processArgs(String[] args) {
        HashMap<String, String> argsList = new HashMap<String, String>();
        int i = 0;
        while (i < args.length) {
            if (APPLICATION_XMI_ARG.equals(args[i])) {
                argsList.put(APPLICATION_XMI, args[++i]);
            } else if (APPLICATION_CSS_ARG.equals(args[i])) {
                argsList.put(APPLICATION_CSS, args[++i]);
            } else if (APPLICATION_CSS_RESOURCES_ARG.equals(args[i])) {
                argsList.put(APPLICATION_CSS_RESOURCES, args[++i]);
            }
            ++i;
        }
        return argsList;
    }

    public void stop() {
    }
}

