/*******************************************************************************
 * Copyright (c) 2008 Hallvard Traetteberg.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Hallvard Traetteberg - initial API and implementation
 ******************************************************************************/
package org.eclipse.e4.tm.builder.swt;

import java.util.Iterator;
import java.util.StringTokenizer;

import org.eclipse.e4.tm.builder.IBinderContext;
import org.eclipse.e4.tm.widgets.AbstractComposite;
import org.eclipse.e4.tm.widgets.Control;
import org.eclipse.e4.tm.widgets.WidgetsPackage;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;

public class ControlBinder extends SwtBinder implements Listener {

	public void dispose(EObject eObject, Object object, IBinderContext context) {
		if (object instanceof org.eclipse.swt.widgets.Control) {
			org.eclipse.swt.widgets.Control swtControl = context.getObject(eObject, org.eclipse.swt.widgets.Control.class);
			if (swtControl != null) {
				swtControl.dispose();
			}
		}
		super.dispose(eObject, object, context);
	}

	private final static Class<?>[] constructorParameterTypes = new Class[]{org.eclipse.swt.widgets.Composite.class, int.class};

	protected int getSwtStyle(String styleString) {
		int style = SWT.NONE;
		StringTokenizer styles = SwtBuilder.getSeparatedTokens(styleString);
		while (styles.hasMoreTokens()) {
			style |= SwtBuilder.getStaticField(SWT.class, styles.nextToken(), Integer.class, SWT.NONE);
		}
		return style;
	}

	protected int getSwtStyle(EObject control) {
		String styleString = getClassAnnotation(control);
		return getSwtStyle(styleString);
	}

	protected void update(EObject control, EStructuralFeature feature, Object object, boolean isInit) {
		super.update(control, feature, object, isInit);
		if (control instanceof AbstractComposite && feature == WidgetsPackage.eINSTANCE.getAbstractComposite_Controls()) {
			Composite swtComposite = context.getObject(control, Composite.class);
			if (swtComposite != null) {
				swtComposite.layout();
			}
		}
	}

	protected void invalidateFeature(EObject eObject, EStructuralFeature feature, Object object, boolean isEvent) {
		if (eObject instanceof AbstractComposite && feature == WidgetsPackage.eINSTANCE.getAbstractComposite_Controls()) {
			AbstractComposite<? extends Control> composite = (AbstractComposite<? extends Control>)eObject;
			Composite swtComposite = context.getObject(composite, Composite.class);
			if (swtComposite != null) {
				org.eclipse.swt.widgets.Control[] swtControls = swtComposite.getChildren();
				for (int i = 0; i < swtControls.length; i++) {
					swtControls[i].dispose();
				}
			}
			for (Iterator<? extends Control> it = composite.getControls().iterator(); it.hasNext();) {
				Control control = it.next();
				context.dispose(control);
			}
		}
		super.invalidateFeature(eObject, feature, object, isEvent);
	}

	public final static String CONTROL_DATA_URI_KEY = "modelUri";

	protected Object create(EObject control) {
		int style = getSwtStyle(control);
		Class<?> swtClass = getToolkitClass(control);
		Composite swtComposite = getSwtParent(control, Composite.class);
		if (swtComposite != null && swtComposite.getLayout() == null) {
			setDefaultLayout(swtComposite);
		}
		Object swtObject = null;
		try {
			Object[] constructorArguments = new Object[]{swtComposite, style};
			swtObject = swtClass.getConstructor(ControlBinder.constructorParameterTypes).newInstance(constructorArguments);
			if (swtObject instanceof org.eclipse.swt.widgets.Control) {
				((org.eclipse.swt.widgets.Control)swtObject).setData(CONTROL_DATA_URI_KEY, EcoreUtil.getURI(control));
			}
		} catch (Exception e) {
			System.err.println("Exception when creating widget for " + this + ": " + e);
		}
		return swtObject;
	}

	protected void handleEventFeature(final EObject control, final EStructuralFeature feature, Object object) {
		if (! (object instanceof org.eclipse.swt.widgets.Control)) {
			return;
		}
		org.eclipse.swt.widgets.Control swtControl = (org.eclipse.swt.widgets.Control)object;
		String name = getRealName(feature);
		int eventType = SwtBuilder.getStaticField(SWT.class, name, Integer.class, SWT.NONE);
		swtControl.addListener(eventType, this);
		//		new Listener() {
		//			public void handleEvent(Event event) {
		//				//					System.out.println("Event: " + event);
		//				control.eSet(feature, event);
		//			}
		//		});
	}

	public void handleEvent(Event event) {
		EObject control = context.getEObject(event.widget);
		if (control == null) {
			return;
		}
		// find out which feature this event is for
		for (Iterator<EAttribute> it = control.eClass().getEAllAttributes().iterator(); it.hasNext();) {
			EStructuralFeature feature = it.next();
			if ("event".equals(getAccessMethod(feature, control.eClass()))) {
				String name = getRealName(feature);
				if (event.type == SwtBuilder.getStaticField(SWT.class, name, Integer.class, SWT.NONE)) {
					control.eSet(feature, event);
				}
			}
		}
	}
}
