/*******************************************************************************
 * Copyright (c) 2006, 2009 Soyatec (http://www.soyatec.com) and others.       *
 * All rights reserved. This program and the accompanying materials            *
 * are made available under the terms of the Eclipse Public License v1.0       *
 * which accompanies this distribution, and is available at                    *
 * http://www.eclipse.org/legal/epl-v10.html                                   *  
 * Contributors:                                                               *  
 *     Soyatec - initial API and implementation                                * 
 *******************************************************************************/
package org.eclipse.e4.xwt.utils;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.List;
import java.util.ResourceBundle;

import org.eclipse.core.databinding.conversion.IConverter;
import org.eclipse.e4.xwt.XWT;
import org.eclipse.swt.graphics.Color;

/**
 * @author jliu (jin.liu@soyatec.com)
 */
public class ColorsShop {
	private static ResourceBundle COLORS = ResourceBundle.getBundle("org.eclipse.e4.xwt.utils.colors");

	private static String[] colorNames;

	public static String[] getColorNames() {
		if (colorNames == null) {
			List<String> colors = new ArrayList<String>();
			Enumeration<String> keys = COLORS.getKeys();
			while (keys.hasMoreElements()) {
				String color = keys.nextElement();
				colors.add(color);
			}
			if (!colors.isEmpty()) {
				colorNames = colors.toArray(new String[0]);
				Arrays.sort(colorNames);
			}
		}
		return colorNames;
	}

	public static String getColorValue(String name) {
		if (!hasColor(name)) {
			return null;
		}
		String value = COLORS.getString(name);
		if (value != null) {
			value = value.trim();
		}
		return value;
	}

	public static boolean hasColor(String name) {
		if (name == null) {
			return false;
		}
		String[] colorNames = getColorNames();
		if (colorNames == null) {
			return false;
		}
		return Arrays.asList(colorNames).contains(name);
	}

	public static Color getColor(String name) {
		if (!hasColor(name)) {
			return null;
		}
		String colorValue = getColorValue(name);
		if (colorValue != null) {
			IConverter c = XWT.findConvertor(String.class, Color.class);
			if (c != null) {
				return (Color) c.convert(colorValue);
			}
		}
		return null;
	}

	/**
	 * Utility class.
	 */
	private ColorsShop() {
	}
}
