/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.tm.builder;

import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.e4.tm.builder.IBinderContext;
import org.eclipse.e4.tm.builder.IBuilder;
import org.eclipse.e4.tm.builder.IBuilderListener;
import org.eclipse.e4.tm.builder.ReflectionSupport;
import org.eclipse.e4.tm.builder.swt.IBinder;
import org.eclipse.e4.tm.stringconverter.StringConversion;
import org.eclipse.e4.tm.stringconverter.StringConverterContext;
import org.eclipse.e4.tm.stringconverters.AbstractClassStringConverter;
import org.eclipse.e4.tm.stringconverters.ClassStringConverter;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractBuilder
implements IBuilder,
StringConverterContext,
IBinderContext {
    private Object root = null;
    private List<Object> disposables = new ArrayList<Object>();
    private StringConversion stringConversion = new StringConversion();
    private AbstractClassStringConverter classResolver;
    private Map<EObject, Object> eObject2ObjectMap;
    private Map<Object, EObject> object2EObjectMap;
    private List<IBuilderListener> builderListeners;
    private Map<EClass, IBinder> binderMap;
    private ReflectionSupport reflectionSupport;

    public AbstractBuilder() {
        this.stringConversion.setStringConverterContext(this);
        this.classResolver = new ClassStringConverter();
        this.eObject2ObjectMap = new HashMap<EObject, Object>();
        this.object2EObjectMap = new HashMap<Object, EObject>();
        this.builderListeners = new ArrayList<IBuilderListener>();
        this.binderMap = new HashMap<EClass, IBinder>();
        this.reflectionSupport = new ReflectionSupport(this);
    }

    protected Object getToolkitComposite(Object context, Class<?> c) {
        if (c.isInstance(context)) {
            return context;
        }
        if (context instanceof IAdaptable) {
            return ((IAdaptable)context).getAdapter(c);
        }
        return null;
    }

    @Override
    public <T> T getRootObject(Class<T> c) {
        return this.adapt(this.root, c);
    }

    public void build(EObject control, Object context) {
        this.root = context;
        this.update(control);
        this.fireObjectHandled(1, control, context);
    }

    @Override
    public void build(Resource res, Object context) {
        EObject eObject = (EObject)res.getContents().get(0);
        this.build(eObject, context);
    }

    @Override
    public void registerDisposable(Object disposable) {
        this.disposables.add(disposable);
    }

    public StringConversion getStringConverter() {
        return this.stringConversion;
    }

    @Override
    public <T> T convert(String value, Class<T> klass) throws Exception {
        return this.stringConversion.convert(value, klass);
    }

    public AbstractClassStringConverter getClassResolver() {
        return this.classResolver;
    }

    @Override
    public Class<?> resolve(String className) {
        return this.classResolver.resolve(className);
    }

    @Override
    public void dispose() {
        for (Object disposable : this.disposables) {
            try {
                disposable.getClass().getMethod("dispose", new Class[0]).invoke(disposable, new Object[0]);
            }
            catch (Exception exception) {}
        }
        for (EObject eObject : this.eObject2ObjectMap.keySet()) {
            this.dispose(eObject);
        }
        this.eObject2ObjectMap.clear();
    }

    public static String getClassAnnotation(EClass eClass, String uri, String key, String def) {
        ArrayList<EClass> superClasses = new ArrayList<EClass>((Collection<EClass>)eClass.getEAllSuperTypes());
        superClasses.add(0, eClass);
        for (EClass superClass : superClasses) {
            String value = EcoreUtil.getAnnotation((EModelElement)superClass, (String)uri, (String)key);
            if (value == null) continue;
            return value;
        }
        return def;
    }

    public static String getFeatureAnnotation(EStructuralFeature feature, EClass realClass, String uri, String key, String def) {
        String value = null;
        while (value == null && realClass != null && realClass != feature.eContainer()) {
            value = EcoreUtil.getAnnotation((EModelElement)feature, (String)(String.valueOf(uri) + "#" + realClass.getName()), (String)key);
            realClass = null;
        }
        if (value == null) {
            value = EcoreUtil.getAnnotation((EModelElement)feature, (String)uri, (String)key);
        }
        if (value == null) {
            value = AbstractBuilder.getClassAnnotation(feature.getEContainingClass(), uri, key, def);
        }
        return value;
    }

    public static String getAnnotation(EModelElement element, String uri, String key, String def) {
        String value = EcoreUtil.getAnnotation((EModelElement)element, (String)uri, (String)key);
        return value != null ? value : def;
    }

    public static String casify(String s, Boolean cas) {
        if (s.length() > 0 && cas != null) {
            char first = s.charAt(0);
            s = String.valueOf(cas != false ? Character.toUpperCase(first) : Character.toLowerCase(first)) + s.substring(1);
        }
        return s;
    }

    @Override
    public <T> T getObject(EObject eObject, Class<T> c) {
        return this.getObject(eObject, c, false);
    }

    @Override
    public EObject getEObject(Object object) {
        return this.object2EObjectMap.get(object);
    }

    @Override
    public void putObject(EObject eObject, Object object) {
        this.eObject2ObjectMap.put(eObject, object);
        if (object != null) {
            this.object2EObjectMap.put(object, eObject);
        }
    }

    protected <T> T getObject(EObject eObject, Class<T> c, boolean searchContainers) {
        EObject eO = eObject;
        while ((eO == eObject || searchContainers) && eO != null) {
            Object o = this.eObject2ObjectMap.get(eO);
            if (!c.isInstance(o)) {
                o = this.adapt(eO, o, c);
            }
            if (c.isInstance(o)) {
                return (T)o;
            }
            eO = eO.eContainer();
        }
        return null;
    }

    @Override
    public void addBuilderListener(IBuilderListener listener) {
        this.builderListeners.add(listener);
    }

    @Override
    public void removeBuilderListener(IBuilderListener listener) {
        this.builderListeners.remove(listener);
    }

    @Override
    public void fireObjectHandled(int id, EObject eObject, Object object) {
        for (IBuilderListener listener : this.builderListeners) {
            listener.objectHandled(id, eObject, object);
        }
    }

    @Override
    public Object update(EObject eObject) {
        Object object = this.eObject2ObjectMap.get(eObject);
        IBinder binder = this.getBinder(eObject);
        if (binder == null) {
            throw new RuntimeException("Couldn't get IBinder for eClass " + eObject.eClass().getName());
        }
        Object newObject = binder.update(eObject, object, this);
        this.eObject2ObjectMap.put(eObject, newObject);
        this.fireObjectHandled(2, eObject, object);
        return newObject;
    }

    @Override
    public void dispose(EObject eObject) {
        Object object = this.eObject2ObjectMap.get(eObject);
        IBinder binder = this.getBinder(eObject);
        if (binder == null) {
            throw new RuntimeException("Couldn't get IBinder for eClass " + eObject.eClass().getName());
        }
        binder.dispose(eObject, object, this);
        this.fireObjectHandled(3, eObject, object);
    }

    protected IBinder getBinder(EObject eObject) {
        EClass eClass = eObject.eClass();
        IBinder binder = this.binderMap.get(eClass);
        if (binder == null) {
            binder = this.createBinder(eClass);
            this.binderMap.put(eClass, binder);
        }
        return binder;
    }

    protected IBinder createBinder(EClass eClass) {
        ArrayList<EClass> superTypes = new ArrayList<EClass>((Collection<EClass>)eClass.getEAllSuperTypes());
        superTypes.add(0, eClass);
        for (EClass superClass : superTypes) {
            IBinder binder = this.createBinderForEClass(superClass);
            if (binder == null) continue;
            return binder;
        }
        return null;
    }

    protected IBinder createBinderForEClass(EClass eClass) {
        Class<? extends IBinder> c = this.getBinderClassforEClass(eClass);
        IBinder binder = null;
        if (c != null && IBinder.class.isAssignableFrom(c)) {
            try {
                binder = c.newInstance();
                Method setter = this.reflectionSupport.getSetterMethod(binder, "builder", this, false);
                if (setter != null) {
                    setter.invoke((Object)binder, this);
                }
            }
            catch (Exception exception) {}
            if (binder == null) {
                Constructor<?>[] constructors = c.getConstructors();
                int i = 0;
                while (i < constructors.length) {
                    if (ReflectionSupport.hasSingleParameterForValue(constructors[i].getParameterTypes(), this, false)) {
                        try {
                            binder = (IBinder)constructors[i].newInstance(this);
                        }
                        catch (Exception exception) {}
                    }
                    ++i;
                }
            }
        }
        return binder;
    }

    protected Class<? extends IBinder> getBinderClassforEClass(EClass eClass) {
        Class<?> c;
        String className = this.getClass().getName();
        int pos = className.lastIndexOf(46);
        if (pos > 0) {
            className = String.valueOf(className.substring(0, pos + 1)) + eClass.getName() + "Binder";
        }
        return (c = this.getClassResolver().resolve(className)) != null && IBinder.class.isAssignableFrom(c) ? c : null;
    }

    public <T> T adapt(EObject eObject, Object value, Class<T> c) {
        if (eObject == null) {
            return this.adapt(value, c);
        }
        IBinder binder = this.getBinder(eObject);
        T o = binder.adapt(value, c);
        if (!c.isInstance(o)) {
            o = this.adapt(value, c);
        }
        return (T)(c.isInstance(o) ? o : null);
    }

    @Override
    public <T> T adapt(Object value, Class<T> c) {
        if (c.isPrimitive()) {
            c = ClassStringConverter.getObjectClass(c);
        }
        if (value == null) {
            return this.getRootObject(c);
        }
        if (c.isInstance(value)) {
            return (T)value;
        }
        if (value instanceof String) {
            return this.getStringConverter().convert((String)value, c);
        }
        if (value instanceof Collection && c.isArray()) {
            Collection collection = (Collection)value;
            Class<?> elementType = c.getComponentType();
            Object array = Array.newInstance(elementType, collection.size());
            int i = 0;
            for (Object o : collection) {
                Object o2 = this.adapt(o, elementType);
                Array.set(array, i++, o2);
            }
            return (T)array;
        }
        return null;
    }

    public Method getMethod(Object object, String signature) {
        return this.reflectionSupport.getMethod(object, signature);
    }

    @Override
    public Object getGetterProperty(Object object, String name) {
        return this.reflectionSupport.getGetterProperty(object, name);
    }

    @Override
    public Object getMethodProperty(Object object, String methodSpec, Object[] args) {
        return this.reflectionSupport.getMethodProperty(object, methodSpec, args);
    }

    @Override
    public Object getFieldProperty(Object object, String name) {
        return this.reflectionSupport.getFieldProperty(object, name);
    }

    @Override
    public Exception setSetterProperty(Object object, String name, Object value) {
        return this.reflectionSupport.setSetterProperty(object, name, value);
    }

    @Override
    public Exception setMethodProperty(Object object, String methodSpec, Object[] args) {
        return this.reflectionSupport.setMethodProperty(object, methodSpec, args);
    }

    @Override
    public Exception setFieldProperty(Object object, String name, Object value) {
        return this.reflectionSupport.setFieldProperty(object, name, value);
    }

    @Override
    public void setProperty(Object object, String name, Object value) throws Exception {
        this.reflectionSupport.setProperty(object, name, value);
    }
}

