/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.tm.stringconverter;

import java.util.HashMap;
import org.eclipse.e4.tm.stringconverter.CompositeStringConverter;
import org.eclipse.e4.tm.stringconverter.StringConverter;
import org.eclipse.e4.tm.stringconverter.StringConverterContext;
import org.eclipse.e4.tm.stringconverters.ArrayStringConverter;
import org.eclipse.e4.tm.stringconverters.ByteStringConverter;
import org.eclipse.e4.tm.stringconverters.ClassStringConverter;
import org.eclipse.e4.tm.stringconverters.IntStringConverter;
import org.eclipse.e4.tm.stringconverters.PointStringConverter;
import org.eclipse.e4.tm.stringconverters.RGBStringConverter;
import org.eclipse.e4.tm.stringconverters.RectangleStringConverter;
import org.eclipse.e4.tm.stringconverters.SWTColorsStringConverter;
import org.eclipse.e4.tm.stringconverters.StringStringConverter;
import org.eclipse.e4.tm.stringconverters.ValueOfStringConverter;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StringConversion {
    private StringConverterContext stringConverterContext;
    private HashMap<Object, StringConverter> stringConverters = new HashMap();
    private boolean trySuperclassConverters = true;
    private Class<?> upperSuperclass = null;

    public void setStringConverterContext(StringConverterContext stringConverterContext) {
        this.stringConverterContext = stringConverterContext;
    }

    public StringConversion(boolean addStandardConverters) {
        if (addStandardConverters) {
            this.registerStringConverter(Integer.TYPE, new IntStringConverter());
            this.registerStringConverter(Byte.TYPE, new ByteStringConverter());
            this.registerStringConverter(String.class, new StringStringConverter());
            this.registerStringConverter(RGB.class, new RGBStringConverter());
            this.registerStringConverter(Point.class, new PointStringConverter());
            this.registerStringConverter(Rectangle.class, new RectangleStringConverter());
            this.addStringConverter(Color.class, new SWTColorsStringConverter());
        }
    }

    public StringConversion() {
        this(true);
    }

    public <T> void registerStringConverter(Class<T> klass, StringConverter stringConverter) {
        this.stringConverters.put(klass, stringConverter);
        this.stringConverters.put(klass.getName(), stringConverter);
    }

    public <T> void addStringConverter(Class<T> klass, StringConverter stringConverter) {
        StringConverter oldConverter = this.stringConverters.get(klass);
        if (oldConverter == null) {
            this.registerStringConverter(klass, stringConverter);
        } else {
            if (!(oldConverter instanceof CompositeStringConverter)) {
                oldConverter = new CompositeStringConverter(oldConverter);
                this.stringConverters.put(klass, oldConverter);
            }
            ((CompositeStringConverter)oldConverter).addStringConverter(stringConverter);
        }
    }

    public void setTrySuperclassConverters(boolean trySuperclassConverters) {
        this.trySuperclassConverters = trySuperclassConverters;
    }

    public void setUpperSuperclass(Class<?> upperSuperclass) {
        this.upperSuperclass = upperSuperclass;
    }

    public <T> T convert(String value, Class<T> klass) {
        String stringValue = value;
        if (stringValue != null) {
            Class<T> superClass = klass;
            Class<Object> objectClass = ClassStringConverter.getObjectClass(klass);
            T lastResult = null;
            do {
                T result = null;
                StringConverter converter = this.getStringConverter(superClass);
                if (converter != null) {
                    try {
                        result = converter.convert(stringValue, klass, this.stringConverterContext);
                    }
                    catch (Exception e) {
                        throw new RuntimeException("Exception when converting " + value + " for " + superClass, e);
                    }
                } else if (!this.trySuperclassConverters) {
                    throw new RuntimeException("Unable to find a converter for type: " + klass.getName());
                }
                if (result != null) {
                    if (objectClass.isInstance(result)) {
                        return result;
                    }
                    lastResult = result;
                }
                superClass = superClass.getSuperclass();
            } while (this.trySuperclassConverters && superClass != null && superClass != this.upperSuperclass);
            throw new RuntimeException(String.valueOf(value) + " (" + stringValue + ")" + " could not be parsed into " + klass + ", but to " + lastResult);
        }
        return null;
    }

    private StringConverter getStringConverter(Class<?> klass) {
        StringConverter converter = this.stringConverters.get(klass);
        if (converter == null) {
            converter = this.stringConverters.get(klass.getName());
        }
        if (converter == null) {
            if (klass.isArray()) {
                converter = new ArrayStringConverter();
            } else if (ValueOfStringConverter.supportsClass(klass)) {
                converter = new ValueOfStringConverter();
            }
            if (converter != null) {
                this.stringConverters.put(klass, converter);
            } else {
                converter = this.stringConverters.get(Object.class);
            }
        }
        return converter;
    }
}

