/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.resources.semantic.examples.remote;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.semantic.examples.remote.RemoteFile;
import org.eclipse.core.resources.semantic.examples.remote.RemoteFolder;
import org.eclipse.core.resources.semantic.examples.remote.RemoteItem;
import org.eclipse.core.resources.semantic.examples.remote.RemoteStoreTransient;
import org.eclipse.core.resources.semantic.examples.remote.SemanticResourcesPluginExamplesCore;
import org.eclipse.core.resources.semantic.spi.Util;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class RemoteStore
extends RemoteStoreTransient {
    public static final String FILENAME = "simulatedRemoteContent.xml";
    private static final String XML_ATT_NAME = "Name";
    private static final String XML_ELEMENT_VERSION = "Version";
    private static final String XML_ATT_VERSION = "Version";
    private static final String XML_ATT_TYPE = "Type";
    private static final String XML_ATT_TIMESTAMP = "Timestamp";
    private static final String XML_ATT_LOCKED = "Locked";
    private static final String XML_ATT_VAL_EMPTY = "";

    public RemoteStore(IContainer container) {
        super(container);
    }

    public void serialize(IProgressMonitor monitor) throws CoreException {
        ByteArrayInputStream is;
        Transformer transformer;
        DocumentBuilder db;
        RemoteFolder folder = this.getRootFolder();
        try {
            db = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            Status error = new Status(4, SemanticResourcesPluginExamplesCore.PLUGIN_ID, null, (Throwable)e);
            throw new CoreException((IStatus)error);
        }
        Document doc = db.newDocument();
        Element root = doc.createElement("Root");
        doc.appendChild(root);
        this.serializeItem(doc, folder, root);
        DOMSource domSource = new DOMSource(doc);
        StringWriter writer = new StringWriter();
        StreamResult result = new StreamResult(writer);
        TransformerFactory tf = TransformerFactory.newInstance();
        try {
            transformer = tf.newTransformer();
        }
        catch (TransformerConfigurationException e) {
            Status error = new Status(4, SemanticResourcesPluginExamplesCore.PLUGIN_ID, null, (Throwable)e);
            throw new CoreException((IStatus)error);
        }
        transformer.setOutputProperty("standalone", "no");
        transformer.setOutputProperty("indent", "yes");
        try {
            transformer.transform(domSource, result);
        }
        catch (TransformerException e) {
            Status error = new Status(4, SemanticResourcesPluginExamplesCore.PLUGIN_ID, null, (Throwable)e);
            throw new CoreException((IStatus)error);
        }
        IFile file = this.myContainer.getProject().getFile(FILENAME);
        try {
            is = new ByteArrayInputStream(writer.getBuffer().toString().getBytes(file.getCharset(true)));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            is = new ByteArrayInputStream(writer.getBuffer().toString().getBytes());
        }
        if (!file.exists()) {
            file.create((InputStream)is, false, null);
        } else {
            file.setContents((InputStream)is, 0, monitor);
        }
    }

    public void deserialize() throws CoreException {
        this.reset();
        IFile file = this.myContainer.getProject().getFile((IPath)new Path(FILENAME));
        if (file.exists()) {
            RemoteFolder folder = this.getRootFolder();
            XmlContentHandler handler = new XmlContentHandler(folder);
            InputStream is = null;
            try {
                try {
                    SAXParserFactory.newInstance().newSAXParser().parse(file.getContents(), (DefaultHandler)handler);
                }
                catch (SAXException e) {
                    Status error = new Status(4, SemanticResourcesPluginExamplesCore.PLUGIN_ID, null, (Throwable)e);
                    throw new CoreException((IStatus)error);
                }
                catch (IOException e) {
                    Status error = new Status(4, SemanticResourcesPluginExamplesCore.PLUGIN_ID, null, (Throwable)e);
                    throw new CoreException((IStatus)error);
                }
                catch (ParserConfigurationException e) {
                    Status error = new Status(4, SemanticResourcesPluginExamplesCore.PLUGIN_ID, null, (Throwable)e);
                    throw new CoreException((IStatus)error);
                }
            }
            finally {
                Util.safeClose(is);
            }
        }
    }

    private void serializeItem(Document doc, RemoteItem actItem, Element element) {
        Element child = doc.createElement(actItem.getType().name());
        child.setAttribute(XML_ATT_TYPE, actItem.getType().toString());
        child.setAttribute(XML_ATT_NAME, actItem.getName());
        element.appendChild(child);
        if (actItem.getType() == RemoteItem.Type.FOLDER) {
            RemoteFolder folder = (RemoteFolder)actItem;
            for (RemoteItem item : folder.getChildren()) {
                this.serializeItem(doc, item, child);
            }
        } else {
            RemoteFile file = (RemoteFile)actItem;
            child.setAttribute(XML_ATT_TIMESTAMP, Long.toString(file.getTimestamp()));
            child.setAttribute(XML_ATT_LOCKED, Boolean.toString(file.isLocked()));
            CDATASection section = doc.createCDATASection(RemoteStore.bytesToString(file.myContent));
            child.appendChild(section);
            Map<String, byte[]> versions = file.myVersions;
            for (Map.Entry<String, byte[]> version : versions.entrySet()) {
                Element versionElement = doc.createElement("Version");
                versionElement.setAttribute(XML_ATT_TYPE, "Version");
                child.appendChild(versionElement);
                versionElement.setAttribute("Version", version.getKey());
                String contentData = RemoteStore.bytesToString(version.getValue());
                CDATASection contentSection = doc.createCDATASection(contentData);
                versionElement.appendChild(contentSection);
            }
        }
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.myContainer.getFullPath() == null ? 0 : this.myContainer.getFullPath().hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RemoteStore other = (RemoteStore)obj;
        return !(this.myContainer.getFullPath() == null ? other.myContainer.getFullPath() != null : !this.myContainer.getFullPath().equals((Object)other.myContainer.getFullPath()));
    }

    static byte[] stringToBytes(String string) {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        int token = 0;
        while (token + 1 < string.length()) {
            byte value = (byte)(Integer.parseInt(new String(new char[]{string.charAt(token), string.charAt(++token)}), 16) - 128);
            bos.write(value);
            ++token;
        }
        return bos.toByteArray();
    }

    static String bytesToString(byte[] bytes) {
        StringBuilder sb = new StringBuilder();
        byte[] byArray = bytes;
        int n = bytes.length;
        int n2 = 0;
        while (n2 < n) {
            byte c = byArray[n2];
            String hexString = Integer.toHexString(c + 128);
            sb.append(hexString);
            ++n2;
        }
        return sb.toString();
    }

    private static final class XmlContentHandler
    extends DefaultHandler {
        private RemoteFolder currentFolder;
        private RemoteFile currentFile;
        private String currentVersion = "";

        public XmlContentHandler(RemoteFolder rootFolder) {
            this.currentFolder = rootFolder;
        }

        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            String name;
            HashMap<String, String> nameValuePairs = new HashMap<String, String>();
            int i = 0;
            while (i < attributes.getLength()) {
                name = attributes.getQName(i);
                String value = attributes.getValue(i);
                nameValuePairs.put(name, value);
                ++i;
            }
            String type = (String)nameValuePairs.get(RemoteStore.XML_ATT_TYPE);
            if (type == null) {
                return;
            }
            if (type.equals(RemoteItem.Type.FOLDER.toString())) {
                if (((String)nameValuePairs.get(RemoteStore.XML_ATT_NAME)).equals(RemoteStore.XML_ATT_VAL_EMPTY)) {
                    return;
                }
                this.currentFolder = this.currentFolder.addFolder((String)nameValuePairs.get(RemoteStore.XML_ATT_NAME));
            } else if (type.equals(RemoteItem.Type.FILE.toString())) {
                name = (String)nameValuePairs.get(RemoteStore.XML_ATT_NAME);
                long timestamp = Long.parseLong((String)nameValuePairs.get(RemoteStore.XML_ATT_TIMESTAMP));
                String lockString = (String)nameValuePairs.get(RemoteStore.XML_ATT_TIMESTAMP);
                boolean locked = false;
                if (lockString != null) {
                    locked = Boolean.parseBoolean((String)nameValuePairs.get(RemoteStore.XML_ATT_LOCKED));
                }
                this.currentFile = this.currentFolder.addFile(name, new byte[0], timestamp);
                this.currentFile.setLocked(locked);
            } else if (type.equals("Version")) {
                String version;
                this.currentVersion = version = (String)nameValuePairs.get("Version");
            }
        }

        public void characters(char[] ch, int start, int length) throws SAXException {
            if (this.currentFile == null && this.currentVersion.equals(RemoteStore.XML_ATT_VAL_EMPTY)) {
                return;
            }
            if (length % 2 != 0) {
                return;
            }
            if (!this.currentVersion.equals(RemoteStore.XML_ATT_VAL_EMPTY)) {
                try {
                    byte[] bytes = RemoteStore.stringToBytes(new String(ch).substring(start, start + length));
                    this.currentFile.myVersions.put(this.currentVersion, bytes);
                }
                catch (IllegalArgumentException e) {
                    throw new SAXException(e);
                }
            }
            if (this.currentFile != null) {
                try {
                    byte[] bytes = RemoteStore.stringToBytes(new String(ch).substring(start, start + length));
                    if (bytes.length > 0) {
                        this.currentFile.myContent = bytes;
                    }
                }
                catch (IllegalArgumentException e) {
                    throw new SAXException(e);
                }
            }
        }

        public void endElement(String uri, String localName, String qName) throws SAXException {
            if (qName.equals(RemoteItem.Type.FOLDER.name())) {
                this.currentFolder = this.currentFolder.getParent();
            } else if (qName.equals(RemoteItem.Type.FILE.name())) {
                this.currentFile = null;
            } else if (qName.equals("Version")) {
                this.currentVersion = RemoteStore.XML_ATT_VAL_EMPTY;
            }
        }
    }
}

