/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.demo.contacts.model.internal;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Enumeration;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.core.databinding.observable.list.WritableList;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.e4.demo.contacts.BundleActivatorImpl;
import org.eclipse.e4.demo.contacts.model.Contact;
import org.eclipse.e4.demo.contacts.model.IContactsRepository;
import org.eclipse.osgi.internal.signedcontent.Base64;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.widgets.Display;
import org.osgi.framework.Bundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VCardContactsRepository
implements IContactsRepository {
    private final IObservableList contacts;

    public VCardContactsRepository() {
        ArrayList<Contact> contacts = new ArrayList<Contact>();
        try {
            File[] fileArray = this.getContacts();
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                Contact contact = this.readFromVCard(file.getAbsolutePath());
                contacts.add(contact);
                ++n2;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.contacts = new WritableList(contacts, null);
    }

    private File[] getContacts() throws Exception {
        File[] localContacts = this.getLocalContacts();
        if (localContacts.length == 0) {
            IPath path = BundleActivatorImpl.getInstance().getStateLocation();
            byte[] buffer = new byte[8192];
            Bundle bundle = Platform.getBundle((String)"org.eclipse.e4.demo.contacts");
            Enumeration<?> contacts = this.getStoredContacts();
            while (contacts.hasMoreElements()) {
                String bundlePath = (String)contacts.nextElement();
                if (!bundlePath.endsWith(".vcf")) continue;
                InputStream inputStream = FileLocator.openStream((Bundle)bundle, (IPath)new Path(bundlePath), (boolean)false);
                FileOutputStream outputStream = new FileOutputStream(path.append(bundlePath.substring(bundlePath.indexOf(47) + 1)).toFile());
                int read = inputStream.read(buffer);
                while (read != -1) {
                    outputStream.write(buffer, 0, read);
                    read = inputStream.read(buffer);
                }
                inputStream.close();
                outputStream.close();
            }
            return this.getLocalContacts();
        }
        return localContacts;
    }

    private File[] getLocalContacts() {
        IPath path = BundleActivatorImpl.getInstance().getStateLocation();
        File directory = path.toFile();
        return directory.listFiles(new FilenameFilter(){

            public boolean accept(File dir, String name) {
                return name.endsWith(".vcf");
            }
        });
    }

    private Enumeration<?> getStoredContacts() throws Exception {
        Bundle bundle = Platform.getBundle((String)"org.eclipse.e4.demo.contacts");
        return bundle.getEntryPaths("vcards");
    }

    @Override
    public void addContact(Contact contact) {
        this.contacts.add((Object)contact);
    }

    @Override
    public IObservableList getAllContacts() {
        return this.contacts;
    }

    @Override
    public void removeContact(Contact contact) {
        this.contacts.remove((Object)contact);
    }

    public Contact readFromVCard(String fileName) {
        Contact contact = new Contact();
        contact.setSourceFile(fileName);
        BufferedReader bufferedReader = null;
        String charSet = "Cp1252";
        try {
            try {
                String line;
                InputStreamReader inputStreamReader = new InputStreamReader((InputStream)new FileInputStream(fileName), charSet);
                bufferedReader = new BufferedReader(inputStreamReader);
                while ((line = bufferedReader.readLine()) != null) {
                    String[] result;
                    String value = this.getVCardValue(line, "N");
                    if (value != null) {
                        result = value.split(";");
                        if (result.length > 0) {
                            contact.setLastName(result[0]);
                        }
                        if (result.length > 1) {
                            contact.setFirstName(result[1]);
                        }
                        if (result.length > 2) {
                            contact.setMiddleName(result[2]);
                        }
                        if (result.length <= 3) continue;
                        contact.setTitle(result[3]);
                        continue;
                    }
                    value = this.getVCardValue(line, "TEL;WORK");
                    if (value != null) {
                        contact.setPhone(value);
                        continue;
                    }
                    value = this.getVCardValue(line, "TEL;CELL");
                    if (value != null) {
                        contact.setMobile(value);
                        continue;
                    }
                    value = this.getVCardValue(line, "ADR;WORK");
                    if (value != null) {
                        result = value.split(";");
                        if (result.length > 2) {
                            contact.setStreet(result[2]);
                        }
                        if (result.length > 3) {
                            contact.setCity(result[3]);
                        }
                        if (result.length > 4) {
                            contact.setState(result[4]);
                        }
                        if (result.length > 5) {
                            contact.setZip(result[5]);
                        }
                        if (result.length <= 6) continue;
                        contact.setCountry(result[6]);
                        continue;
                    }
                    value = this.getVCardValue(line, "EMAIL;PREF;INTERNET");
                    if (value != null) {
                        contact.setEmail(value);
                        continue;
                    }
                    value = this.getVCardValue(line, "URL;WORK");
                    if (value != null) {
                        contact.setWebPage(value);
                        continue;
                    }
                    value = this.getVCardValue(line, "ORG");
                    if (value != null) {
                        contact.setCompany(value);
                        continue;
                    }
                    value = this.getVCardValue(line, "TITLE");
                    if (value != null) {
                        contact.setJobTitle(value);
                        continue;
                    }
                    value = this.getVCardValue(line, "NOTE");
                    if (value != null) {
                        contact.setNote(value);
                        continue;
                    }
                    value = this.getVCardValue(line, "PHOTO;TYPE=JPEG;ENCODING=BASE64");
                    if (value == null) continue;
                    line = bufferedReader.readLine();
                    StringBuilder builder = new StringBuilder();
                    while (line != null && line.length() > 0 && line.charAt(0) == ' ') {
                        builder.append(line.trim());
                        line = bufferedReader.readLine();
                    }
                    String jpegString = builder.toString();
                    byte[] imageBytes = Base64.decode((byte[])jpegString.getBytes());
                    ByteArrayInputStream is = new ByteArrayInputStream(imageBytes);
                    ImageData imageData = new ImageData((InputStream)is);
                    contact.setImage(new Image((Device)Display.getCurrent(), imageData));
                    contact.setJpegString(jpegString);
                }
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
                try {
                    if (bufferedReader != null) {
                        bufferedReader.close();
                    }
                }
                catch (IOException e2) {
                    e2.printStackTrace();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                try {
                    if (bufferedReader != null) {
                        bufferedReader.close();
                    }
                }
                catch (IOException e3) {
                    e3.printStackTrace();
                }
            }
        }
        finally {
            try {
                if (bufferedReader != null) {
                    bufferedReader.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return contact;
    }

    private String getVCardValue(String line, String token) {
        if (line.startsWith(String.valueOf(token) + ":") || line.startsWith(String.valueOf(token) + ";")) {
            String value = line.substring(line.indexOf(":") + 1);
            return value;
        }
        return null;
    }
}

