/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.platform.discovery.runtime.internal.xp.impl;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.platform.discovery.runtime.api.IDestinationChangeHandler;
import org.eclipse.platform.discovery.runtime.api.IDestinationsProvider;
import org.eclipse.platform.discovery.runtime.internal.model.descriptions.IDestinationsProviderDescription;
import org.eclipse.platform.discovery.runtime.internal.xp.IDestinationsProviderExtensionParser;
import org.eclipse.platform.discovery.runtime.internal.xp.impl.AbstractExtensionPointParser;

public class DestinationsProviderExtensionParser
extends AbstractExtensionPointParser
implements IDestinationsProviderExtensionParser {
    private static final String XP_ID = "org.eclipse.platform.discovery.runtime.destinationsprovider";
    private static final String XP_ELEMENT_NAME = "destinationsprovider";
    private static final String DEST_CATEGORY_ATTR = "destcategoryid";
    private static final String PROVIDER_INSTANCE_ATTR = "provider";
    private static final String PROVIDER_ID_ATTR = "id";
    private static final String PROVIDER_PREF_PAGE_ID = "preferencepageid";

    public DestinationsProviderExtensionParser() {
        super(Platform.getExtensionRegistry(), XP_ID, XP_ELEMENT_NAME);
    }

    @Override
    public Set<IDestinationsProviderDescription> readContributions() {
        HashSet<IDestinationsProviderDescription> result = new HashSet<IDestinationsProviderDescription>();
        for (IConfigurationElement element : this.getConfigurationElements()) {
            result.add(this.createProvderDescr(element));
        }
        return result;
    }

    private IDestinationsProviderDescription createProvderDescr(final IConfigurationElement element) {
        return new IDestinationsProviderDescription(){
            private IDestinationChangeHandler changeHandler;

            @Override
            public String getDestinationCategoryId() {
                return element.getAttribute(DestinationsProviderExtensionParser.DEST_CATEGORY_ATTR);
            }

            @Override
            public String getDisplayName() {
                return element.getAttribute(DestinationsProviderExtensionParser.PROVIDER_INSTANCE_ATTR);
            }

            @Override
            public String getId() {
                return element.getAttribute(DestinationsProviderExtensionParser.PROVIDER_ID_ATTR);
            }

            @Override
            public String getPreferencePageId() {
                return element.getAttribute(DestinationsProviderExtensionParser.PROVIDER_PREF_PAGE_ID);
            }

            @Override
            public IDestinationsProvider createProvider() {
                try {
                    IDestinationsProvider provider = (IDestinationsProvider)element.createExecutableExtension(DestinationsProviderExtensionParser.PROVIDER_INSTANCE_ATTR);
                    if (this.changeHandler != null) {
                        provider.registerDestinationsChangeHandler(this.changeHandler);
                    }
                    return provider;
                }
                catch (CoreException e) {
                    throw new IllegalStateException("Destinations provider could not be instantiated", e);
                }
            }

            @Override
            public void registerDestinationsChangeHandler(IDestinationChangeHandler changeHandler) {
                this.changeHandler = changeHandler;
            }
        };
    }
}

