/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.internal.gadgets.opensocial;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.eclipse.e4.ui.internal.gadgets.opensocial.LocaleKey;
import org.eclipse.e4.ui.internal.gadgets.opensocial.OSGContent;
import org.eclipse.e4.ui.internal.gadgets.opensocial.OSGLocale;
import org.eclipse.e4.ui.internal.gadgets.opensocial.OSGModule;
import org.eclipse.e4.ui.internal.gadgets.opensocial.OSGUserPref;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OpenSocialUtil {
    private static int moduleId = 0;

    public static OSGModule loadModule(String uriString) {
        OSGModule module;
        URI uri;
        try {
            uri = new URI(uriString);
            module = OpenSocialUtil.parseModuleXML(uri);
        }
        catch (Exception e) {
            throw new RuntimeException("Could not load module", e);
        }
        OSGLocale locale = OpenSocialUtil.determineLocale(module);
        HashMap<String, String> hangmanMap = new HashMap<String, String>();
        hangmanMap.put("__MODULE_ID__", String.valueOf(moduleId++));
        hangmanMap.put("__ENV_google_apps_auth_path__", "render#");
        OpenSocialUtil.populateHangmanMapFromLocale(hangmanMap, locale, uri);
        OpenSocialUtil.populateHangmanMapFromUserPrefs(hangmanMap, module.userPrefs);
        module.title = OpenSocialUtil.hangmanExpand(module.title, hangmanMap);
        module.description = OpenSocialUtil.hangmanExpand(module.description, hangmanMap);
        module.author = OpenSocialUtil.hangmanExpand(module.author, hangmanMap);
        for (OSGContent content : new HashSet<OSGContent>(module.contents.values())) {
            if ("url".equalsIgnoreCase(content.type)) {
                content.href = OpenSocialUtil.hangmanExpand(content.href, hangmanMap);
                continue;
            }
            if (!"html".equalsIgnoreCase(content.type)) continue;
            content.value = OpenSocialUtil.hangmanExpand(content.value, hangmanMap);
        }
        return module;
    }

    private static void populateHangmanMapFromUserPrefs(Map<String, String> hangmanMap, List<OSGUserPref> userPrefs) {
        for (OSGUserPref pref : userPrefs) {
            hangmanMap.put("__UP_" + pref.name + "__", pref.defaultValue);
        }
    }

    private static void populateHangmanMapFromLocale(Map<String, String> hangmanMap, OSGLocale locale, URI uri) {
        hangmanMap.put("__BIDI_START_EDGE__", "left");
        hangmanMap.put("__BIDI_END_EDGE__", "right");
        hangmanMap.put("__BIDI_DIR__", "ltr");
        hangmanMap.put("__BIDI_REVERSE_DIR__", "rtl");
        if (locale != null) {
            String messagesURIString;
            if ("rtl".equals(locale.languageDirection)) {
                hangmanMap.put("__BIDI_START_EDGE__", "right");
                hangmanMap.put("__BIDI_END_EDGE__", "left");
                hangmanMap.put("__BIDI_DIR__", "rtl");
                hangmanMap.put("__BIDI_REVERSE_DIR__", "ltr");
            }
            if ((messagesURIString = locale.messagesURI) != null) {
                if (!messagesURIString.startsWith("http")) {
                    if (!messagesURIString.startsWith("/")) {
                        String uriString = uri.toString();
                        messagesURIString = String.valueOf(uriString.substring(0, uriString.lastIndexOf(47))) + "/" + messagesURIString;
                    } else {
                        messagesURIString = "http://" + uri.getHost() + messagesURIString;
                    }
                }
                try {
                    OpenSocialUtil.addMessagesToMap(hangmanMap, messagesURIString);
                }
                catch (Exception e) {
                    throw new RuntimeException("Could not parse messages", e);
                }
            } else {
                OpenSocialUtil.addMessagesToMap(hangmanMap, locale.messages);
            }
        }
    }

    private static OSGLocale determineLocale(OSGModule module) {
        OSGLocale locale = module.locales.get(new LocaleKey(System.getProperty("osgi.nl"), System.getProperty("user.country")));
        if (locale == null) {
            locale = module.locales.get(new LocaleKey(System.getProperty("user.language"), System.getProperty("user.country")));
        }
        if (locale == null) {
            locale = module.locales.get(new LocaleKey(System.getProperty("osgi.nl"), null));
        }
        if (locale == null) {
            locale = module.locales.get(new LocaleKey(System.getProperty("user.language"), null));
        }
        if (locale == null) {
            locale = module.locales.get(new LocaleKey(null, System.getProperty("user.country")));
        }
        if (locale == null) {
            locale = module.locales.get(new LocaleKey(null, null));
        }
        return locale;
    }

    private static OSGModule parseModuleXML(URI uri) throws Exception {
        final OSGModule[] result = new OSGModule[1];
        OpenSocialUtil.parseXML(uri, new DefaultHandler(){
            OSGModule module;
            OSGContent content;
            StringBuffer contentBuffer;
            OSGLocale locale;
            String currentMsgName = null;
            StringBuffer currentMsgValue = null;

            public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
                if (this.contentBuffer != null) {
                    this.contentBuffer.append("<" + qName);
                    int i = 0;
                    while (i < attributes.getLength()) {
                        this.contentBuffer.append(" " + attributes.getQName(i) + "=\"" + attributes.getValue(i) + "\"");
                        ++i;
                    }
                    this.contentBuffer.append(">");
                } else if ("ModulePrefs".equalsIgnoreCase(qName)) {
                    result[0] = this.module = new OSGModule(attributes.getValue("title"), attributes.getValue("author"), attributes.getValue("description"));
                } else if ("Locale".equalsIgnoreCase(qName)) {
                    this.locale = new OSGLocale(attributes.getValue("lang"), attributes.getValue("country"), attributes.getValue("language_direction"), attributes.getValue("messages"));
                    this.module.locales.put(new LocaleKey(this.locale.lang, this.locale.country), this.locale);
                } else if ("msg".equalsIgnoreCase(qName)) {
                    this.currentMsgName = attributes.getValue("name");
                    this.currentMsgValue = new StringBuffer();
                } else if ("UserPref".equalsIgnoreCase(qName)) {
                    this.module.userPrefs.add(new OSGUserPref(attributes.getValue("name"), attributes.getValue("default_value")));
                } else if ("Content".equalsIgnoreCase(qName)) {
                    this.content = new OSGContent(attributes.getValue("type"), attributes.getValue("view"), attributes.getValue("href"));
                    this.contentBuffer = new StringBuffer();
                }
            }

            public void characters(char[] ch, int start, int length) throws SAXException {
                if (this.contentBuffer != null) {
                    this.contentBuffer.append(ch, start, length);
                }
                if (this.currentMsgName != null) {
                    this.currentMsgValue.append(ch, start, length);
                }
            }

            /*
             * Unable to fully structure code
             */
            public void endElement(String uri, String localName, String qName) throws SAXException {
                block8: {
                    block6: {
                        block7: {
                            if (!"Content".equalsIgnoreCase(qName) || this.content == null || this.contentBuffer == null) break block6;
                            this.content.value = this.contentBuffer.toString();
                            t = new StringTokenizer(this.content.view, ",");
                            if (t.hasMoreTokens()) ** GOTO lbl10
                            this.module.contents.put("default", this.content);
                            break block7;
lbl-1000:
                            // 1 sources

                            {
                                this.module.contents.put(t.nextToken(), this.content);
lbl10:
                                // 2 sources

                                ** while (t.hasMoreTokens())
                            }
                        }
                        this.contentBuffer = null;
                        break block8;
                    }
                    if ("Locale".equalsIgnoreCase(qName)) {
                        this.locale = null;
                    } else if ("msg".equalsIgnoreCase(qName)) {
                        this.locale.messages.put(this.currentMsgName, this.currentMsgValue.toString());
                        this.currentMsgName = null;
                    } else if (this.contentBuffer != null) {
                        this.contentBuffer.append("</" + qName);
                        this.contentBuffer.append(">");
                    }
                }
                this.content = null;
            }
        });
        return result[0];
    }

    private static void addMessagesToMap(final Map<String, String> hangmanMap, String messagesURIString) throws Exception {
        DefaultHandler handler = new DefaultHandler(){
            String name;
            String value;

            public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
                this.name = attributes.getValue("name");
            }

            public void characters(char[] ch, int start, int length) throws SAXException {
                this.value = new String(ch, start, length);
            }

            public void endElement(String uri, String localName, String qName) throws SAXException {
                if ("msg".equalsIgnoreCase(qName) && this.name != null && this.value != null) {
                    hangmanMap.put("__MSG_" + this.name + "__", this.value);
                }
            }
        };
        OpenSocialUtil.parseXML(new URI(messagesURIString), handler);
    }

    private static void addMessagesToMap(Map<String, String> hangmanMap, Map<String, String> messages) {
        for (Map.Entry<String, String> entry : messages.entrySet()) {
            hangmanMap.put("__MSG_" + entry.getKey() + "__", entry.getValue());
        }
    }

    private static void parseXML(URI uri, DefaultHandler handler) throws MalformedURLException, IOException, ParserConfigurationException, SAXException {
        int charsetIndex;
        String contentType;
        URL messagesURL = uri.toURL();
        URLConnection connection = messagesURL.openConnection();
        String encoding = connection.getContentEncoding();
        if (encoding == null && (contentType = connection.getHeaderField("Content-Type")) != null && (charsetIndex = contentType.indexOf("charset=")) != -1) {
            int charsetBegin;
            int charsetEnd = charsetBegin = charsetIndex + "charset=".length();
            while (contentType.length() > charsetEnd && " ,;".indexOf(contentType.charAt(charsetEnd)) == -1) {
                ++charsetEnd;
            }
            if (charsetEnd > charsetBegin) {
                encoding = contentType.substring(charsetBegin, charsetEnd);
            }
        }
        InputStream is = connection.getInputStream();
        try {
            SAXParserFactory spf = SAXParserFactory.newInstance();
            SAXParser parser = spf.newSAXParser();
            InputSource source = new InputSource(is);
            if (encoding != null) {
                source.setEncoding(encoding);
            }
            parser.parse(source, handler);
        }
        finally {
            is.close();
        }
    }

    private static String hangmanExpand(String s, Map<String, String> hangmanMap) {
        int indexOfUnderscores;
        if (s == null) {
            return null;
        }
        StringBuffer result = new StringBuffer(s.length());
        int currentIndex = 0;
        while ((indexOfUnderscores = s.indexOf("__", currentIndex)) != -1) {
            result.append(s.substring(currentIndex, indexOfUnderscores));
            int indexOfNextUnderscores = s.indexOf("__", indexOfUnderscores + 2);
            if (indexOfNextUnderscores != -1) {
                String key = s.substring(indexOfUnderscores, indexOfNextUnderscores + 2);
                String value = hangmanMap.get(key);
                if (value != null) {
                    result.append(value);
                } else {
                    result.append(key);
                }
                currentIndex = indexOfNextUnderscores + 2;
                continue;
            }
            result.append("__");
            currentIndex = indexOfUnderscores + 2;
        }
        result.append(s.substring(currentIndex));
        return result.toString();
    }
}

