/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.internal.gadgets.opensocial;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Map;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.e4.ui.internal.gadgets.opensocial.OSGContent;
import org.eclipse.e4.ui.internal.gadgets.opensocial.OSGModule;
import org.eclipse.e4.ui.internal.gadgets.opensocial.OSGUserPref;
import org.eclipse.e4.ui.internal.gadgets.opensocial.OpenSocialUtil;
import org.eclipse.e4.ui.internal.gadgets.opensocial.browserfunctions.MakeXmlHttpRequest;
import org.eclipse.e4.ui.web.BrowserViewPart;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.browser.BrowserFunction;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.dialogs.PropertyDialogAction;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;

public class OpenSocialView
extends BrowserViewPart
implements IResourceChangeListener {
    public static final String NO_HEADER_VALUE = "undefined";
    public static final String HEADER_NAME_VALUE_SEPARATOR = "#";
    public static final String HEADERS_SEPARATOR = "\n";
    public static final String GET_METHOD = "GET";
    public static final String USERPREFS = "userprefs";
    private String url;
    private String html;
    private OSGModule module;
    private IMemento memento;
    private final String[] scripts = new String[]{"util.js", "io.js", "misc.js", "prefs.js", "window.js"};
    private Bundle bundle;
    private Action editPropertiesAction;
    private Action refreshAction;
    private IFile moduleFile;
    private BrowserFunction makeRequestBrowserFunction;

    protected String getNewWindowViewId() {
        return this.getSite().getId();
    }

    public void init(IViewSite site, IMemento memento) throws PartInitException {
        super.init(site, memento);
        this.url = site.getSecondaryId();
        this.memento = memento;
        this.bundle = FrameworkUtil.getBundle(((Object)((Object)this)).getClass());
        this.url = this.url.replace("%3A", ":");
        URI uri = URI.create(this.url);
        if (!uri.isAbsolute()) {
            return;
        }
        IFile[] files = ResourcesPlugin.getWorkspace().getRoot().findFilesForLocationURI(uri);
        if (files.length > 0) {
            this.moduleFile = files[0];
            this.moduleFile.getWorkspace().addResourceChangeListener((IResourceChangeListener)this, 1);
        }
    }

    public void createPartControl(Composite parent) {
        super.createPartControl(parent);
        this.makeActions();
        this.contributeToActionBars();
        this.contributeToToolBars();
    }

    private void makeActions() {
        this.editPropertiesAction = new Action(){

            public void run() {
                new PropertyDialogAction((IShellProvider)OpenSocialView.this.getSite(), new ISelectionProvider(){

                    public void setSelection(ISelection selection) {
                    }

                    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
                    }

                    public ISelection getSelection() {
                        return new StructuredSelection((Object)OpenSocialView.this.module);
                    }

                    public void addSelectionChangedListener(ISelectionChangedListener listener) {
                    }
                }).createDialog().open();
                OpenSocialView.this.configureBrowser(OpenSocialView.this.browser);
            }
        };
        this.editPropertiesAction.setText("Module settings");
        this.editPropertiesAction.setToolTipText("Edit Module Settings");
        this.refreshAction = new Action(){

            public void run() {
                OpenSocialView.this.module = null;
                OpenSocialView.this.configureBrowser(OpenSocialView.this.browser);
            }
        };
        this.refreshAction.setText("Refresh");
        this.refreshAction.setDisabledImageDescriptor(ImageDescriptor.createFromURL((URL)this.bundle.getEntry("/icons/full/dlcl16/refresh.gif")));
        this.refreshAction.setImageDescriptor(ImageDescriptor.createFromURL((URL)this.bundle.getEntry("/icons/full/elcl16/refresh.gif")));
        this.refreshAction.setToolTipText("Refresh module");
    }

    private void contributeToActionBars() {
        IActionBars bars = this.getViewSite().getActionBars();
        bars.getMenuManager().add((IAction)this.editPropertiesAction);
        bars.getMenuManager().update(true);
    }

    private void contributeToToolBars() {
        IActionBars bars = this.getViewSite().getActionBars();
        bars.getToolBarManager().add((IAction)this.refreshAction);
        bars.getToolBarManager().update(true);
    }

    private void registerBrowserFunctions() {
        if (this.makeRequestBrowserFunction != null) {
            this.makeRequestBrowserFunction.dispose();
        }
        this.makeRequestBrowserFunction = new MakeXmlHttpRequest(this.browser);
    }

    public void dispose() {
        if (this.moduleFile != null) {
            this.moduleFile.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this);
        }
        if (this.makeRequestBrowserFunction != null) {
            this.makeRequestBrowserFunction.dispose();
        }
        super.dispose();
    }

    public void saveState(IMemento memento) {
        this.saveUserPreferences(memento);
    }

    private void saveUserPreferences(IMemento memento) {
        IMemento node = memento.createChild(USERPREFS);
        for (OSGUserPref pref : this.module.getUserPrefs()) {
            node.putString(pref.getName(), pref.getValue());
        }
    }

    protected void configureBrowser(Browser browser) {
        this.registerBrowserFunctions();
        String localUrl = null;
        if (this.url != null) {
            final String uriForIcon = this.url = this.url.replace("%3A", ":");
            if (this.module == null) {
                this.module = OpenSocialUtil.loadModule(this.url);
                this.loadUserPreferences(this.module, this.memento);
            }
            this.setPartName(this.module.getTitle());
            this.setTitleToolTip(this.module.getDescription());
            Map<String, OSGContent> contents = this.module.getContents();
            OSGContent content = contents.get("home");
            if (content == null) {
                content = contents.get("default");
            }
            if (content == null) {
                content = contents.get("canvas");
            }
            if (content == null) {
                content = contents.get("");
            }
            if ("url".equalsIgnoreCase(content.getType())) {
                localUrl = content.getHref();
            } else if ("html".equalsIgnoreCase(content.getType())) {
                StringBuilder igFunctions = new StringBuilder();
                igFunctions.append("<head></head><script>\r\n");
                igFunctions.append("var gadgets = gadgets || {};\r\n");
                igFunctions.append("gadgets.Prefs = function() {\r\n");
                for (OSGUserPref userPref : this.module.getUserPrefs()) {
                    igFunctions.append("this." + userPref.getName());
                    igFunctions.append("='");
                    igFunctions.append(userPref.getValue());
                    igFunctions.append("';");
                }
                igFunctions.append("\r\n}\r\n\r\n");
                try {
                    String[] stringArray = this.scripts;
                    int n = this.scripts.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String script = stringArray[n2];
                        InputStream scriptInputStream = this.bundle.getEntry("js/" + script).openStream();
                        BufferedReader scriptReader = new BufferedReader(new InputStreamReader(scriptInputStream));
                        String line = null;
                        while ((line = scriptReader.readLine()) != null) {
                            igFunctions.append(String.valueOf(line) + "\r\n");
                        }
                        scriptReader.close();
                        ++n2;
                    }
                }
                catch (IOException iOException) {}
                igFunctions.append("\r\n</script>\r\n");
                this.html = String.valueOf(igFunctions.toString()) + content.getValue();
            }
            if (localUrl == null && this.html == null) {
                throw new RuntimeException("could not find Gadget URL");
            }
            if (uriForIcon != null) {
                Job job = new Job("Retrieve Icon for " + this.module.getTitle()){

                    protected IStatus run(IProgressMonitor monitor) {
                        URI uri;
                        try {
                            uri = new URI(uriForIcon);
                        }
                        catch (URISyntaxException uRISyntaxException) {
                            return Status.CANCEL_STATUS;
                        }
                        String host = uri.getHost();
                        try {
                            URL favicon = new URL("http://" + host + "/favicon.ico");
                            InputStream is = favicon.openConnection().getInputStream();
                            Display display = OpenSocialView.this.getSite().getWorkbenchWindow().getShell().getDisplay();
                            final Image icon = new Image((Device)display, is);
                            display.asyncExec(new Runnable(){

                                public void run() {
                                    OpenSocialView.this.setTitleImage(icon);
                                }
                            });
                        }
                        catch (MalformedURLException malformedURLException) {
                            return Status.CANCEL_STATUS;
                        }
                        catch (IOException iOException) {
                            return Status.CANCEL_STATUS;
                        }
                        catch (SWTException sWTException) {
                            return Status.CANCEL_STATUS;
                        }
                        return Status.OK_STATUS;
                    }
                };
                job.schedule();
            }
        } else {
            localUrl = "http://ig.gmodules.com/gadgets/ifr?view=home&url=http://hosting.gmodules.com/ig/gadgets/file/104276582316790234013/test-1.xml&nocache=0&up_feed=http://picasaweb.google.com/data/feed/base/user/picasateam/albumid/5114659638793351217%3Fkind%3Dphoto%26alt%3Drss%26hl%3Den_US&up_title=My+Picasa+Photos&up_gallery=&up_desc=1&lang=en&country=us&.lang=en&.country=us&synd=ig&mid=110&ifpctok=-6064860744303900509&exp_split_js=1&exp_track_js=1&exp_ids=17259,300668&parent=http://www.google.com&refresh=3600&libs=core:core.io:core.iglegacy&extern_js=/extern_js/f/CgJlbhICdXMrMNIBOAEs/SH2Zv0WBdfQ.js&is_signedin=1";
        }
        if (this.html != null) {
            browser.setText(this.html);
        }
        if (localUrl != null) {
            browser.setUrl(localUrl);
        }
    }

    private void loadUserPreferences(OSGModule module, IMemento memento) {
        if (memento == null) {
            return;
        }
        IMemento node = memento.getChild(USERPREFS);
        if (node == null) {
            return;
        }
        String[] stringArray = node.getAttributeKeys();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String key = stringArray[n2];
            for (OSGUserPref pref : module.getUserPrefs()) {
                if (!pref.getName().equals(key)) continue;
                pref.setValue(node.getString(key));
            }
            ++n2;
        }
    }

    public void resourceChanged(IResourceChangeEvent event) {
        IResourceDelta rootDelta = event.getDelta();
        if (rootDelta.findMember(this.moduleFile.getFullPath()) == null) {
            return;
        }
        try {
            event.getDelta().accept(new IResourceDeltaVisitor(){

                public boolean visit(IResourceDelta delta) throws CoreException {
                    if (delta.getResource() instanceof IContainer) {
                        return true;
                    }
                    if (OpenSocialView.this.moduleFile.equals((Object)delta.getResource())) {
                        if (delta.getKind() == 2) {
                            Display.getDefault().asyncExec(new Runnable(){

                                public void run() {
                                    OpenSocialView.this.getViewSite().getPage().hideView((IViewPart)OpenSocialView.this);
                                }
                            });
                        } else {
                            OpenSocialView.this.module = null;
                            OpenSocialView.this.configureBrowser(OpenSocialView.this.browser);
                        }
                    }
                    return false;
                }
            });
        }
        catch (CoreException coreException) {}
    }
}

