/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.xwt.tools.ui.designer.editor.outline;

import java.text.MessageFormat;
import org.eclipse.e4.xwt.metadata.IMetaclass;
import org.eclipse.e4.xwt.tools.ui.designer.parts.DiagramEditPart;
import org.eclipse.e4.xwt.tools.ui.designer.parts.ViewerEditPart;
import org.eclipse.e4.xwt.tools.ui.designer.parts.WidgetEditPart;
import org.eclipse.e4.xwt.tools.ui.designer.resources.ImageShop;
import org.eclipse.e4.xwt.tools.ui.designer.utils.XWTUtility;
import org.eclipse.e4.xwt.tools.ui.xaml.XamlAttribute;
import org.eclipse.e4.xwt.tools.ui.xaml.XamlDocument;
import org.eclipse.e4.xwt.tools.ui.xaml.XamlNode;
import org.eclipse.e4.xwt.tools.ui.xaml.tools.AnnotationTools;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Widget;

public class OutlineLabelProvider
extends LabelProvider {
    private GraphicalViewer graphicalViewer;

    public OutlineLabelProvider() {
        this(null);
    }

    public OutlineLabelProvider(GraphicalViewer graphicalViewer) {
        this.graphicalViewer = graphicalViewer;
    }

    public String getText(Object element) {
        if (element instanceof XamlNode) {
            return this.getText((XamlNode)element);
        }
        if (element instanceof XamlDocument) {
            return "(widget)";
        }
        if (element instanceof EditPart) {
            return this.getText(((EditPart)element).getModel());
        }
        if (element instanceof IStructuredSelection) {
            return this.getText(((IStructuredSelection)element).getFirstElement());
        }
        return super.getText(element);
    }

    private String getText(XamlNode node) {
        if (AnnotationTools.isAnnotated((XamlNode)node, (String)"Filter_DATA")) {
            return "(filler)";
        }
        String name = node.getName();
        IMetaclass metaclass = XWTUtility.getMetaclass(node);
        if (metaclass != null) {
            XamlAttribute nameAttr;
            XamlAttribute textAttr = node.getAttribute("text");
            if (textAttr == null) {
                textAttr = node.getAttribute("text", "http://www.eclipse.org/xwt/presentation");
            }
            if ((nameAttr = node.getAttribute("name", "http://www.eclipse.org/xwt/presentation")) == null) {
                nameAttr = node.getAttribute("name", "http://www.eclipse.org/xwt");
            }
            String value = null;
            if (nameAttr != null && nameAttr.getValue() != null) {
                value = MessageFormat.format("\"{0}\"", nameAttr.getValue());
            } else if (textAttr != null && textAttr.getValue() != null) {
                value = MessageFormat.format("\"{0}\"", textAttr.getValue());
            }
            if (value != null) {
                name = MessageFormat.format("{0} - {1}", name, value);
            }
        }
        return name;
    }

    public Image getImage(Object element) {
        if (element instanceof XamlDocument) {
            return ImageShop.get("/icons/full/tools/xaml.png");
        }
        if (element instanceof XamlNode) {
            EditPart editPart;
            Image image;
            XamlNode xamlNode = (XamlNode)element;
            if (this.graphicalViewer != null && (image = this.getImageFrom(editPart = (EditPart)this.graphicalViewer.getEditPartRegistry().get(xamlNode))) != null) {
                return image;
            }
            String name = xamlNode.getName();
            return ImageShop.getObj16(name.toLowerCase());
        }
        return super.getImage(element);
    }

    private Image getImageFrom(EditPart editPart) {
        if (editPart instanceof WidgetEditPart) {
            Widget widget = ((WidgetEditPart)editPart).getWidget();
            return ImageShop.getImageForWidget(widget);
        }
        if (editPart instanceof ViewerEditPart) {
            Viewer viewer = ((ViewerEditPart)editPart).getJfaceViewer();
            if (viewer != null) {
                String name = viewer.getClass().getSimpleName().toLowerCase();
                return ImageShop.getObj16(name);
            }
        } else if (editPart instanceof DiagramEditPart) {
            return ImageShop.get("/icons/full/tools/xaml.png");
        }
        return null;
    }
}

