/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.platform.discovery.ui.internal.search.advancedparams;

import org.eclipse.core.runtime.Platform;
import org.eclipse.platform.discovery.runtime.api.ISearchDestination;
import org.eclipse.platform.discovery.runtime.api.ISearchParameters;
import org.eclipse.platform.discovery.runtime.internal.DestinationCategoryNotFoundException;
import org.eclipse.platform.discovery.runtime.internal.ISearchProviderConfiguration;
import org.eclipse.platform.discovery.runtime.internal.ProviderNotFoundException;
import org.eclipse.platform.discovery.runtime.internal.model.descriptions.IDestinationCategoryDescription;
import org.eclipse.platform.discovery.runtime.internal.model.descriptions.IObjectTypeDescription;
import org.eclipse.platform.discovery.runtime.internal.model.descriptions.ISearchProviderDescription;
import org.eclipse.platform.discovery.ui.api.IAdvancedSearchParamsUiContributor;
import org.eclipse.platform.discovery.ui.api.IViewUiContext;
import org.eclipse.platform.discovery.ui.internal.plugin.DiscoveryUIMessages;
import org.eclipse.platform.discovery.ui.internal.search.advancedparams.IAdvancedSearchParamsDisplayer;
import org.eclipse.platform.discovery.ui.internal.search.advancedparams.IAdvancedSearchParamsUiContributorDescr;
import org.eclipse.platform.discovery.ui.internal.xp.IAdvancedSearchParamsUiContribXpParser;
import org.eclipse.platform.discovery.ui.internal.xp.impl.AdvancedSearchParamsUiContribXpParser;
import org.eclipse.platform.discovery.util.api.env.IDiscoveryEnvironment;
import org.eclipse.platform.discovery.util.internal.property.IPropertyAttributeListener;
import org.eclipse.platform.discovery.util.internal.property.Property;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.events.ExpansionAdapter;
import org.eclipse.ui.forms.events.ExpansionEvent;
import org.eclipse.ui.forms.events.IExpansionListener;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;

public abstract class AdvancedSearchParamsDisplayer
implements IAdvancedSearchParamsDisplayer {
    private final FormToolkit formToolkit;
    private final IAdvancedSearchParamsUiContribXpParser searchParamsContribParser;
    private Section _paramsSection;
    private final Property<Point> sectionSizeProperty;
    private final Composite parentComposite;
    private final Property<IAdvancedSearchParamsUiContributor> currentUiContributor;
    private final Property<ISearchDestination> currentSearchDestination;
    private final Property<IDiscoveryEnvironment> currentEnvironment;
    private final Property<IViewUiContext> uiContext;

    public AdvancedSearchParamsDisplayer(Composite parentComposite, FormToolkit toolkit) {
        this.formToolkit = toolkit;
        this.parentComposite = parentComposite;
        this.sectionSizeProperty = new Property();
        this.sectionSizeProperty.set((Object)new Point(0, 0));
        this.searchParamsContribParser = this.createAdvancedSearchUiContribXpParser();
        this.currentUiContributor = new Property();
        this.currentSearchDestination = new Property();
        this.currentEnvironment = new Property();
        this.uiContext = new Property();
    }

    public IAdvancedSearchParamsUiContributor getUiContributor() {
        return (IAdvancedSearchParamsUiContributor)this.currentUiContributor.get();
    }

    @Override
    public void update(IObjectTypeDescription objectType, ISearchDestination searchDestination, IDiscoveryEnvironment environment, IViewUiContext uiContext) {
        this.currentUiContributor.set((Object)this.findUiContributor(objectType, searchDestination));
        this.currentSearchDestination.set((Object)searchDestination);
        this.currentEnvironment.set((Object)environment);
        this.uiContext.set((Object)uiContext);
        this.setEnabled(this.currentUiContributor.get() != null);
    }

    private void updateSectionContent() {
        assert (this.currentUiContributor.get() != null);
        Control oldClient = this.parametersSection().getClient();
        this.parametersSection().setClient((Control)this.createParametersComposite((Composite)this.parametersSection(), (IAdvancedSearchParamsUiContributor)this.currentUiContributor.get(), (ISearchDestination)this.currentSearchDestination.get(), (IDiscoveryEnvironment)this.currentEnvironment.get(), (IViewUiContext)this.uiContext.get()));
        if (oldClient != null) {
            oldClient.dispose();
        }
        this.updateParametersSectionText();
        this.parentComposite.getParent().layout();
        this.updateSectionSizeProperty(this.sectionSize(this.parametersSection()));
    }

    private void updateParametersSectionText() {
        if (this.parametersSection().isExpanded()) {
            this.parametersSection().setText(DiscoveryUIMessages.CUSTOM_PARAMS_SECTION_COLAPSE_TITLE);
        } else {
            this.parametersSection().setText(DiscoveryUIMessages.CUSTOM_PARAMS_SECTION_EXPAND_TITLE);
        }
    }

    private Composite createParametersComposite(Composite parent, IAdvancedSearchParamsUiContributor uiContributor, ISearchDestination destination, IDiscoveryEnvironment environment, IViewUiContext uiContext) {
        Composite parametersComposite = this.createParametersContainingComposite(parent);
        parametersComposite.setLayoutData((Object)this.fillingFormData());
        uiContributor.createUi(parametersComposite, destination, this.formToolkit, environment, uiContext);
        return parametersComposite;
    }

    protected Composite createParametersContainingComposite(Composite parent) {
        return this.createCompositeWithFormLayout(parent);
    }

    private Section createParametersSection(Composite parent) {
        final Section section = this.formToolkit.createSection(parent, 322);
        section.setActiveToggleColor(this.formToolkit.getHyperlinkGroup().getActiveForeground());
        section.setToggleColor(this.formToolkit.getColors().getColor("org.eclipse.ui.forms.SEPARATOR"));
        section.setText(DiscoveryUIMessages.CUSTOM_PARAMS_SECTION_EXPAND_TITLE);
        section.setLayoutData((Object)this.fillingFormData());
        section.setExpanded(false);
        section.addExpansionListener((IExpansionListener)new ExpansionAdapter(){

            public void expansionStateChanged(ExpansionEvent e) {
                AdvancedSearchParamsDisplayer.this.updateParametersSectionText();
                section.layout(true);
                AdvancedSearchParamsDisplayer.this.updateSectionSizeProperty(AdvancedSearchParamsDisplayer.this.sectionSize(section));
                AdvancedSearchParamsDisplayer.this.getUiContributor().handleVisibilityChange(section.isExpanded());
            }
        });
        return section;
    }

    private void updateSectionSizeProperty(Point size) {
        this.sectionSizeProperty.set((Object)size);
    }

    protected IAdvancedSearchParamsUiContribXpParser createAdvancedSearchUiContribXpParser() {
        return new AdvancedSearchParamsUiContribXpParser(Platform.getExtensionRegistry());
    }

    protected abstract ISearchProviderConfiguration searchProviderConfiguration();

    private Composite createCompositeWithFormLayout(Composite parent) {
        Composite c = new Composite(parent, 0);
        c.setLayout((Layout)new FormLayout());
        return c;
    }

    private IAdvancedSearchParamsUiContributor findUiContributor(IObjectTypeDescription objectType, ISearchDestination destination) {
        if (destination == null || objectType == null) {
            return null;
        }
        try {
            IDestinationCategoryDescription category = (IDestinationCategoryDescription)this.searchProviderConfiguration().getDestinationCategoriesForDestination(destination).iterator().next();
            ISearchProviderDescription searchProvider = this.searchProviderConfiguration().getActiveSearchProvider(objectType, category);
            for (IAdvancedSearchParamsUiContributorDescr contributorDescr : this.searchParamsContribParser.readContributions()) {
                if (!contributorDescr.getSearchProviderId().equals(searchProvider.getId())) continue;
                return contributorDescr.createContributor();
            }
        }
        catch (DestinationCategoryNotFoundException e) {
            throw new IllegalStateException(e);
        }
        catch (ProviderNotFoundException e) {
            throw new IllegalStateException(e);
        }
        return null;
    }

    private FormData fillingFormData() {
        FormData fd = new FormData();
        fd.left = new FormAttachment(0, 0);
        fd.right = new FormAttachment(100, 0);
        return fd;
    }

    public void setEnabled(boolean enabled) {
        if (enabled) {
            this.updateSectionContent();
        } else {
            this.disposeSection();
        }
    }

    public boolean isEnabled() {
        return this._isSectionShowing();
    }

    @Override
    public void setParams(ISearchParameters searchParams) {
        if (this.getUiContributor() == null) {
            return;
        }
        searchParams.getCustomParameters().putAll(this.getUiContributor().getParameters());
    }

    @Override
    public void registerSizePropertyChangeListener(IPropertyAttributeListener<Point> listener, boolean notifyCurrent) {
        this.sectionSizeProperty.registerValueListener(listener, notifyCurrent);
    }

    private Section parametersSection() {
        if (!this._isSectionShowing()) {
            this._paramsSection = this.createParametersSection(this.parentComposite);
        }
        return this._paramsSection;
    }

    private boolean _isSectionShowing() {
        return this._paramsSection != null && !this._paramsSection.isDisposed();
    }

    private void disposeSection() {
        if (this._isSectionShowing()) {
            this._paramsSection.dispose();
        }
        this.updateSectionSizeProperty(new Point(0, 0));
    }

    private Point sectionSize(Section section) {
        return section.computeSize(-1, -1);
    }
}

