/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.tm.ui;

import java.text.MessageFormat;
import org.eclipse.e4.tm.ui.Activator;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.jface.viewers.BaseLabelProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class TmLabelProvider
extends BaseLabelProvider
implements ILabelProvider {
    private ILabelProvider defaultLabelProvider;
    private static final int MAX_TEXT_LENGTH = 50;

    public TmLabelProvider(ILabelProvider defaultLabelProvider) {
        this.defaultLabelProvider = defaultLabelProvider;
    }

    public Image getImage(Object object) {
        if (object instanceof EObject) {
            EObject eObject = (EObject)object;
            EClass eClass = eObject.eClass();
            while (eClass != null) {
                Image image = this.getImageForEClass(eClass, eObject.eClass());
                if (image != null) {
                    return image;
                }
                EList eSuperTypes = eClass.getESuperTypes();
                EClass eClass2 = eClass = eSuperTypes.size() > 0 ? (EClass)eSuperTypes.get(0) : null;
            }
        }
        return this.defaultLabelProvider.getImage(object);
    }

    private String getImageKey(EClass eClass) {
        String imageKey = EcoreUtil.getAnnotation((EModelElement)eClass, (String)"org.eclipse.e4.tm.ui", (String)"imageUri");
        if (imageKey == null) {
            imageKey = "icons/obj16/" + eClass.getName() + ".gif";
        }
        return imageKey;
    }

    private Image getImageForEClass(EClass eClass, EClass forClass) {
        String imageKey;
        ImageRegistry imageRegistry = Activator.getDefault().getImageRegistry();
        Image image = imageRegistry.get(imageKey = this.getImageKey(eClass));
        if (image == null) {
            ImageDescriptor imageDescriptor;
            String pluginId = "org.eclipse.e4.tm.ui";
            String imageName = imageKey;
            int pos = imageKey.indexOf(35);
            if (pos > 0) {
                pluginId = imageKey.substring(0, pos);
                imageName = imageKey.substring(pos + 1);
            }
            if ((imageDescriptor = AbstractUIPlugin.imageDescriptorFromPlugin((String)pluginId, (String)imageName)) != null) {
                image = imageDescriptor.createImage();
                imageRegistry.put(imageKey, image);
                if (forClass != null && forClass != eClass) {
                    imageRegistry.put(this.getImageKey(forClass), image);
                }
            }
        }
        return image;
    }

    private Object tryTextFeature(Object textValue, EObject eObject, String featureName, String format) {
        EStructuralFeature textFeature;
        if (textValue == null && featureName != null && (textFeature = eObject.eClass().getEStructuralFeature(featureName)) != null) {
            textValue = eObject.eGet(textFeature);
            if (textValue instanceof String && ((String)textValue).length() == 0) {
                textValue = null;
            }
            if (textValue != null && format != null) {
                textValue = MessageFormat.format(format, textValue);
            }
        }
        return textValue;
    }

    public String getText(Object object) {
        String text = null;
        if (object instanceof EObject) {
            EObject eObject = (EObject)object;
            EClass eClass = eObject.eClass();
            text = eClass.getName();
            Object textValue = null;
            textValue = this.tryTextFeature(textValue, eObject, EcoreUtil.getAnnotation((EModelElement)eClass, (String)"org.eclipse.e4.tm.ui", (String)"labelFeature"), EcoreUtil.getAnnotation((EModelElement)eClass, (String)"org.eclipse.e4.tm.ui", (String)"labelFormat"));
            textValue = this.tryTextFeature(textValue, eObject, "name", null);
            textValue = this.tryTextFeature(textValue, eObject, "text", "\"{0}\"");
            if ((textValue = this.tryTextFeature(textValue, eObject, "id", "#{0}")) != null) {
                text = String.valueOf(text) + " " + textValue;
            }
        }
        if (text != null) {
            if (text.length() > 50) {
                String truncSuffix = "...";
                text = String.valueOf(text.substring(0, 50 - truncSuffix.length())) + truncSuffix;
            }
            return text;
        }
        return this.defaultLabelProvider.getText(object);
    }
}

