/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.resources.semantic.spi;

import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.semantic.spi.ISemanticFileStore;
import org.eclipse.core.resources.semantic.spi.ISemanticTreeDeepFirstVisitor;
import org.eclipse.core.resources.semantic.spi.ISemanticTreeVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;

public class SemanticTreeWalker {
    public static void accept(ISemanticFileStore root, ISemanticTreeVisitor visitor, IProgressMonitor monitor) throws CoreException {
        boolean recurse = visitor.visit(root, monitor);
        if (recurse) {
            IFileStore[] iFileStoreArray = root.childStores(0, monitor);
            int n = iFileStoreArray.length;
            int n2 = 0;
            while (n2 < n) {
                IFileStore store = iFileStoreArray[n2];
                recurse = visitor.visit((ISemanticFileStore)store, monitor);
                if (recurse) {
                    SemanticTreeWalker.accept((ISemanticFileStore)store, visitor, monitor);
                }
                ++n2;
            }
        }
    }

    public static void accept(ISemanticFileStore root, ISemanticTreeDeepFirstVisitor visitor, IProgressMonitor monitor) throws CoreException {
        boolean recurse = visitor.shouldVisitChildren(root, monitor);
        if (recurse) {
            IFileStore[] iFileStoreArray = root.childStores(0, monitor);
            int n = iFileStoreArray.length;
            int n2 = 0;
            while (n2 < n) {
                IFileStore store = iFileStoreArray[n2];
                SemanticTreeWalker.accept((ISemanticFileStore)store, visitor, monitor);
                ++n2;
            }
        }
        visitor.visit(root, monitor);
    }
}

