/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.core.deeplink.internal;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import org.eclipse.e4.core.deeplink.DeepLinkResult;
import org.eclipse.e4.core.deeplink.DeepLinkResultException;
import org.eclipse.e4.core.deeplink.internal.InstallationLauncher;

public class DeepLinkProxy {
    private InstallationLauncher installationLauncher;
    private static final int INITIAL_WAIT = 1500;
    private static final int SUBSEQUENT_WAIT = 500;
    private final long TIMEOUT_DURATION = 60000L;

    public DeepLinkProxy(InstallationLauncher installationLauncher) {
        this.installationLauncher = installationLauncher;
    }

    public DeepLinkResult execute(String installation, URL httpDeepLink, String originalDeepLink) throws IOException, DeepLinkResultException {
        try {
            return this.proxyDeepLinkURL(httpDeepLink);
        }
        catch (IOException iOException) {
            this.installationLauncher.startInstallation(installation, originalDeepLink);
            return this.invokeDeepLinkWithTimeout(installation, httpDeepLink);
        }
    }

    private DeepLinkResult invokeDeepLinkWithTimeout(String installation, URL httpDeepLink) {
        this.pause(1500L);
        long timeout = System.currentTimeMillis() + 60000L;
        while (true) {
            try {
                return this.proxyDeepLinkURL(httpDeepLink);
            }
            catch (IOException iOException) {
                if (System.currentTimeMillis() > timeout) {
                    throw new DeepLinkResultException("Timeout invoking deep link: [" + installation + "]: " + httpDeepLink);
                }
                this.pause(500L);
                continue;
            }
            break;
        }
    }

    private void pause(long duration) {
        try {
            Thread.sleep(duration);
        }
        catch (InterruptedException interruptedException) {}
    }

    private DeepLinkResult proxyDeepLinkURL(URL httpDeepLink) throws IOException, DeepLinkResultException {
        InputStream resultStream = httpDeepLink.openStream();
        try {
            DeepLinkResult deepLinkResult = new DeepLinkResult(resultStream);
            return deepLinkResult;
        }
        finally {
            if (resultStream != null) {
                resultStream.close();
            }
        }
    }
}

