/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.xwt.tests.snipppets;

import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.ValidationStatusProvider;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.core.databinding.observable.list.WritableList;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.observable.value.WritableValue;
import org.eclipse.core.databinding.validation.MultiValidator;
import org.eclipse.core.databinding.validation.ValidationStatus;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.databinding.swt.ISWTObservableValue;
import org.eclipse.jface.databinding.swt.SWTObservables;
import org.eclipse.jface.databinding.viewers.ObservableListContentProvider;
import org.eclipse.jface.databinding.wizard.WizardPageSupport;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ListViewer;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Text;

public class Snippet021MultiFieldValidation
extends WizardPage {
    private List list_1;
    private List list;
    private Button addAddendButton;
    private Button removeAddendButton;
    private Text sumModelValue;
    private Text field2ModelValue;
    private Text field1ModelValue;
    private Text sumTarget;
    private Text field2Target;
    private Text field1Target;
    private ListViewer addendsTarget;
    private ListViewer addendsModelValue;

    public Snippet021MultiFieldValidation() {
        super("snippet021");
        this.setTitle("Snippet 021 - Multi-field Validators");
        this.setDescription("Enter values which satisfy the cross-field constraints");
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        container.setLayout((Layout)gridLayout);
        this.setControl((Control)container);
        Group bothEvenOrGroup = new Group(container, 0);
        bothEvenOrGroup.setLayoutData((Object)new GridData(4, 4, false, false));
        bothEvenOrGroup.setText("Numbers must be both even or both odd");
        GridLayout gridLayout_1 = new GridLayout();
        gridLayout_1.numColumns = 3;
        bothEvenOrGroup.setLayout((Layout)gridLayout_1);
        new Label((Composite)bothEvenOrGroup, 0);
        Label targetLabel = new Label((Composite)bothEvenOrGroup, 0);
        targetLabel.setText("Target");
        Label modelLabel = new Label((Composite)bothEvenOrGroup, 0);
        modelLabel.setText("Model");
        Label field1Label = new Label((Composite)bothEvenOrGroup, 0);
        field1Label.setText("Field 1");
        this.field1Target = new Text((Composite)bothEvenOrGroup, 2048);
        GridData gd_field1Target = new GridData(4, 0x1000000, true, false);
        this.field1Target.setLayoutData((Object)gd_field1Target);
        this.field1ModelValue = new Text((Composite)bothEvenOrGroup, 2056);
        GridData gd_field1ModelValue = new GridData(4, 0x1000000, true, false);
        this.field1ModelValue.setLayoutData((Object)gd_field1ModelValue);
        Label field2Label = new Label((Composite)bothEvenOrGroup, 0);
        field2Label.setText("Field 2");
        this.field2Target = new Text((Composite)bothEvenOrGroup, 2048);
        GridData gd_field2Target = new GridData(4, 0x1000000, true, false);
        this.field2Target.setLayoutData((Object)gd_field2Target);
        this.field2ModelValue = new Text((Composite)bothEvenOrGroup, 2056);
        GridData gd_field2ModelValue = new GridData(4, 0x1000000, true, false);
        this.field2ModelValue.setLayoutData((Object)gd_field2ModelValue);
        Group sumOfAllGroup = new Group(container, 0);
        sumOfAllGroup.setLayoutData((Object)new GridData(4, 4, false, true));
        sumOfAllGroup.setText("Addends must add up to sum");
        GridLayout gridLayout_2 = new GridLayout();
        gridLayout_2.numColumns = 3;
        sumOfAllGroup.setLayout((Layout)gridLayout_2);
        new Label((Composite)sumOfAllGroup, 0);
        Label targetLabel_1 = new Label((Composite)sumOfAllGroup, 0);
        targetLabel_1.setText("Target");
        Label modelLabel_1 = new Label((Composite)sumOfAllGroup, 0);
        modelLabel_1.setText("Model");
        Label expectedSumLabel = new Label((Composite)sumOfAllGroup, 0);
        expectedSumLabel.setText("Sum");
        this.sumTarget = new Text((Composite)sumOfAllGroup, 2048);
        GridData gd_sumTarget = new GridData(4, 0x1000000, true, false);
        this.sumTarget.setLayoutData((Object)gd_sumTarget);
        this.sumModelValue = new Text((Composite)sumOfAllGroup, 2056);
        GridData gd_sumModelValue = new GridData(4, 0x1000000, true, false);
        this.sumModelValue.setLayoutData((Object)gd_sumModelValue);
        Label addendsLabel = new Label((Composite)sumOfAllGroup, 0);
        addendsLabel.setText("Addends");
        this.addendsTarget = new ListViewer((Composite)sumOfAllGroup, 2560);
        this.list_1 = this.addendsTarget.getList();
        this.list_1.setLayoutData((Object)new GridData(4, 4, false, true, 1, 2));
        this.addendsModelValue = new ListViewer((Composite)sumOfAllGroup, 2560);
        this.list = this.addendsModelValue.getList();
        this.list.setLayoutData((Object)new GridData(4, 4, false, true, 1, 2));
        Composite composite = new Composite((Composite)sumOfAllGroup, 0);
        composite.setLayoutData((Object)new GridData(4, 4, false, false));
        GridLayout gridLayout_3 = new GridLayout();
        gridLayout_3.marginWidth = 0;
        gridLayout_3.marginHeight = 0;
        composite.setLayout((Layout)gridLayout_3);
        this.addAddendButton = new Button(composite, 0);
        this.addAddendButton.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        this.addAddendButton.setText("Add");
        this.removeAddendButton = new Button(composite, 0);
        this.removeAddendButton.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        this.removeAddendButton.setText("Remove");
        this.bindUI();
    }

    private void bindUI() {
        DataBindingContext dbc = new DataBindingContext();
        this.bindEvensAndOddsGroup(dbc);
        this.bindSumAndAddendsGroup(dbc);
        WizardPageSupport.create((WizardPage)this, (DataBindingContext)dbc);
    }

    private void bindEvensAndOddsGroup(DataBindingContext dbc) {
        ISWTObservableValue targetField1 = SWTObservables.observeText((Control)this.field1Target, (int)24);
        WritableValue middleField1 = new WritableValue(null, Integer.TYPE);
        dbc.bindValue((IObservableValue)targetField1, (IObservableValue)middleField1);
        ISWTObservableValue targetField2 = SWTObservables.observeText((Control)this.field2Target, (int)24);
        WritableValue middleField2 = new WritableValue(null, Integer.TYPE);
        dbc.bindValue((IObservableValue)targetField2, (IObservableValue)middleField2);
        MultiValidator validator = new MultiValidator((IObservableValue)middleField1, (IObservableValue)middleField2){
            private final /* synthetic */ IObservableValue val$middleField1;
            private final /* synthetic */ IObservableValue val$middleField2;
            {
                this.val$middleField1 = iObservableValue;
                this.val$middleField2 = iObservableValue2;
            }

            protected IStatus validate() {
                Integer field1 = (Integer)this.val$middleField1.getValue();
                Integer field2 = (Integer)this.val$middleField2.getValue();
                if (Math.abs(field1) % 2 != Math.abs(field2) % 2) {
                    return ValidationStatus.error((String)"Fields 1 and 2 must be both even or both odd");
                }
                return null;
            }
        };
        dbc.addValidationStatusProvider((ValidationStatusProvider)validator);
        WritableValue modelField1 = new WritableValue((Object)new Integer(1), Integer.TYPE);
        WritableValue modelField2 = new WritableValue((Object)new Integer(4), Integer.TYPE);
        dbc.bindValue(validator.observeValidatedValue((IObservableValue)middleField1), (IObservableValue)modelField1);
        dbc.bindValue(validator.observeValidatedValue((IObservableValue)middleField2), (IObservableValue)modelField2);
        dbc.bindValue((IObservableValue)SWTObservables.observeText((Control)this.field1ModelValue, (int)24), (IObservableValue)modelField1);
        dbc.bindValue((IObservableValue)SWTObservables.observeText((Control)this.field2ModelValue, (int)24), (IObservableValue)modelField2);
    }

    private void bindSumAndAddendsGroup(DataBindingContext dbc) {
        ISWTObservableValue targetSum = SWTObservables.observeText((Control)this.sumTarget, (int)24);
        WritableValue middleSum = new WritableValue(null, Integer.TYPE);
        dbc.bindValue((IObservableValue)targetSum, (IObservableValue)middleSum);
        WritableList targetAddends = new WritableList(new ArrayList(), Integer.TYPE);
        this.addendsTarget.setContentProvider((IContentProvider)new ObservableListContentProvider());
        this.addendsTarget.setInput((Object)targetAddends);
        this.addAddendButton.addSelectionListener((SelectionListener)new SelectionAdapter((IObservableList)targetAddends){
            private final /* synthetic */ IObservableList val$targetAddends;
            {
                this.val$targetAddends = iObservableList;
            }

            public void widgetSelected(SelectionEvent e) {
                InputDialog dialog = new InputDialog(Snippet021MultiFieldValidation.this.getShell(), "Input addend", "Enter an integer addend", "0", new IInputValidator(){

                    public String isValid(String newText) {
                        try {
                            Integer.valueOf(newText);
                            return null;
                        }
                        catch (NumberFormatException numberFormatException) {
                            return "Enter a number between -2147483648 and 2147483647";
                        }
                    }
                });
                if (dialog.open() == 0) {
                    this.val$targetAddends.add((Object)Integer.valueOf(dialog.getValue()));
                }
            }
        });
        this.removeAddendButton.addSelectionListener((SelectionListener)new SelectionAdapter((IObservableList)targetAddends){
            private final /* synthetic */ IObservableList val$targetAddends;
            {
                this.val$targetAddends = iObservableList;
            }

            public void widgetSelected(SelectionEvent e) {
                IStructuredSelection selection = (IStructuredSelection)Snippet021MultiFieldValidation.this.addendsTarget.getSelection();
                if (!selection.isEmpty()) {
                    this.val$targetAddends.remove(selection.getFirstElement());
                }
            }
        });
        WritableValue modelSum = new WritableValue((Object)new Integer(5), Integer.TYPE);
        dbc.bindValue((IObservableValue)SWTObservables.observeText((Control)this.sumModelValue, (int)24), (IObservableValue)modelSum);
        WritableList modelAddends = new WritableList(new ArrayList(), Integer.TYPE);
        MultiValidator validator = new MultiValidator((IObservableValue)middleSum, (IObservableList)targetAddends){
            private final /* synthetic */ IObservableValue val$middleSum;
            private final /* synthetic */ IObservableList val$targetAddends;
            {
                this.val$middleSum = iObservableValue;
                this.val$targetAddends = iObservableList;
            }

            protected IStatus validate() {
                Integer sum = (Integer)this.val$middleSum.getValue();
                int actualSum = 0;
                Iterator iterator = this.val$targetAddends.iterator();
                while (iterator.hasNext()) {
                    actualSum += ((Integer)iterator.next()).intValue();
                }
                if (sum != actualSum) {
                    return ValidationStatus.error((String)("Sum of addends is " + actualSum + ", expecting " + sum));
                }
                return ValidationStatus.ok();
            }
        };
        dbc.addValidationStatusProvider((ValidationStatusProvider)validator);
        this.addendsModelValue.setContentProvider((IContentProvider)new ObservableListContentProvider());
        this.addendsModelValue.setInput((Object)modelAddends);
        dbc.bindValue(validator.observeValidatedValue((IObservableValue)middleSum), (IObservableValue)modelSum);
        dbc.bindList(validator.observeValidatedList((IObservableList)targetAddends), (IObservableList)modelAddends);
    }

    public static void main(String[] args) {
        Display display = new Display();
        Realm.runWithDefault((Realm)SWTObservables.getRealm((Display)display), (Runnable)new Runnable(){

            public void run() {
                MultiFieldValidationWizard wizard = new MultiFieldValidationWizard();
                WizardDialog dialog = new WizardDialog(null, (IWizard)wizard);
                dialog.open();
                Display display = Display.getCurrent();
                while (dialog.getShell() != null && !dialog.getShell().isDisposed()) {
                    if (display.readAndDispatch()) continue;
                    display.sleep();
                }
            }
        });
        display.dispose();
    }

    static class MultiFieldValidationWizard
    extends Wizard {
        MultiFieldValidationWizard() {
        }

        public void addPages() {
            this.addPage((IWizardPage)new Snippet021MultiFieldValidation());
        }

        public String getWindowTitle() {
            return "Snippet 021 - Multi-field Validation";
        }

        public boolean performFinish() {
            return true;
        }
    }
}

